/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.digitalmediaserver.crowdin.api.CrowdinAPI;
import org.digitalmediaserver.crowdin.api.response.BranchInfo;
import org.digitalmediaserver.crowdin.configuration.StatusFile;
import org.digitalmediaserver.crowdin.configuration.TranslationFileSet;
import org.digitalmediaserver.crowdin.tool.GitUtil;
import org.digitalmediaserver.crowdin.tool.StringUtil;

@SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD", "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD"})
public abstract class AbstractCrowdinMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="timeout")
    protected Integer httpTimeout;
    @Parameter(property="downloadFolder", required=true)
    protected File downloadFolder;
    protected Path downloadFolderPath;
    @Parameter(property="comment")
    protected String comment;
    @Parameter(property="lineSeparator")
    protected String lineSeparator;
    @Parameter(defaultValue="false")
    protected Boolean disableBranches;
    @Parameter
    protected String gitBaseFolder;
    @Parameter(property="rootBranch", defaultValue="master")
    protected String rootBranch;
    @Parameter(property="crowdinServerId", required=true)
    protected String crowdinServerId;
    @Parameter(property="projectId", required=true)
    protected long projectId;
    @Parameter(property="translationFileSets", required=true)
    protected List<TranslationFileSet> translationFileSets;
    @Parameter(property="statusFiles", required=true)
    protected List<StatusFile> statusFiles;
    protected CloseableHttpClient client;
    protected Server server;

    protected void setProject(MavenProject value) {
        this.project = value;
    }

    protected void setHTTPTimeout(Integer timeout) {
        this.httpTimeout = timeout;
    }

    protected void setDownloadFolder(Path folder) {
        this.downloadFolder = folder.toFile();
        this.downloadFolderPath = folder;
    }

    protected void setDownloadFolder(File folder) {
        this.downloadFolder = folder;
        this.downloadFolderPath = folder.toPath();
    }

    protected void setComment(String comment) {
        this.comment = comment;
    }

    protected void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    protected void setDisableBranches(Boolean disableBranches) {
        this.disableBranches = disableBranches;
    }

    protected void setGitBaseFolder(String gitBaseFolder) {
        this.gitBaseFolder = gitBaseFolder;
    }

    protected void setRootBranch(String branch) {
        this.rootBranch = branch;
    }

    protected void setCrowdinServerId(String serverId) {
        this.crowdinServerId = serverId;
    }

    protected void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    protected void setTranslationFileSets(List<TranslationFileSet> translationFileSets) {
        this.translationFileSets = translationFileSets;
    }

    protected void setStatusFiles(List<StatusFile> statusFiles) {
        this.statusFiles = statusFiles;
    }

    protected void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    protected void setServer(Server server) {
        this.server = server;
    }

    protected void initializeServer() throws MojoExecutionException {
        if (this.server == null) {
            if (StringUtil.isBlank(this.crowdinServerId)) {
                throw new MojoExecutionException("Parameter \"crowdinServerId\" must be specified");
            }
            if (this.mavenSession == null) {
                throw new MojoExecutionException("Parameter \"mavenSession\" is null");
            }
            Settings settings = this.mavenSession.getSettings();
            if (settings != null) {
                this.server = settings.getServer(this.crowdinServerId);
            }
        }
        if (this.server == null) {
            throw new MojoExecutionException("Failed to find server setting with ID " + this.crowdinServerId + " in the Maven settings (~/.m2/settings.xml)");
        }
        if (StringUtil.isBlank(this.server.getPassword())) {
            throw new MojoExecutionException("No password/token is configured for the server setting with ID " + this.crowdinServerId);
        }
    }

    protected void createClient() throws MojoExecutionException {
        if (this.client != null) {
            return;
        }
        try {
            this.client = CrowdinAPI.createHTTPClient(this.getPluginVersion(), this.httpTimeout);
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while creating the HTTP client: " + e.getMessage(), (Exception)e);
        }
    }

    protected String getPluginVersion() {
        PluginDescriptor descriptor;
        String result;
        Map context = this.getPluginContext();
        Object o = context.get("pluginDescriptor");
        if (o instanceof PluginDescriptor && StringUtil.isNotBlank(result = (descriptor = (PluginDescriptor)o).getVersion())) {
            return result;
        }
        return "unknown";
    }

    protected void initializeParameters() throws MojoExecutionException {
        this.downloadFolderPath = this.downloadFolder != null ? this.downloadFolder.toPath() : null;
    }

    @Nullable
    protected BranchInfo getBranch() throws MojoExecutionException {
        return this.getBranch(false, null);
    }

    @Nullable
    protected BranchInfo getBranch(boolean create, @Nullable List<BranchInfo> branches) throws MojoExecutionException {
        Path gitFolder;
        if (Boolean.TRUE.equals(this.disableBranches)) {
            this.getLog().info((CharSequence)"Branches are disabled, working only with Crowdin \"root branch\"");
            return null;
        }
        if (StringUtil.isBlank(this.gitBaseFolder)) {
            gitFolder = this.project.getBasedir().toPath();
        } else {
            try {
                gitFolder = Paths.get(this.gitBaseFolder, new String[0]);
            }
            catch (InvalidPathException e) {
                throw new MojoExecutionException("Unable to resolve \"" + this.gitBaseFolder + "\": " + e.getMessage(), (Exception)e);
            }
            if (!gitFolder.isAbsolute()) {
                gitFolder = this.project.getBasedir().toPath().resolve(gitFolder).normalize();
            }
        }
        this.getLog().info((CharSequence)("Determining git branch in repository \"" + gitFolder.toString() + '\"'));
        String branch = GitUtil.getBranch(gitFolder, this.getLog());
        if (StringUtil.isBlank(branch)) {
            throw new MojoExecutionException("Could not determine current git branch");
        }
        if (branch.equals(this.rootBranch)) {
            this.getLog().info((CharSequence)("Git branch is root branch \"" + branch + "\""));
            return null;
        }
        this.getLog().info((CharSequence)("Git branch is \"" + branch + "\""));
        String token = this.server.getPassword();
        if (branches == null) {
            branches = CrowdinAPI.listBranches(this.client, this.projectId, token, branch, this.getLog());
        }
        for (BranchInfo branchInfo : branches) {
            if (!branch.equals(branchInfo.getName())) continue;
            this.getLog().info((CharSequence)("Found branch \"" + branch + "\" on Crowdin"));
            return branchInfo;
        }
        if (!create) {
            throw new MojoExecutionException("Crowdin project doesn't contain branch \"" + branch + "\". Please push this branch first.");
        }
        this.getLog().info((CharSequence)("Creating branch \"" + branch + "\" on Crowdin"));
        BranchInfo result = CrowdinAPI.createBranch(this.client, this.projectId, token, branch, this.getLog());
        return result;
    }

    protected void cleanDownloadFolder() throws MojoExecutionException {
        if (this.downloadFolderPath != null && Files.exists(this.downloadFolderPath, new LinkOption[0])) {
            this.getLog().info((CharSequence)("Deleting the content of \"" + this.downloadFolderPath.toAbsolutePath() + "\""));
            try {
                Files.walkFileTree(this.downloadFolderPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        throw exc;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (!AbstractCrowdinMojo.this.downloadFolderPath.equals(dir)) {
                            Files.delete(dir);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not clean \"" + this.downloadFolderPath.toAbsolutePath() + "\": " + e.getMessage(), (Exception)e);
            }
        }
        this.getLog().info((CharSequence)("Creating download folder \"" + this.downloadFolderPath.toAbsolutePath() + "\""));
        try {
            Files.createDirectories(this.downloadFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn't create folder \"" + this.downloadFolderPath.toAbsolutePath() + "\": " + e.getMessage(), (Exception)e);
        }
    }
}

