/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import org.digitalmediaserver.crowdin.api.CrowdinAPI;
import org.digitalmediaserver.crowdin.api.FileType;
import org.digitalmediaserver.crowdin.configuration.Conversion;
import org.digitalmediaserver.crowdin.configuration.PathPlaceholder;
import org.digitalmediaserver.crowdin.configuration.StatusFile;
import org.digitalmediaserver.crowdin.configuration.TranslationFileSet;
import org.digitalmediaserver.crowdin.tool.Constants;
import org.digitalmediaserver.crowdin.tool.FIFOProperties;
import org.digitalmediaserver.crowdin.tool.FileUtil;
import org.digitalmediaserver.crowdin.tool.GroupSortedProperties;
import org.digitalmediaserver.crowdin.tool.ISO639;
import org.digitalmediaserver.crowdin.tool.NSISUtil;
import org.digitalmediaserver.crowdin.tool.OrderedProperties;
import org.digitalmediaserver.crowdin.tool.StringUtil;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.NONE)
@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
public class DeployCrowdinMojo
extends AbstractCrowdinMojo {
    public void execute() throws MojoExecutionException {
        this.initializeParameters();
        TranslationFileSet.initialize(this.translationFileSets);
        StatusFile.initialize(this.statusFiles);
        this.doExecute();
    }

    public void doExecute() throws MojoExecutionException {
        if (this.translationFileSets == null || this.translationFileSets.isEmpty()) {
            throw new MojoExecutionException("No filesets are defined");
        }
        if (Files.isDirectory(this.downloadFolderPath, new LinkOption[0])) {
            final Set<MatchInfo> fileSetMatches = this.buildFileSetMatches();
            final Path statusFile = this.downloadFolderPath.resolve("crowdin_status.json");
            try {
                Files.walkFileTree(this.downloadFolderPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        String folderNameStr;
                        Path folderName = dir.getFileName();
                        String string = folderNameStr = folderName == null ? null : folderName.toString();
                        if (folderNameStr != null && folderNameStr.startsWith(".")) {
                            DeployCrowdinMojo.this.getLog().debug((CharSequence)("Skipping folder \"" + dir + "\""));
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        DeployCrowdinMojo.this.getLog().debug((CharSequence)("Checking folder \"" + dir + "\""));
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        block75: {
                            String currentLineSeparator;
                            Path targetFile;
                            Path targetFolder;
                            Serializable pattern;
                            List<String> excludes;
                            ParseResult parseResult;
                            if (statusFile != null && statusFile.equals(file)) {
                                DeployCrowdinMojo.this.deployStatusFiles(file);
                                return FileVisitResult.CONTINUE;
                            }
                            try {
                                parseResult = DeployCrowdinMojo.this.parseFileName(file, fileSetMatches);
                            }
                            catch (IOException e) {
                                DeployCrowdinMojo.this.getLog().error((CharSequence)("Unable to process file \"" + file.toAbsolutePath() + "\": " + e.getMessage()));
                                return FileVisitResult.CONTINUE;
                            }
                            catch (MojoExecutionException e) {
                                throw new IOException("An error occurred while processing file \"" + file.toAbsolutePath() + "\"", e);
                            }
                            if (parseResult == null) {
                                DeployCrowdinMojo.this.getLog().warn((CharSequence)("Couldn't parse \"" + file + "\" - skipping file"));
                                return FileVisitResult.CONTINUE;
                            }
                            TranslationFileSet fileSet = parseResult.getMatchInfo().getFileSet();
                            List<String> includes = fileSet.getIncludes();
                            if (includes != null && includes.isEmpty()) {
                                includes = null;
                            }
                            if ((excludes = fileSet.getExcludes()) != null && excludes.isEmpty()) {
                                excludes = null;
                            }
                            if (includes != null || excludes != null) {
                                String fileName;
                                int downloadFolderLength = DeployCrowdinMojo.this.downloadFolderPath.getNameCount();
                                if (file.getNameCount() - downloadFolderLength < 1) {
                                    throw new AssertionError((Object)("Internal error in DeployCrowdinMojo.doExecute(), nameCount=" + file.getNameCount() + ", downloadFolderLength=" + downloadFolderLength));
                                }
                                String relativeFile = FileUtil.formatPath(file.subpath(downloadFolderLength, file.getNameCount()), false);
                                Path fileNamePath = file.getFileName();
                                String string = fileName = fileNamePath == null ? null : fileNamePath.toString();
                                if (includes != null) {
                                    boolean found = false;
                                    for (String include : includes) {
                                        Pattern pattern2 = DeployCrowdinMojo.createFilterPattern(include);
                                        if (pattern2 == null || !pattern2.matcher(relativeFile.toString()).matches() && !pattern2.matcher(fileName).matches()) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        DeployCrowdinMojo.this.getLog().debug((CharSequence)("Skipping file \"" + file + "\"because it's not included in fileset \"" + fileSet + "\""));
                                        return FileVisitResult.CONTINUE;
                                    }
                                }
                                if (excludes != null && !excludes.isEmpty()) {
                                    for (String exclude : excludes) {
                                        pattern = DeployCrowdinMojo.createFilterPattern(exclude);
                                        if (pattern == null || !((Pattern)pattern).matcher(relativeFile.toString()).matches() && !((Pattern)pattern).matcher(fileName).matches()) continue;
                                        DeployCrowdinMojo.this.getLog().debug((CharSequence)("Skipping file \"" + file + "\"because it is excluded in fileset \"" + fileSet + "\""));
                                        return FileVisitResult.CONTINUE;
                                    }
                                }
                            }
                            if ((targetFolder = (targetFile = fileSet.getLanguageFilesFolder().toPath().resolve(parseResult.getTargetFile())).getParent()) != null && !Files.exists(targetFolder, new LinkOption[0])) {
                                DeployCrowdinMojo.this.getLog().info((CharSequence)("Creating folder \"" + targetFolder + "\""));
                                Files.createDirectories(targetFolder, new FileAttribute[0]);
                            }
                            DeployCrowdinMojo.this.getLog().info((CharSequence)("Deploying file \"" + targetFile.toAbsolutePath() + "\" from \"" + file + "\""));
                            String commentHeader = Boolean.TRUE.equals(fileSet.getAddComment()) ? (StringUtil.isBlank(fileSet.getComment()) ? (StringUtil.isBlank(DeployCrowdinMojo.this.comment) ? "This file has been generated automatically, modifications will be overwritten. If you'd like to change the content, please do so at Crowdin." : DeployCrowdinMojo.this.comment) : fileSet.getComment()) : null;
                            String string = currentLineSeparator = fileSet.getLineSeparator() != null ? fileSet.getLineSeparator() : DeployCrowdinMojo.this.lineSeparator;
                            if (currentLineSeparator != null) {
                                currentLineSeparator = currentLineSeparator.replace("\\r", "\r").replace("\\n", "\n");
                            }
                            if (fileSet.getType() == FileType.properties) {
                                OrderedProperties orderedProperties = Boolean.TRUE.equals(fileSet.getSortLines()) ? new GroupSortedProperties() : new FIFOProperties();
                                BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);
                                pattern = null;
                                try {
                                    orderedProperties.load(reader);
                                }
                                catch (Throwable x2) {
                                    pattern = x2;
                                    throw x2;
                                }
                                finally {
                                    if (reader != null) {
                                        if (pattern != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (Throwable x2) {
                                                ((Throwable)pattern).addSuppressed(x2);
                                            }
                                        } else {
                                            reader.close();
                                        }
                                    }
                                }
                                BufferedWriter writer = Files.newBufferedWriter(targetFile, fileSet.getCharset(), new OpenOption[0]);
                                pattern = null;
                                try {
                                    orderedProperties.store(writer, commentHeader, currentLineSeparator, !Boolean.FALSE.equals(fileSet.getEscapeUnicode()));
                                }
                                catch (Throwable throwable) {
                                    pattern = throwable;
                                    throw throwable;
                                }
                                finally {
                                    if (writer != null) {
                                        if (pattern != null) {
                                            try {
                                                writer.close();
                                            }
                                            catch (Throwable x2) {
                                                ((Throwable)pattern).addSuppressed(x2);
                                            }
                                        } else {
                                            writer.close();
                                        }
                                    }
                                }
                            }
                            if (Boolean.TRUE.equals(fileSet.getSortLines())) {
                                throw new IOException("Invalid option", new MojoExecutionException("Option \"sortLines\" isn't supported for " + (Object)((Object)fileSet.getType()) + " files"));
                            }
                            if (Boolean.TRUE.equals(fileSet.getEscapeUnicode())) {
                                throw new IOException("Invalid option", new MojoExecutionException("Option \"escapeUnicode\" isn't supported for " + (Object)((Object)fileSet.getType()) + " files"));
                            }
                            if (!fileSet.getCharset().equals(StandardCharsets.UTF_8) || Boolean.TRUE.equals(fileSet.getAddComment()) || currentLineSeparator != null || fileSet.getType() == FileType.nsh || Boolean.TRUE.equals(fileSet.getWriteBOM())) {
                                try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);
                                     BufferedWriter writer = Files.newBufferedWriter(targetFile, fileSet.getCharset(), new OpenOption[0]);){
                                    if (Boolean.TRUE.equals(fileSet.getWriteBOM())) {
                                        writer.write("\ufeff");
                                    }
                                    if (Boolean.TRUE.equals(fileSet.getAddComment())) {
                                        if (fileSet.getType() == FileType.html || fileSet.getType() == FileType.xml) {
                                            writer.write("<!-- ");
                                            writer.write(commentHeader);
                                            writer.write(" -->");
                                        } else {
                                            writer.write(fileSet.getCommentTag());
                                            writer.write(32);
                                            writer.write(commentHeader);
                                        }
                                        OrderedProperties.writeNewLine(writer, currentLineSeparator);
                                        OrderedProperties.writeNewLine(writer, currentLineSeparator);
                                    }
                                    String line = reader.readLine();
                                    while (line != null) {
                                        if (fileSet.getType() == FileType.nsh) {
                                            line = NSISUtil.convertLineToNSIS(line);
                                        }
                                        writer.write(line);
                                        OrderedProperties.writeNewLine(writer, currentLineSeparator);
                                        line = reader.readLine();
                                    }
                                    writer.flush();
                                    break block75;
                                }
                            }
                            DeployCrowdinMojo.copyFile(file, targetFile, true);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        DeployCrowdinMojo.this.getLog().error((CharSequence)("Could not process file \"" + file.toAbsolutePath() + "\": " + exc.getMessage()));
                        throw exc;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        DeployCrowdinMojo.this.getLog().debug((CharSequence)("Finished checking folder " + dir.toAbsolutePath()));
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                if (e.getCause() instanceof MojoExecutionException) {
                    throw (MojoExecutionException)e.getCause();
                }
                throw new MojoExecutionException("An I/O error occurred while deploying translations: " + e.getMessage(), (Exception)e);
            }
        } else {
            if (!Files.exists(this.downloadFolderPath, new LinkOption[0])) {
                throw new MojoExecutionException("Crowdin download folder (" + this.downloadFolderPath + ") doesn't exist. Call fetch first.");
            }
            throw new MojoExecutionException("Crowdin download folder (" + this.downloadFolderPath + ") isn't a folder.");
        }
    }

    @Nullable
    private ParseResult parseFileName(@Nullable Path path, Set<MatchInfo> fileSetMatchInfos) throws MojoExecutionException, IOException {
        if (path == null || !Files.isRegularFile(path, new LinkOption[0])) {
            throw new IOException(path == null ? "File path is null" : "File path isn't a regular file: \"" + path.toAbsolutePath() + "\"");
        }
        if (!path.startsWith(this.downloadFolderPath)) {
            throw new MojoExecutionException("Internal error: downloadFolderPath \"" + this.downloadFolderPath.toAbsolutePath() + "\" isn't part of the file path \"" + path.toAbsolutePath() + "\"");
        }
        int downloadFolderLength = this.downloadFolderPath.getNameCount();
        String crowdinCode = path.getName(downloadFolderLength).toString();
        if (path.getNameCount() - downloadFolderLength < 2) {
            return null;
        }
        String fileName = FileUtil.formatPath(path.subpath(downloadFolderLength + 1, path.getNameCount()), false);
        Matcher matcher = null;
        MatchInfo matchedfileSetMatchInfo = null;
        for (MatchInfo fileSetMatchInfo : fileSetMatchInfos) {
            Matcher m = fileSetMatchInfo.getPattern().matcher(fileName);
            if (!m.matches()) continue;
            matchedfileSetMatchInfo = fileSetMatchInfo;
            matcher = m;
            break;
        }
        if (matcher == null || matchedfileSetMatchInfo == null) {
            throw new IOException("Unable to match file \"" + path.toAbsolutePath() + "\" to any translation file set");
        }
        StringBuilder targetFileName = new StringBuilder();
        List<Conversion> conversions = matchedfileSetMatchInfo.getFileSet().getConversions();
        if (StringUtil.isBlank(matchedfileSetMatchInfo.getFileSet().getTargetFileName())) {
            int groupCount = matcher.groupCount();
            if (groupCount > 0) {
                for (int group = 1; group <= groupCount; ++group) {
                    int literalStart = group == 1 ? 0 : matcher.end(group - 1);
                    int literalEnd = matcher.start(group);
                    if (literalEnd - literalStart > 0) {
                        targetFileName.append(fileName.substring(literalStart, literalEnd));
                    }
                    targetFileName.append(DeployCrowdinMojo.convertPlaceholder(matcher.group(group), conversions));
                }
                targetFileName.append(fileName.substring(matcher.end(groupCount)));
            } else {
                targetFileName.append(fileName);
            }
            String crowdinPath = FileUtil.formatPath(matchedfileSetMatchInfo.getFileSet().getCrowdinPath(), true);
            if (crowdinPath != null && targetFileName.toString().startsWith(crowdinPath)) {
                targetFileName = new StringBuilder(targetFileName.substring(crowdinPath.length()));
            }
        } else {
            String remaining = matchedfileSetMatchInfo.getFileSet().getTargetFileName();
            while (remaining.length() > 0) {
                Matcher m = Constants.PLACEHOLDER_PATTERN.matcher(remaining);
                if (m.find()) {
                    if (m.start() > 0) {
                        targetFileName.append(remaining.substring(0, m.start()));
                    }
                    String replacement = null;
                    PathPlaceholder placeholder = PathPlaceholder.typeOf(m.group());
                    if (placeholder != null) {
                        for (int i = 0; i < matchedfileSetMatchInfo.getPlaceHolders().size(); ++i) {
                            if (placeholder != matchedfileSetMatchInfo.getPlaceHolders().get(i)) continue;
                            replacement = DeployCrowdinMojo.convertPlaceholder(matcher.group(i + 1), conversions);
                            break;
                        }
                    }
                    if (replacement == null) {
                        String group;
                        String string = group = placeholder == null ? m.group().toLowerCase(Locale.ROOT) : null;
                        if (placeholder == PathPlaceholder.LANGUAGE || placeholder == PathPlaceholder.TWO_LETTER || placeholder == PathPlaceholder.THREE_LETTER || "%shortest_iso639_code%".equals(group)) {
                            ISO639 language = DeployCrowdinMojo.getLanguageFromCrowdinCode(crowdinCode);
                            if (language == null) {
                                throw new IOException("Unable to resolve ISO639 instance for Crowdin code \"" + crowdinCode + "\"");
                            }
                            replacement = placeholder == PathPlaceholder.LANGUAGE ? DeployCrowdinMojo.convertPlaceholder(language.getName(), conversions) : (placeholder == PathPlaceholder.TWO_LETTER ? DeployCrowdinMojo.convertPlaceholder(language.get2LetterCode(), conversions) : (placeholder == PathPlaceholder.THREE_LETTER ? DeployCrowdinMojo.convertPlaceholder(language.getPart2T(), conversions) : DeployCrowdinMojo.convertPlaceholder(language.getShortestCode(), conversions)));
                        } else {
                            if (placeholder != null) {
                                throw new MojoExecutionException("targetFileName refers to placeholder \"" + placeholder.getIdentifier() + "\" not found in the export pattern \"" + matchedfileSetMatchInfo.getFileSet().getExportPattern() + "\"");
                            }
                            if ("%crowdin_code%".equals(group)) {
                                replacement = DeployCrowdinMojo.convertPlaceholder(crowdinCode, conversions);
                            } else if ("%crowdin_code_with_underscore%".equals(group)) {
                                replacement = DeployCrowdinMojo.convertPlaceholder(crowdinCode, conversions).replace('-', '_');
                                replacement = DeployCrowdinMojo.convertPlaceholder(replacement, conversions);
                            } else {
                                throw new MojoExecutionException("Unknown placeholder \"" + m.group() + "\"");
                            }
                        }
                    }
                    targetFileName.append(replacement);
                    remaining = remaining.substring(m.end());
                    continue;
                }
                targetFileName.append(remaining);
                remaining = "";
            }
        }
        if (StringUtil.isBlank(targetFileName)) {
            throw new IOException("Resolved target filename for file \"" + path.toAbsolutePath() + "\" is blank");
        }
        return new ParseResult(Paths.get(targetFileName.toString(), new String[0]), matchedfileSetMatchInfo);
    }

    private void deployStatusFiles(@Nonnull Path file) throws IOException {
        if (this.statusFiles != null && !this.statusFiles.isEmpty()) {
            JsonElement document;
            Gson gson = CrowdinAPI.getGsonInstance();
            try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                document = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
            }
            catch (JsonParseException e) {
                throw new IOException("Could not parse JSON file \"" + file + "\"", e);
            }
            for (StatusFile fileSet : this.statusFiles) {
                String currentLineSeparator;
                this.getLog().info((CharSequence)("Deploying status file \"" + fileSet.getTargetFile() + "\" from \"" + file + "\""));
                String commentHeader = null;
                String string = currentLineSeparator = fileSet.getLineSeparator() != null ? fileSet.getLineSeparator() : this.lineSeparator;
                if (currentLineSeparator != null) {
                    currentLineSeparator = currentLineSeparator.replace("\\r", "\r").replace("\\n", "\n");
                }
                if (fileSet.getType() == FileType.properties) {
                    Object child2;
                    if (Boolean.TRUE.equals(fileSet.getAddComment())) {
                        commentHeader = StringUtil.isBlank(fileSet.getComment()) ? (StringUtil.isBlank(this.comment) ? "This file has been generated automatically, modifications will be overwritten. If you'd like to change the content, please do so at Crowdin." : this.comment) : fileSet.getComment();
                    }
                    OrderedProperties statusProperties = Boolean.TRUE.equals(fileSet.getSortLines()) ? new GroupSortedProperties() : new FIFOProperties();
                    try {
                        for (Object child2 : document.getAsJsonArray()) {
                            JsonObject object;
                            JsonObject childObject = child2.getAsJsonObject();
                            JsonElement element = childObject.get("languageId");
                            if (element == null) continue;
                            String languageTag = DeployCrowdinMojo.convertPlaceholder(element.getAsString(), fileSet.getConversions());
                            element = childObject.get("language");
                            if (element != null) {
                                statusProperties.put(languageTag + ".name", element.getAsJsonObject().get("name").getAsString());
                            }
                            if ((element = childObject.get("phrases")) != null) {
                                object = element.getAsJsonObject();
                                statusProperties.put(languageTag + ".phrases", object.get("total").getAsString());
                                statusProperties.put(languageTag + ".phrases.translated", object.get("translated").getAsString());
                                statusProperties.put(languageTag + ".phrases.approved", object.get("approved").getAsString());
                            }
                            if ((element = childObject.get("words")) != null) {
                                object = element.getAsJsonObject();
                                statusProperties.put(languageTag + ".words", object.get("total").getAsString());
                                statusProperties.put(languageTag + ".words.translated", object.get("translated").getAsString());
                                statusProperties.put(languageTag + ".words.approved", object.get("approved").getAsString());
                            }
                            if ((element = childObject.get("translationProgress")) != null) {
                                statusProperties.put(languageTag + ".progress.translated", element.getAsString());
                            }
                            if ((element = childObject.get("approvalProgress")) == null) continue;
                            statusProperties.put(languageTag + ".progress.approved", element.getAsString());
                        }
                    }
                    catch (IllegalStateException | UnsupportedOperationException e) {
                        throw new IOException("Unable to parse status file \"" + file + "\": " + e.getMessage(), e);
                    }
                    BufferedWriter writer = Files.newBufferedWriter(Paths.get(fileSet.getTargetFile(), new String[0]), fileSet.getCharset(), new OpenOption[0]);
                    child2 = null;
                    try {
                        statusProperties.store(writer, commentHeader, currentLineSeparator, !Boolean.FALSE.equals(fileSet.getEscapeUnicode()));
                        continue;
                    }
                    catch (Throwable x2) {
                        child2 = x2;
                        throw x2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (child2 != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)child2).addSuppressed(x2);
                            }
                            continue;
                        }
                        writer.close();
                        continue;
                    }
                }
                if (fileSet.getType() == FileType.json) {
                    if (Boolean.TRUE.equals(fileSet.getSortLines())) {
                        throw new IOException("Invalid option", new MojoExecutionException("Option \"sortLines\" isn't supported for " + (Object)((Object)fileSet.getType()) + " files"));
                    }
                    if (Boolean.TRUE.equals(fileSet.getEscapeUnicode())) {
                        throw new IOException("Invalid option", new MojoExecutionException("Option \"escapeUnicode\" isn't supported for " + (Object)((Object)fileSet.getType()) + " files"));
                    }
                    if (Boolean.TRUE.equals(fileSet.getAddComment())) {
                        throw new IOException("Invalid option", new MojoExecutionException("Option \"addComment\" isn't supported for " + (Object)((Object)fileSet.getType()) + " files"));
                    }
                    Charset charset = fileSet.getCharset();
                    if (charset == null) {
                        charset = StandardCharsets.UTF_8;
                    }
                    if (!charset.toString().startsWith("UTF")) {
                        throw new IOException("Invalid charset", new MojoExecutionException("Only Unicode character sets are supported for " + (Object)((Object)fileSet.getType()) + " files"));
                    }
                    List<Conversion> conversions = fileSet.getConversions();
                    if (conversions != null && !conversions.isEmpty() && document.isJsonArray()) {
                        for (JsonElement child : document.getAsJsonArray()) {
                            String currentCode;
                            String convertedCode;
                            JsonObject childObject;
                            JsonElement element;
                            if (!child.isJsonObject() || (element = (childObject = child.getAsJsonObject()).get("languageId")) == null || !element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString() || (convertedCode = DeployCrowdinMojo.convertPlaceholder(currentCode = element.getAsJsonPrimitive().getAsString(), conversions)).equals(currentCode)) continue;
                            childObject.add("languageId", (JsonElement)new JsonPrimitive(convertedCode));
                        }
                    }
                    String formattedDocument = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(document);
                    if (currentLineSeparator == null) {
                        currentLineSeparator = System.lineSeparator();
                    }
                    if (!"\n".equals(currentLineSeparator)) {
                        formattedDocument = formattedDocument.replace("\n", currentLineSeparator);
                    }
                    BufferedWriter writer = Files.newBufferedWriter(Paths.get(fileSet.getTargetFile(), new String[0]), charset, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        writer.write(formattedDocument);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        writer.close();
                        continue;
                    }
                }
                throw new IOException("Invalid file type \"" + (Object)((Object)fileSet.getType()) + "\" for status file \"" + file + "\"");
            }
        }
    }

    @Nullable
    private static Pattern createFilterPattern(@Nullable String filter) {
        String literal;
        if (StringUtil.isBlank(filter)) {
            return null;
        }
        Matcher matcher = Constants.FILTER_DELIMITERS.matcher(filter);
        StringBuilder sb = new StringBuilder(filter.length() * 2);
        int next = 0;
        while (matcher.find()) {
            literal = filter.substring(next, matcher.start());
            if (!literal.isEmpty()) {
                sb.append(Pattern.quote(literal));
            }
            switch (matcher.group()) {
                case "?": {
                    sb.append(".");
                    break;
                }
                case "*": {
                    sb.append(".*");
                    break;
                }
                case "\\": {
                    sb.append("/");
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Broken code in createFilterPattern");
                }
            }
            next = matcher.end();
        }
        literal = filter.substring(next);
        if (!literal.isEmpty()) {
            sb.append(Pattern.quote(literal));
        }
        return Pattern.compile(sb.toString());
    }

    @Nonnull
    private Set<MatchInfo> buildFileSetMatches() throws MojoExecutionException {
        HashSet<MatchInfo> fileSetMatches = new HashSet<MatchInfo>();
        for (TranslationFileSet fileSet : this.translationFileSets) {
            if (StringUtil.isBlank(fileSet.getExportPattern())) {
                this.getLog().warn((CharSequence)("Can't deploy translation file set \"" + fileSet.getTitle() + "\" because \"exportPattern\" is missing"));
                continue;
            }
            StringBuilder sb = new StringBuilder();
            String pushFolder = FileUtil.getPushFolder(fileSet, true);
            if (StringUtil.isNotBlank(pushFolder)) {
                sb.append(Pattern.quote(pushFolder));
            }
            String remaining = fileSet.getExportPattern();
            ArrayList<PathPlaceholder> matchPlaceHolders = new ArrayList<PathPlaceholder>();
            while (remaining.length() > 0) {
                Matcher matcher = Constants.PLACEHOLDER_PATTERN.matcher(remaining);
                if (matcher.find()) {
                    PathPlaceholder placeholder;
                    if (matcher.start() > 0) {
                        sb.append(Pattern.quote(remaining.substring(0, matcher.start())));
                    }
                    if ((placeholder = PathPlaceholder.typeOf(matcher.group())) == null) {
                        throw new MojoExecutionException("Unknown placeholder \"" + matcher.group() + "\"");
                    }
                    sb.append(placeholder.getPattern());
                    matchPlaceHolders.add(placeholder);
                    remaining = remaining.substring(matcher.end());
                    continue;
                }
                sb.append(Pattern.quote(remaining));
                remaining = "";
            }
            fileSetMatches.add(new MatchInfo(fileSet, Pattern.compile(sb.toString()), matchPlaceHolders));
        }
        return fileSetMatches;
    }

    @Nullable
    private static ISO639 getLanguageFromCrowdinCode(String crowdinCode) {
        if (StringUtil.isBlank(crowdinCode)) {
            return null;
        }
        int hyphen = crowdinCode.indexOf(45);
        if (hyphen > 0) {
            crowdinCode = crowdinCode.substring(0, hyphen);
        }
        return ISO639.getCode(crowdinCode);
    }

    @Nonnull
    private static String convertPlaceholder(@Nonnull String placeholderContent, @Nullable List<Conversion> conversions) {
        if (placeholderContent == null) {
            throw new IllegalArgumentException("placeholder cannot be null");
        }
        if (conversions == null || conversions.isEmpty()) {
            return placeholderContent;
        }
        for (Conversion conversion : conversions) {
            if (!placeholderContent.equals(conversion.getFrom())) continue;
            return conversion.getTo();
        }
        return placeholderContent;
    }

    private static void copyFile(@Nonnull Path sourceFile, @Nonnull Path destinationFile, boolean overwrite) throws IOException {
        if (overwrite) {
            Files.copy(sourceFile, destinationFile, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.copy(sourceFile, destinationFile, new CopyOption[0]);
        }
    }

    @Immutable
    public static class MatchInfo {
        @Nonnull
        private final TranslationFileSet fileSet;
        @Nonnull
        private final Pattern pattern;
        @Nonnull
        private final List<PathPlaceholder> placeHolders;

        public MatchInfo(@Nonnull TranslationFileSet fileSet, @Nonnull Pattern pattern, @Nonnull List<PathPlaceholder> placeHolders) {
            this.fileSet = fileSet;
            this.pattern = pattern;
            this.placeHolders = placeHolders;
        }

        @Nonnull
        public TranslationFileSet getFileSet() {
            return this.fileSet;
        }

        @Nonnull
        public Pattern getPattern() {
            return this.pattern;
        }

        @Nonnull
        public List<PathPlaceholder> getPlaceHolders() {
            return this.placeHolders;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MatchInfo [fileSet=").append(this.fileSet).append(", pattern=\"").append(this.pattern).append("\", placeHolders=").append(this.placeHolders).append("]");
            return builder.toString();
        }
    }

    @Immutable
    public static class ParseResult {
        @Nonnull
        private final Path targetFile;
        @Nonnull
        private final MatchInfo matchInfo;

        public ParseResult(@Nonnull Path targetFile, @Nonnull MatchInfo matchInfo) {
            this.targetFile = targetFile;
            this.matchInfo = matchInfo;
        }

        @Nonnull
        public Path getTargetFile() {
            return this.targetFile;
        }

        @Nonnull
        public MatchInfo getMatchInfo() {
            return this.matchInfo;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ParseResult [targetFile=").append(this.targetFile).append(", matchInfo=").append(this.matchInfo).append("]");
            return builder.toString();
        }
    }
}

