/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import org.digitalmediaserver.crowdin.api.CrowdinAPI;
import org.digitalmediaserver.crowdin.api.response.BranchInfo;
import org.digitalmediaserver.crowdin.api.response.BuildInfo;
import org.digitalmediaserver.crowdin.api.response.DownloadLinkInfo;
import org.digitalmediaserver.crowdin.configuration.StatusFile;
import org.digitalmediaserver.crowdin.configuration.TranslationFileSet;
import org.digitalmediaserver.crowdin.tool.FileUtil;

@Mojo(name="fetch", defaultPhase=LifecyclePhase.NONE)
public class FetchCrowdinMojo
extends AbstractCrowdinMojo {
    @Parameter(property="skipUntranslatedStrings", defaultValue="true")
    protected boolean skipUntranslatedStrings;
    @Parameter(property="skipUntranslatedFiles", defaultValue="false")
    protected boolean skipUntranslatedFiles;
    @Parameter(property="exportApprovedOnly", defaultValue="false")
    protected boolean exportApprovedOnly;
    @Parameter(property="buildTimeout", defaultValue="60")
    protected Integer buildTimeout;

    protected void setSkipUntranslatedStrings(boolean value) {
        this.skipUntranslatedStrings = value;
    }

    protected void setSkipUntranslatedFiles(boolean value) {
        this.skipUntranslatedFiles = value;
    }

    protected void setExportApprovedOnly(boolean value) {
        this.exportApprovedOnly = value;
    }

    protected void setBuildTimeout(@Nonnull Integer buildTimeout) {
        this.buildTimeout = buildTimeout;
    }

    public void execute() throws MojoExecutionException {
        this.initializeParameters();
        TranslationFileSet.initialize(this.translationFileSets);
        StatusFile.initialize(this.statusFiles);
        this.createClient();
        this.initializeServer();
        this.doExecute();
    }

    public void doExecute() throws MojoExecutionException {
        if (this.translationFileSets == null || this.translationFileSets.isEmpty()) {
            throw new MojoExecutionException("No filesets are defined");
        }
        Log logger = this.getLog();
        String token = this.server.getPassword();
        List<BranchInfo> branches = CrowdinAPI.listBranches(this.client, this.projectId, token, null, logger);
        BranchInfo branch = this.getBranch(false, branches);
        BuildInfo build = this.buildTranslations(branch, token);
        this.cleanDownloadFolder();
        logger.info((CharSequence)"Downloading translations from Crowdin");
        DownloadLinkInfo downloadLinkInfo = CrowdinAPI.getDownloadLink(this.client, this.projectId, build.getId(), token, logger);
        HashSet<String> filterBranchNames = null;
        if (branch == null && !branches.isEmpty()) {
            filterBranchNames = new HashSet<String>(branches.size(), 1.0f);
            for (BranchInfo info : branches) {
                filterBranchNames.add(info.getName());
            }
        }
        int count = 0;
        byte[] buf = new byte[1024];
        try (CloseableHttpResponse response = CrowdinAPI.sendStreamRequest(this.client, CrowdinAPI.HTTPMethod.GET, downloadLinkInfo.getUrl(), null, logger);
             InputStream responseBodyAsStream = response.getEntity().getContent();
             ZipInputStream zis = new ZipInputStream(responseBodyAsStream);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (filterBranchNames != null) {
                    List<String> pathElements = FileUtil.splitPath(entry.getName(), true);
                    boolean filter = false;
                    for (int i = 1; i < pathElements.size(); ++i) {
                        if (!filterBranchNames.contains(pathElements.get(i))) continue;
                        filter = true;
                        break;
                    }
                    if (filter) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((CharSequence)("Filtering out branch element \"" + entry.getName() + "\""));
                        continue;
                    }
                }
                if (entry.isDirectory()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((CharSequence)("Creating folder \"" + entry.getName() + "\""));
                    }
                    Files.createDirectories(this.downloadFolderPath.resolve(entry.getName()), new FileAttribute[0]);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((CharSequence)("Writing \"" + entry.getName() + "\""));
                }
                Path path = this.downloadFolderPath.resolve(entry.getName());
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                    while (zis.available() > 0) {
                        int read = zis.read(buf);
                        if (read == -1) continue;
                        os.write(buf, 0, read);
                    }
                }
                ++count;
            }
        }
        catch (IOException | HttpException e) {
            throw new MojoExecutionException("Failed to download translation files: " + e.getMessage(), (Exception)e);
        }
        if (count == 0) {
            logger.info((CharSequence)"No translations are available!");
        } else {
            logger.info((CharSequence)("Successfully downloaded " + count + " files from Crowdin"));
        }
        this.downloadStatusFile();
    }

    @Nonnull
    protected BuildInfo buildTranslations(@Nullable BranchInfo branch, @Nonnull String token) throws MojoExecutionException {
        if (branch == null) {
            this.getLog().info((CharSequence)"Asking Crowdin to build translations");
        } else {
            this.getLog().info((CharSequence)("Asking Crowdin to build translations for branch \"" + branch.getName() + "\""));
        }
        BuildInfo build = CrowdinAPI.createBuild(this.client, this.projectId, token, branch == null ? null : Long.valueOf(branch.getId()), this.skipUntranslatedStrings, this.skipUntranslatedFiles, this.exportApprovedOnly, this.getLog());
        build = this.waitForBuild(build, 2000L, this.buildTimeout == null ? 60000L : this.buildTimeout.longValue() * 1000L, token, this.getLog());
        if (build.getStatus() != BuildInfo.ProjectBuildStatus.FINISHED) {
            throw new MojoExecutionException("Failed to build translations at Crowdin with status: " + (Object)((Object)build.getStatus()));
        }
        this.getLog().info((CharSequence)"Crowdin successfully built translations");
        return build;
    }

    protected void downloadStatusFile() throws MojoExecutionException {
        if (this.statusFiles == null || this.statusFiles.isEmpty()) {
            return;
        }
        String status = CrowdinAPI.getTranslationStatus(this.client, this.projectId, this.server.getPassword(), this.getLog());
        Path statusFile = this.downloadFolderPath.resolve("crowdin_status.json");
        this.getLog().info((CharSequence)("Writing translations status to \"" + statusFile + "\""));
        try (BufferedWriter writer = Files.newBufferedWriter(statusFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(status);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write file \"" + statusFile + "\": " + e.getMessage(), (Exception)e);
        }
    }

    @Nonnull
    public BuildInfo waitForBuild(@Nonnull BuildInfo build, long pollIntervalMS, long timeoutMS, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        BuildInfo.ProjectBuildStatus status;
        BuildInfo result = build;
        long now = System.currentTimeMillis();
        long expiry = now + timeoutMS;
        while (((status = result.getStatus()) == BuildInfo.ProjectBuildStatus.CREATED || status == BuildInfo.ProjectBuildStatus.IN_PROGRESS) && (now = System.currentTimeMillis()) < expiry) {
            if (logger != null) {
                if (status == BuildInfo.ProjectBuildStatus.CREATED) {
                    logger.info((CharSequence)"Build hasn't started yet");
                } else {
                    logger.info((CharSequence)("Build is " + result.getProgress() + "% completed"));
                }
            }
            try {
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug((CharSequence)("Waiting for " + pollIntervalMS + " ms"));
                }
                Thread.sleep(pollIntervalMS);
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("Interrupted while waiting for build to finish", (Exception)e);
            }
            result = CrowdinAPI.getBuildStatus(this.client, build.getProjectId(), build.getId(), token, logger);
        }
        if (now >= expiry) {
            throw new MojoExecutionException("Timed out while waiting for build to finish (timeout = " + timeoutMS + " ms)");
        }
        return result;
    }

    @Override
    protected void initializeServer() throws MojoExecutionException {
        super.initializeServer();
        if (this.skipUntranslatedFiles && this.skipUntranslatedStrings) {
            throw new MojoExecutionException("Both 'skipUntranslatedFiles' and 'skipUntranslatedStrings' cannot be 'true'");
        }
    }
}

