/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import org.digitalmediaserver.crowdin.DeployCrowdinMojo;
import org.digitalmediaserver.crowdin.FetchCrowdinMojo;
import org.digitalmediaserver.crowdin.configuration.StatusFile;
import org.digitalmediaserver.crowdin.configuration.TranslationFileSet;

@Mojo(name="pull", defaultPhase=LifecyclePhase.NONE)
public class PullCrowdinMojo
extends AbstractCrowdinMojo {
    @Parameter(property="skipUntranslatedStrings", defaultValue="true")
    protected boolean skipUntranslatedStrings;
    @Parameter(property="skipUntranslatedFiles", defaultValue="false")
    protected boolean skipUntranslatedFiles;
    @Parameter(property="exportApprovedOnly", defaultValue="false")
    protected boolean exportApprovedOnly;
    @Parameter(property="buildTimeouot", defaultValue="60")
    protected Integer buildTimeout;

    public void execute() throws MojoExecutionException {
        this.initializeParameters();
        this.createClient();
        this.initializeServer();
        TranslationFileSet.initialize(this.translationFileSets);
        StatusFile.initialize(this.statusFiles);
        this.getLog().info((CharSequence)"Executing fetch and deploy goals");
        this.getLog().debug((CharSequence)"Executing fetch");
        FetchCrowdinMojo fetch = new FetchCrowdinMojo();
        fetch.setCrowdinServerId(this.crowdinServerId);
        fetch.setDownloadFolder(this.downloadFolderPath);
        fetch.setHTTPTimeout(this.httpTimeout);
        fetch.setBuildTimeout(this.buildTimeout);
        fetch.setProject(this.project);
        fetch.setProjectId(this.projectId);
        fetch.setDisableBranches(this.disableBranches);
        fetch.setGitBaseFolder(this.gitBaseFolder);
        fetch.setRootBranch(this.rootBranch);
        fetch.setServer(this.server);
        fetch.setClient(this.client);
        fetch.setSkipUntranslatedFiles(this.skipUntranslatedFiles);
        fetch.setSkipUntranslatedStrings(this.skipUntranslatedStrings);
        fetch.setExportApprovedOnly(this.exportApprovedOnly);
        fetch.setTranslationFileSets(this.translationFileSets);
        fetch.setStatusFiles(this.statusFiles);
        fetch.setLog(this.getLog());
        fetch.doExecute();
        this.getLog().debug((CharSequence)"Executing deploy");
        DeployCrowdinMojo deploy = new DeployCrowdinMojo();
        deploy.setDownloadFolder(this.downloadFolderPath);
        deploy.setTranslationFileSets(this.translationFileSets);
        deploy.setStatusFiles(this.statusFiles);
        deploy.setLineSeparator(this.lineSeparator);
        deploy.setComment(this.comment);
        deploy.setLog(this.getLog());
        deploy.execute();
        this.getLog().info((CharSequence)"Pull sequence completed");
    }

    @Override
    protected void initializeServer() throws MojoExecutionException {
        super.initializeServer();
        if (this.skipUntranslatedFiles && this.skipUntranslatedStrings) {
            throw new MojoExecutionException("Both 'skipUntranslatedFiles' and 'skipUntranslatedStrings' cannot be 'true'");
        }
    }
}

