/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import org.digitalmediaserver.crowdin.api.CrowdinAPI;
import org.digitalmediaserver.crowdin.api.FileExportOptions;
import org.digitalmediaserver.crowdin.api.FileType;
import org.digitalmediaserver.crowdin.api.response.BranchInfo;
import org.digitalmediaserver.crowdin.api.response.FileInfo;
import org.digitalmediaserver.crowdin.api.response.FolderInfo;
import org.digitalmediaserver.crowdin.api.response.ProjectInfo;
import org.digitalmediaserver.crowdin.api.response.StorageInfo;
import org.digitalmediaserver.crowdin.configuration.TranslationFileSet;
import org.digitalmediaserver.crowdin.configuration.UpdateOption;
import org.digitalmediaserver.crowdin.tool.FileUtil;
import org.digitalmediaserver.crowdin.tool.NSISUtil;
import org.digitalmediaserver.crowdin.tool.StringUtil;

@Mojo(name="push", defaultPhase=LifecyclePhase.NONE)
public class PushCrowdinMojo
extends AbstractCrowdinMojo {
    @Parameter(property="projectName", required=true)
    protected String projectName;
    @Parameter(property="confirm", defaultValue="false")
    protected String confirm;
    @Parameter(property="updateOption", defaultValue="clear_translations_and_approvals")
    protected UpdateOption updateOption;
    @Parameter(property="replaceModifiedContext", defaultValue="false")
    protected Boolean replaceModifiedContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    public void execute() throws MojoExecutionException {
        if (!(this.confirm.equalsIgnoreCase("confirm") || this.confirm.equalsIgnoreCase("yes") || this.confirm.equalsIgnoreCase("true"))) {
            throw new MojoExecutionException("Push is not confirmed - aborting!");
        }
        if (!this.project.getName().equals(this.projectName)) {
            throw new MojoExecutionException("POM name (" + this.project.getName() + ") differs from \"projectName\" parameter (" + this.projectName + ") - push aborted!");
        }
        this.initializeParameters();
        this.initializeServer();
        this.createClient();
        TranslationFileSet.initialize(this.translationFileSets);
        this.getLog().info((CharSequence)"Retrieving Crowdin project information");
        String token = this.server.getPassword();
        ProjectInfo projectInfo = CrowdinAPI.getProjectInfo(this.client, this.projectId, token, this.getLog());
        if (projectInfo.getName() == null || !projectInfo.getName().equals(this.projectName)) {
            throw new MojoExecutionException("Crowdin project name (" + projectInfo.getName() + ") differs from the \"projectName\" parameter (" + this.projectName + ") - push aborted!");
        }
        BranchInfo branch = this.getBranch(true, null);
        for (TranslationFileSet fileSet : this.translationFileSets) {
            Path pushFile = fileSet.getLanguageFilesFolder().toPath().resolve(fileSet.getBaseFileName());
            String loggingTitle = fileSet.getTitle();
            String string = loggingTitle = StringUtil.isBlank(loggingTitle) || loggingTitle.equals(fileSet.getBaseFileName()) ? null : loggingTitle;
            if (Files.exists(pushFile, new LinkOption[0])) {
                StorageInfo storage;
                FileInfo file;
                FolderInfo folder = null;
                FileInfo templateFile = null;
                Path tmpPath = pushFile.getFileName();
                String pushFileName = tmpPath == null ? "" : tmpPath.toString();
                String pushFolder = FileUtil.getPushFolder(fileSet, true);
                if (StringUtil.isNotBlank(pushFolder)) {
                    folder = CrowdinAPI.getFolder(this.client, this.projectId, branch, pushFolder, true, token, this.getLog());
                }
                if ((file = CrowdinAPI.getFileIfExists(this.client, this.projectId, branch, folder, fileSet.getBaseFileName(), token, this.getLog())) == null && branch != null) {
                    FolderInfo templateFolder;
                    FolderInfo folderInfo = templateFolder = folder == null ? null : CrowdinAPI.getFolder(this.client, this.projectId, null, pushFolder, false, token, this.getLog());
                    if (folder == null || templateFolder != null) {
                        templateFile = CrowdinAPI.getFileIfExists(this.client, this.projectId, null, templateFolder, fileSet.getBaseFileName(), token, this.getLog());
                    }
                }
                if (loggingTitle != null) {
                    this.getLog().info((CharSequence)("Uploading \"" + fileSet.getBaseFileName() + "\" for fileset \"" + loggingTitle + "\" to Crowdin"));
                } else {
                    this.getLog().info((CharSequence)("Uploading \"" + fileSet.getBaseFileName() + "\" to Crowdin"));
                }
                InputStream is = null;
                try {
                    FileEntity entity;
                    FileType fileType = fileSet.getType();
                    ContentType contentType = fileType == null || fileType == FileType.auto || StringUtil.isBlank(fileType.getContentType()) ? ContentType.APPLICATION_OCTET_STREAM : ContentType.create((String)fileType.getContentType(), (Charset)fileSet.getCharset());
                    if (fileSet.getType() == FileType.nsh) {
                        is = new NSISUtil.NSISInputStream(pushFile);
                        entity = new InputStreamEntity(is, contentType);
                    } else {
                        entity = new FileEntity(pushFile.toFile(), contentType);
                    }
                    storage = CrowdinAPI.createStorage(this.client, pushFileName, (HttpEntity)entity, token, this.getLog());
                }
                catch (FileNotFoundException e) {
                    if (loggingTitle != null) {
                        this.getLog().warn((CharSequence)("\"" + pushFile.toAbsolutePath() + "\" not found - upload skipped for fileset \"" + loggingTitle + "\": " + e.getMessage()));
                        continue;
                    }
                    this.getLog().warn((CharSequence)("\"" + pushFile.toAbsolutePath() + "\" not found - upload skipped: " + e.getMessage()));
                    continue;
                }
                catch (IOException e) {
                    if (loggingTitle != null) {
                        this.getLog().error((CharSequence)("An error occurred while reading \"" + pushFile.toAbsolutePath() + "\" - upload skipped for fileset \"" + loggingTitle + "\": " + e.getMessage()));
                        continue;
                    }
                    this.getLog().error((CharSequence)("An error occurred while reading \"" + pushFile.toAbsolutePath() + "\" - upload skipped: " + e.getMessage()));
                    continue;
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        this.getLog().warn((CharSequence)("Couldn't close \"" + pushFile.toAbsolutePath() + "\" after reading"));
                    }
                    continue;
                }
                try {
                    if (loggingTitle != null) {
                        this.getLog().info((CharSequence)((file != null ? "Updating" : "Adding") + " file \"" + fileSet.getBaseFileName() + "\" for fileset \"" + loggingTitle + "\" at Crowdin"));
                    } else {
                        this.getLog().info((CharSequence)((file != null ? "Updating" : "Adding") + " file \"" + fileSet.getBaseFileName() + "\" at Crowdin"));
                    }
                    if (file != null) {
                        if (CrowdinAPI.updateFile(this.client, this.projectId, file.getId(), storage, this.getUpdateOption(fileSet), file.getImportOptions(), file.getExportOptions(), this.getReplaceModifiedContext(fileSet), token, this.getLog()) != null) {
                            if (loggingTitle != null) {
                                this.getLog().info((CharSequence)("Successfully updated file \"" + fileSet.getBaseFileName() + "\" for fileset \"" + loggingTitle + "\" at Crowdin"));
                                continue;
                            }
                            this.getLog().info((CharSequence)("Successfully updated file \"" + fileSet.getBaseFileName() + "\" at Crowdin"));
                            continue;
                        }
                        if (loggingTitle != null) {
                            this.getLog().info((CharSequence)("No updates were needed for file \"" + fileSet.getBaseFileName() + "\" for fileset \"" + loggingTitle + "\" at Crowdin"));
                            continue;
                        }
                        this.getLog().info((CharSequence)("No updates were needed for file \"" + fileSet.getBaseFileName() + "\" at Crowdin"));
                        continue;
                    }
                    CrowdinAPI.createFile(this.client, this.projectId, storage, pushFileName, templateFile != null && (fileSet.getType() == null || fileSet.getType() == FileType.auto) ? templateFile.getType() : fileSet.getType(), folder == null && branch != null ? Long.valueOf(branch.getId()) : null, folder == null ? null : Long.valueOf(folder.getId()), fileSet.getTitle(), templateFile == null ? null : templateFile.getContext(), templateFile == null ? null : templateFile.getExcludedTargetLanguages(), this.generateExportOptions(fileSet, templateFile), templateFile == null ? null : templateFile.getImportOptions(), templateFile == null ? null : templateFile.getParserVersion(), token, this.getLog());
                    if (loggingTitle != null) {
                        this.getLog().info((CharSequence)("Successfully added file \"" + fileSet.getBaseFileName() + "\" for fileset \"" + loggingTitle + "\" at Crowdin"));
                        continue;
                    }
                    this.getLog().info((CharSequence)("Successfully added file \"" + fileSet.getBaseFileName() + "\" at Crowdin"));
                    continue;
                }
                finally {
                    CrowdinAPI.deleteStorage(this.client, storage, token, this.getLog());
                    continue;
                }
            }
            if (!fileSet.getBaseFileName().equals(fileSet.getTitle())) {
                this.getLog().warn((CharSequence)("\"" + pushFile.toAbsolutePath() + "\" not found - upload skipped for fileset \"" + fileSet.getTitle() + "\""));
                continue;
            }
            this.getLog().warn((CharSequence)("\"" + pushFile.toAbsolutePath() + "\" not found - upload skipped"));
        }
    }

    protected UpdateOption getUpdateOption(TranslationFileSet fileSet) {
        return fileSet != null && fileSet.getUpdateOption() != null ? fileSet.getUpdateOption() : this.updateOption;
    }

    protected Boolean getReplaceModifiedContext(TranslationFileSet fileSet) {
        return fileSet != null && fileSet.getReplaceModifiedContext() != null ? fileSet.getReplaceModifiedContext() : this.replaceModifiedContext;
    }

    protected FileExportOptions generateExportOptions(@Nonnull TranslationFileSet fileSet, @Nullable FileInfo templateFile) throws MojoExecutionException {
        FileExportOptions result;
        FileExportOptions fileExportOptions = result = templateFile == null ? null : templateFile.getExportOptions();
        if (result == null) {
            result = new FileExportOptions();
        }
        result.setExportPattern(fileSet.getExportPattern());
        if (fileSet.getType() == FileType.properties || fileSet.getType() == FileType.properties_play) {
            if (fileSet.getEscapeQuotes() != null) {
                result.setEscapeQuotes(fileSet.getEscapeQuotes());
            }
            if (fileSet.getEscapeSpecialCharacters() != null) {
                result.setEscapeSpecialCharacters(fileSet.getEscapeSpecialCharacters());
            }
        }
        if (fileSet.getType() == FileType.js && fileSet.getExportQuotes() != null) {
            result.setExportQuotes(fileSet.getExportQuotes());
        }
        result.validate(fileSet.getType());
        return result;
    }

    @Override
    protected void initializeParameters() throws MojoExecutionException {
        super.initializeParameters();
        if (this.updateOption == null) {
            this.updateOption = UpdateOption.clear_translations_and_approvals;
        }
    }
}

