/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.digitalmediaserver.crowdin.api.FileExportOptions;
import org.digitalmediaserver.crowdin.api.FileImportOptions;
import org.digitalmediaserver.crowdin.api.FileType;
import org.digitalmediaserver.crowdin.api.request.CreateBranchRequest;
import org.digitalmediaserver.crowdin.api.request.CreateBuildRequest;
import org.digitalmediaserver.crowdin.api.request.CreateFileRequest;
import org.digitalmediaserver.crowdin.api.request.CreateFolderRequest;
import org.digitalmediaserver.crowdin.api.request.UpdateFileRequest;
import org.digitalmediaserver.crowdin.api.response.BranchInfo;
import org.digitalmediaserver.crowdin.api.response.BuildInfo;
import org.digitalmediaserver.crowdin.api.response.DownloadLinkInfo;
import org.digitalmediaserver.crowdin.api.response.FileInfo;
import org.digitalmediaserver.crowdin.api.response.FolderInfo;
import org.digitalmediaserver.crowdin.api.response.ProjectInfo;
import org.digitalmediaserver.crowdin.api.response.StorageInfo;
import org.digitalmediaserver.crowdin.configuration.UpdateOption;
import org.digitalmediaserver.crowdin.tool.FileUtil;
import org.digitalmediaserver.crowdin.tool.StringUtil;

public class CrowdinAPI {
    protected static final Gson GSON = new Gson();

    private CrowdinAPI() {
    }

    public static Gson getGsonInstance() {
        return GSON;
    }

    public static CloseableHttpClient createHTTPClient(String projectVersion, @Nullable Integer timeout) throws IOException {
        int timeoutMS;
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.setUserAgent("crowdin-maven-plugin/" + projectVersion);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (timeout != null && (timeoutMS = timeout * 1000) > 0) {
            requestConfigBuilder.setConnectionRequestTimeout(timeoutMS);
            requestConfigBuilder.setConnectTimeout(timeoutMS);
            requestConfigBuilder.setSocketTimeout(timeoutMS);
        }
        if (System.getProperty("http.proxyHost") != null) {
            String host = System.getProperty("http.proxyHost");
            String port = System.getProperty("http.proxyPort");
            if (port == null) {
                throw new IOException("http.proxyHost without http.proxyPort");
            }
            HttpHost proxy = new HttpHost(host, Integer.parseInt(port));
            requestConfigBuilder.setProxy(proxy);
            UsernamePasswordCredentials credentials = null;
            String user = System.getProperty("http.proxyUser");
            String password = System.getProperty("http.proxyPassword");
            if (System.getProperty("http.auth.ntlm.domain") != null) {
                String domain = System.getProperty("http.auth.ntlm.domain");
                if (user == null || password == null) {
                    throw new IOException("http.auth.ntlm.domain without http.proxyUser and http.proxyPassword");
                }
                credentials = new NTCredentials(user, password, host, domain);
            } else if (user != null || password != null) {
                if (user == null || password == null) {
                    throw new IOException("http.proxyUser and http.proxyPassword go together");
                }
                credentials = new UsernamePasswordCredentials(user, password);
            }
            if (credentials != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, Integer.parseInt(port)), (Credentials)credentials);
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        return clientBuilder.build();
    }

    @Nullable
    public static FolderInfo getFolder(@Nonnull CloseableHttpClient httpClient, long projectId, @Nullable BranchInfo branch, @Nonnull String folderPath, boolean create, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        if (StringUtil.isBlank(folderPath)) {
            return null;
        }
        FolderInfo result = null;
        Long parentFolderId = null;
        List<String> elements = FileUtil.splitPath(folderPath, false);
        for (String element : elements) {
            FolderInfo folder;
            boolean found = false;
            List<FolderInfo> folders = CrowdinAPI.listFolders(httpClient, projectId, branch == null || parentFolderId != null ? null : Long.valueOf(branch.getId()), parentFolderId, element, false, token, logger);
            for (FolderInfo folder2 : folders) {
                if (!element.equals(folder2.getName()) || (branch != null || folder2.getBranchId() != null) && (branch == null || folder2.getBranchId().longValue() != branch.getId()) || (parentFolderId != null || folder2.getDirectoryId() != null) && (parentFolderId == null || !parentFolderId.equals(folder2.getDirectoryId()))) continue;
                found = true;
                result = folder2;
                parentFolderId = folder2.getId();
                break;
            }
            if (found) continue;
            if (!create) {
                return null;
            }
            result = folder = CrowdinAPI.createFolder(httpClient, projectId, element, branch == null || parentFolderId != null ? null : Long.valueOf(branch.getId()), parentFolderId, token, logger);
            parentFolderId = folder.getId();
        }
        return result;
    }

    @Nonnull
    public static BranchInfo createBranch(@Nonnull CloseableHttpClient httpClient, long projectId, @Nonnull String token, @Nonnull String branchName, @Nullable Log logger) throws MojoExecutionException {
        BranchInfo branch;
        String response;
        if (StringUtil.isBlank(branchName)) {
            throw new MojoExecutionException("Cannot create a branch with a blank name");
        }
        CreateBranchRequest payload = new CreateBranchRequest(branchName);
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Requesting to create branch with> " + payload));
        }
        try {
            response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.POST, "projects/" + projectId + "/branches", null, null, token, payload, ContentType.APPLICATION_JSON, String.class, logger);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while creating branch: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
            branch = (BranchInfo)GSON.fromJson(jsonObject.get("data"), BranchInfo.class);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new MojoExecutionException("Error while parsing branch creation response: " + e.getMessage(), (Exception)e);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with new branch: " + branch));
        }
        return branch;
    }

    @Nonnull
    public static List<BranchInfo> listBranches(@Nonnull CloseableHttpClient httpClient, long projectId, @Nonnull String token, @Nullable String branchName, @Nullable Log logger) throws MojoExecutionException {
        int chunkSize = 500;
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("limit", Integer.toString(chunkSize));
        if (StringUtil.isNotBlank(branchName)) {
            parameters.put("name", branchName);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)"Requesting a list of branches");
        }
        ArrayList<BranchInfo> result = new ArrayList<BranchInfo>();
        int i = 0;
        int prevCount = 0;
        while (true) {
            String response;
            parameters.put("offset", Integer.toString(i * chunkSize));
            try {
                response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.GET, "projects/" + projectId + "/branches", parameters, null, token, null, null, String.class, logger);
            }
            catch (HttpException e) {
                throw new MojoExecutionException("Error while requesting list of branches: " + e.getMessage(), (Exception)((Object)e));
            }
            try {
                JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
                JsonArray jsonArray = jsonObject.get("data").getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    result.add((BranchInfo)GSON.fromJson(element.getAsJsonObject().get("data"), BranchInfo.class));
                }
            }
            catch (JsonParseException | IllegalStateException e) {
                throw new MojoExecutionException("Error while parsing list of branches response: " + e.getMessage(), (Exception)e);
            }
            int count = result.size() - prevCount;
            if (count < chunkSize) break;
            prevCount += count;
            ++i;
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with branches: " + result));
        }
        return result;
    }

    @Nonnull
    public static BuildInfo createBuild(@Nonnull CloseableHttpClient httpClient, long projectId, @Nonnull String token, @Nullable Long branchId, boolean skipUntranslatedStrings, boolean skipUntranslatedFiles, boolean exportApprovedOnly, @Nullable Log logger) throws MojoExecutionException {
        BuildInfo build;
        String response;
        CreateBuildRequest payload = new CreateBuildRequest();
        payload.setSkipUntranslatedStrings(skipUntranslatedStrings);
        payload.setSkipUntranslatedFiles(skipUntranslatedFiles);
        payload.setExportApprovedOnly(exportApprovedOnly);
        if (branchId != null) {
            payload.setBranchId(branchId);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Requesting a new build with: " + payload));
        }
        try {
            response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.POST, "projects/" + projectId + "/translations/builds", null, null, token, payload, ContentType.APPLICATION_JSON, String.class, logger);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while triggering build: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
            build = (BuildInfo)GSON.fromJson(jsonObject.get("data"), BuildInfo.class);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new MojoExecutionException("Error while parsing build creation response: " + e.getMessage(), (Exception)e);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with build: " + build));
        }
        return build;
    }

    @Nonnull
    public static BuildInfo getBuildStatus(@Nonnull CloseableHttpClient httpClient, long projectId, long buildId, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        BuildInfo result;
        String response;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Requesting build status for buildId " + buildId));
        }
        try {
            response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.GET, "projects/" + projectId + "/translations/builds/" + buildId, null, null, token, null, null, String.class, logger);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while requesting builds status: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
            result = (BuildInfo)GSON.fromJson((JsonElement)jsonObject.get("data").getAsJsonObject(), BuildInfo.class);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new MojoExecutionException("Error while parsing build status response: " + e.getMessage(), (Exception)e);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with build: " + result));
        }
        return result;
    }

    @Nonnull
    public static List<BuildInfo> listProjectBuilds(@Nonnull CloseableHttpClient httpClient, long projectId, @Nullable Long branchId, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        int chunkSize = 500;
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("limit", Integer.toString(chunkSize));
        if (branchId != null) {
            parameters.put("branchId", branchId.toString());
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)"Requesting a list of builds");
        }
        ArrayList<BuildInfo> result = new ArrayList<BuildInfo>();
        int i = 0;
        int prevCount = 0;
        while (true) {
            String response;
            parameters.put("offset", Integer.toString(i * chunkSize));
            try {
                response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.GET, "projects/" + projectId + "/translations/builds", parameters, null, token, null, null, String.class, logger);
            }
            catch (HttpException e) {
                throw new MojoExecutionException("Error while requesting list of project builds: " + e.getMessage(), (Exception)((Object)e));
            }
            try {
                JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
                JsonArray jsonArray = jsonObject.get("data").getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    result.add((BuildInfo)GSON.fromJson(element.getAsJsonObject().get("data"), BuildInfo.class));
                }
            }
            catch (JsonParseException | IllegalStateException e) {
                throw new MojoExecutionException("Error while parsing list of project builds response: " + e.getMessage(), (Exception)e);
            }
            int count = result.size() - prevCount;
            if (count < chunkSize) break;
            prevCount += count;
            ++i;
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with builds: " + result));
        }
        return result;
    }

    @Nonnull
    public static String getTranslationStatus(@Nonnull CloseableHttpClient httpClient, long projectId, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        int chunkSize = 500;
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("limit", Integer.toString(chunkSize));
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)"Requesting translations status");
        }
        JsonArray languages = new JsonArray();
        int i = 0;
        int prevCount = 0;
        while (true) {
            String response;
            parameters.put("offset", Integer.toString(i * chunkSize));
            try {
                response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.GET, "projects/" + projectId + "/languages/progress", parameters, null, token, null, null, String.class, logger);
            }
            catch (HttpException e) {
                throw new MojoExecutionException("Error while requesting translations status: " + e.getMessage(), (Exception)((Object)e));
            }
            try {
                JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
                JsonArray jsonArray = jsonObject.get("data").getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    languages.add(element.getAsJsonObject().get("data"));
                }
            }
            catch (JsonParseException | IllegalStateException e) {
                throw new MojoExecutionException("Error while parsing translations status response: " + e.getMessage(), (Exception)e);
            }
            int count = languages.size() - prevCount;
            if (count < chunkSize) break;
            prevCount += count;
            ++i;
        }
        String result = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson((JsonElement)languages);
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with translations status for " + languages.size() + " languages"));
        }
        return result;
    }

    @Nonnull
    public static ProjectInfo getProjectInfo(@Nonnull CloseableHttpClient httpClient, long projectId, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        ProjectInfo result;
        String response;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)"Requesting project info");
        }
        try {
            response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.GET, "projects/" + projectId, null, null, token, null, null, String.class, logger);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while requesting project info: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
            result = (ProjectInfo)GSON.fromJson((JsonElement)jsonObject.get("data").getAsJsonObject(), ProjectInfo.class);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new MojoExecutionException("Error while parsing project info response: " + e.getMessage(), (Exception)e);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with project info: " + result));
        }
        return result;
    }

    @Nonnull
    public static DownloadLinkInfo getDownloadLink(@Nonnull CloseableHttpClient httpClient, long projectId, long buildId, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        DownloadLinkInfo result;
        String response;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Requesting download link for buildId " + buildId));
        }
        try {
            response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.GET, "projects/" + projectId + "/translations/builds/" + buildId + "/download", null, null, token, null, null, String.class, logger);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while requesting download link for build: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
            result = (DownloadLinkInfo)GSON.fromJson((JsonElement)jsonObject.get("data").getAsJsonObject(), DownloadLinkInfo.class);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new MojoExecutionException("Error while parsing download link response: " + e.getMessage(), (Exception)e);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with download link: " + result));
        }
        return result;
    }

    @Nonnull
    public static List<FileInfo> listFiles(@Nonnull CloseableHttpClient httpClient, long projectId, @Nullable Long branchId, @Nullable Long folderId, @Nullable String filter, boolean recursion, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        int chunkSize = 500;
        if (logger != null && logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder().append("Requesting file list");
            if (branchId != null) {
                sb.append(" for branch ID ").append(branchId.toString());
            }
            if (folderId != null) {
                sb.append(" for folder ID ").append(folderId.toString());
            }
            if (filter != null) {
                sb.append(" with filter \"").append(filter).append('\"');
            }
            logger.debug((CharSequence)sb.toString());
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (branchId != null) {
            parameters.put("branchId", branchId.toString());
        }
        if (folderId != null) {
            parameters.put("directoryId", folderId.toString());
        }
        if (StringUtil.isNotBlank(filter)) {
            parameters.put("filter", filter);
        }
        if (recursion) {
            parameters.put("recursion", "1");
        }
        parameters.put("limit", Integer.toString(chunkSize));
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        int i = 0;
        int prevCount = 0;
        while (true) {
            String response;
            parameters.put("offset", Integer.toString(i * chunkSize));
            try {
                response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.GET, "projects/" + projectId + "/files", parameters, null, token, null, null, String.class, logger);
            }
            catch (HttpException e) {
                throw new MojoExecutionException("Error while requesting file list: " + e.getMessage(), (Exception)((Object)e));
            }
            try {
                JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
                JsonArray jsonArray = jsonObject.get("data").getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    result.add((FileInfo)GSON.fromJson(element.getAsJsonObject().get("data"), FileInfo.class));
                }
            }
            catch (JsonParseException | IllegalStateException e) {
                throw new MojoExecutionException("Error while parsing file list response: " + e.getMessage(), (Exception)e);
            }
            int count = result.size() - prevCount;
            if (count < chunkSize) break;
            prevCount += count;
            ++i;
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with " + result.size() + " files"));
        }
        return result;
    }

    @Nullable
    public static FileInfo getFileIfExists(@Nonnull CloseableHttpClient httpClient, long projectId, @Nullable BranchInfo branch, @Nullable FolderInfo folder, @Nullable String fileName, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        if (StringUtil.isBlank(fileName)) {
            return null;
        }
        List<String> elements = FileUtil.splitPath(fileName, false);
        if (elements.isEmpty()) {
            return null;
        }
        String name = elements.get(elements.size() - 1);
        FileInfo result = null;
        List<FileInfo> files = CrowdinAPI.listFiles(httpClient, projectId, folder != null || branch == null ? null : Long.valueOf(branch.getId()), folder == null ? null : Long.valueOf(folder.getId()), name, false, token, logger);
        for (FileInfo fileInfo : files) {
            if (!name.equals(fileInfo.getName()) || (branch != null || fileInfo.getBranchId() != null) && (branch == null || fileInfo.getBranchId().longValue() != branch.getId()) || (folder != null || fileInfo.getDirectoryId() != null) && (folder == null || fileInfo.getDirectoryId().longValue() != folder.getId())) continue;
            result = fileInfo;
            break;
        }
        return result;
    }

    @Nonnull
    public static FileInfo getFile(@Nonnull CloseableHttpClient httpClient, long projectId, long fileId, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        FileInfo result;
        String response;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Requesting file info for ID " + fileId));
        }
        try {
            response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.GET, "projects/" + projectId + "/files/" + fileId, null, null, token, null, null, String.class, logger);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while requesting file info: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
            result = (FileInfo)GSON.fromJson(jsonObject.get("data"), FileInfo.class);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new MojoExecutionException("Error while parsing file info response: " + e.getMessage(), (Exception)e);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with file info: " + result));
        }
        return result;
    }

    @Nonnull
    public static List<FolderInfo> listFolders(@Nonnull CloseableHttpClient httpClient, long projectId, @Nullable Long branchId, @Nullable Long parentFolderId, @Nullable String filter, boolean recursion, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        int chunkSize = 500;
        if (logger != null && logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder().append("Requesting folder list");
            if (branchId != null) {
                sb.append(" for branch ID ").append(branchId.toString());
            }
            if (parentFolderId != null) {
                sb.append(" for parent folder ID ").append(parentFolderId.toString());
            }
            if (filter != null) {
                sb.append(" with filter \"").append(filter).append('\"');
            }
            logger.debug((CharSequence)sb.toString());
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (branchId != null) {
            parameters.put("branchId", branchId.toString());
        }
        if (parentFolderId != null) {
            parameters.put("directoryId", parentFolderId.toString());
        }
        if (StringUtil.isNotBlank(filter)) {
            parameters.put("filter", filter);
        }
        if (recursion) {
            parameters.put("recursion", "1");
        }
        parameters.put("limit", Integer.toString(chunkSize));
        ArrayList<FolderInfo> result = new ArrayList<FolderInfo>();
        int i = 0;
        int prevCount = 0;
        while (true) {
            String response;
            parameters.put("offset", Integer.toString(i * chunkSize));
            try {
                response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.GET, "projects/" + projectId + "/directories", parameters, null, token, null, null, String.class, logger);
            }
            catch (HttpException e) {
                throw new MojoExecutionException("Error while requesting folder list: " + e.getMessage(), (Exception)((Object)e));
            }
            try {
                JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
                JsonArray jsonArray = jsonObject.get("data").getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    result.add((FolderInfo)GSON.fromJson(element.getAsJsonObject().get("data"), FolderInfo.class));
                }
            }
            catch (JsonParseException | IllegalStateException e) {
                throw new MojoExecutionException("Error while parsing folder list response: " + e.getMessage(), (Exception)e);
            }
            int count = result.size() - prevCount;
            if (count < chunkSize) break;
            prevCount += count;
            ++i;
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with " + result.size() + " folders"));
        }
        return result;
    }

    @Nonnull
    public static FolderInfo getFolder(@Nonnull CloseableHttpClient httpClient, long projectId, long folderId, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        FolderInfo result;
        String response;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Requesting folder info for ID " + folderId));
        }
        try {
            response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.GET, "projects/" + projectId + "/directories/" + folderId, null, null, token, null, null, String.class, logger);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while requesting folder info: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
            result = (FolderInfo)GSON.fromJson(jsonObject.get("data"), FolderInfo.class);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new MojoExecutionException("Error while parsing folder info response: " + e.getMessage(), (Exception)e);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with folder info: " + result));
        }
        return result;
    }

    @Nonnull
    public static FolderInfo createFolder(@Nonnull CloseableHttpClient httpClient, long projectId, @Nonnull String name, @Nullable Long branchId, @Nullable Long parentFolderId, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        FolderInfo result;
        String response;
        CreateFolderRequest payload = new CreateFolderRequest(name);
        payload.setBranchId(branchId);
        payload.setDirectoryId(parentFolderId);
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Requesting a new folder with: " + payload));
        }
        try {
            response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.POST, "projects/" + projectId + "/directories", null, null, token, payload, ContentType.APPLICATION_JSON, String.class, logger);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while creating folder: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
            result = (FolderInfo)GSON.fromJson(jsonObject.get("data"), FolderInfo.class);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new MojoExecutionException("Error while parsing folder creation response: " + e.getMessage(), (Exception)e);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with new folder: " + result));
        }
        return result;
    }

    @Nonnull
    public static FileInfo createFile(@Nonnull CloseableHttpClient httpClient, long projectId, @Nonnull StorageInfo storage, @Nonnull String name, @Nullable FileType type, @Nullable Long branchId, @Nullable Long folderId, @Nullable String title, @Nullable String context, @Nullable String[] excludedTargetLanguages, @Nullable FileExportOptions exportOptions, @Nullable FileImportOptions importOptions, @Nullable Integer parserVersion, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        FileInfo result;
        String response;
        CreateFileRequest payload = new CreateFileRequest(storage, name);
        payload.setBranchId(branchId);
        if (StringUtil.isNotBlank(context)) {
            payload.setContext(context);
        }
        payload.setDirectoryId(folderId);
        payload.setExcludedTargetLanguages(excludedTargetLanguages);
        payload.setExportOptions(exportOptions);
        payload.setImportOptions(importOptions);
        payload.setParserVersion(parserVersion);
        if (StringUtil.isNotBlank(title)) {
            payload.setTitle(title);
        }
        payload.setType(type);
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Requesting a new file with: " + payload));
        }
        try {
            response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.POST, "projects/" + projectId + "/files", null, null, token, payload, ContentType.APPLICATION_JSON, String.class, logger);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while creating file: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
            result = (FileInfo)GSON.fromJson(jsonObject.get("data"), FileInfo.class);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new MojoExecutionException("Error while parsing file creation response: " + e.getMessage(), (Exception)e);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with new file: " + result));
        }
        return result;
    }

    @Nullable
    public static FileInfo updateFile(@Nonnull CloseableHttpClient httpClient, long projectId, long fileId, @Nonnull StorageInfo storage, @Nullable UpdateOption updateOption, @Nullable FileImportOptions importOptions, @Nullable FileExportOptions exportOptions, @Nullable Boolean replaceModifiedContext, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        boolean modified;
        FileInfo result;
        String responseStatus;
        String responseContent;
        UpdateFileRequest payload = new UpdateFileRequest(storage);
        payload.setUpdateOption(updateOption);
        payload.setImportOptions(importOptions);
        payload.setExportOptions(exportOptions);
        payload.setReplaceModifiedContext(replaceModifiedContext);
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Requesting a file update with: " + payload));
        }
        RequestBuilder requestBuilder = RequestBuilder.create((String)"PUT");
        requestBuilder.setUri("https://api.crowdin.com/api/v2/projects/" + projectId + "/files/" + fileId);
        requestBuilder.addHeader("Authorization", "Bearer " + token);
        requestBuilder.setEntity((HttpEntity)new StringEntity(GSON.toJson((Object)payload), ContentType.APPLICATION_JSON));
        try {
            HttpUriRequest request = requestBuilder.build();
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug((CharSequence)("Calling " + request.getURI().toString()));
            }
            try (CloseableHttpResponse response = httpClient.execute(request);){
                StatusLine statusLine = response.getStatusLine();
                if (statusLine == null) {
                    throw new HttpException("Request \"" + request.getURI() + "\" returned no status");
                }
                int statusCode = statusLine.getStatusCode();
                if (statusCode < 200 || statusCode >= 300) {
                    throw new HttpException("Request \"" + request.getURI() + "\" failed with: " + CrowdinAPI.entityToString(response.getEntity()));
                }
                if (logger != null && logger.isDebugEnabled()) {
                    logger.debug((CharSequence)("Crowdin API replied with status code " + statusCode));
                }
                responseContent = CrowdinAPI.entityToString(response.getEntity());
                Header[] headers = response.getHeaders("Crowdin-API-Content-Status");
                responseStatus = headers.length > 0 ? headers[0].getValue() : null;
            }
            catch (IOException e) {
                throw new HttpException("Error closing HTTPResponse: " + e.getMessage(), (Throwable)e);
            }
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while updating file: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)responseContent).getAsJsonObject();
            result = (FileInfo)GSON.fromJson(jsonObject.get("data"), FileInfo.class);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new MojoExecutionException("Error while parsing file update response: " + e.getMessage(), (Exception)e);
        }
        boolean bl = modified = !"not-modified".equals(responseStatus);
        if (logger != null && logger.isDebugEnabled()) {
            if (modified) {
                logger.debug((CharSequence)("Crowdin responded with updated file: " + result));
            } else {
                logger.debug((CharSequence)("Crowdin did not modify file: " + result));
            }
        }
        return modified ? result : null;
    }

    @Nonnull
    public static List<StorageInfo> listStorages(@Nonnull CloseableHttpClient httpClient, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        int chunkSize = 500;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)"Requesting list of storages");
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("limit", Integer.toString(chunkSize));
        ArrayList<StorageInfo> result = new ArrayList<StorageInfo>();
        int i = 0;
        int prevCount = 0;
        while (true) {
            String response;
            parameters.put("offset", Integer.toString(i * chunkSize));
            try {
                response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.GET, "storages", parameters, null, token, null, null, String.class, logger);
            }
            catch (HttpException e) {
                throw new MojoExecutionException("Error while requesting list of storages: " + e.getMessage(), (Exception)((Object)e));
            }
            try {
                JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
                JsonArray jsonArray = jsonObject.get("data").getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    result.add((StorageInfo)GSON.fromJson(element.getAsJsonObject().get("data"), StorageInfo.class));
                }
            }
            catch (JsonParseException | IllegalStateException e) {
                throw new MojoExecutionException("Error while parsing storages list response: " + e.getMessage(), (Exception)e);
            }
            int count = result.size() - prevCount;
            if (count < chunkSize) break;
            prevCount += count;
            ++i;
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with " + result.size() + " storages"));
        }
        return result;
    }

    @Nonnull
    public static StorageInfo createStorage(@Nonnull CloseableHttpClient httpClient, @Nonnull String filename, @Nonnull HttpEntity entity, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        StorageInfo result;
        String response;
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Requesting a new storage for: " + filename));
        }
        ArrayList<Header> headers = new ArrayList<Header>();
        try {
            headers.add((Header)new BasicHeader("Crowdin-API-FileName", URLEncoder.encode(filename, StandardCharsets.UTF_8.name())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            response = CrowdinAPI.sendRequest(httpClient, HTTPMethod.POST, "storages", null, headers, token, entity, null, String.class, logger);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while creating storage: " + e.getMessage(), (Exception)((Object)e));
        }
        try {
            JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
            result = (StorageInfo)GSON.fromJson(jsonObject.get("data"), StorageInfo.class);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new MojoExecutionException("Error while parsing storage creation response: " + e.getMessage(), (Exception)e);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin responded with new storage: " + result));
        }
        return result;
    }

    @Nonnull
    public static void deleteStorage(@Nonnull CloseableHttpClient httpClient, @Nonnull StorageInfo storage, @Nonnull String token, @Nullable Log logger) throws MojoExecutionException {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Requesting to delete storage " + storage.getId()));
        }
        try {
            CrowdinAPI.sendRequest(httpClient, HTTPMethod.DELETE, "storages/" + storage.getId(), null, null, token, null, null, Void.class, logger);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Error while deleting storage: " + e.getMessage(), (Exception)((Object)e));
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin deleted storage: " + storage));
        }
    }

    public static <T, V> T sendRequest(@Nonnull CloseableHttpClient httpClient, @Nonnull HTTPMethod method, @Nullable String function, @Nullable Map<String, String> parameters, @Nullable Collection<Header> headers, @Nullable String token, @Nullable V payload, @Nullable ContentType payloadContentType, @Nonnull Class<T> clazz, @Nullable Log logger) throws HttpException {
        return CrowdinAPI.sendRequest(httpClient, method, URI.create("https://api.crowdin.com/api/v2/" + function), parameters, headers, token, payload, payloadContentType, clazz, logger);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, V> T sendRequest(@Nonnull CloseableHttpClient httpClient, @Nonnull HTTPMethod method, @Nonnull URI uri, @Nullable Map<String, String> parameters, @Nullable Collection<Header> headers, @Nullable String token, @Nullable V payload, @Nullable ContentType payloadContentType, @Nonnull Class<T> clazz, @Nullable Log logger) throws HttpException {
        RequestBuilder requestBuilder;
        block40: {
            block41: {
                block42: {
                    requestBuilder = RequestBuilder.create((String)method.getValue());
                    requestBuilder.setUri(uri);
                    if (parameters != null) {
                        for (Map.Entry<String, String> entry : parameters.entrySet()) {
                            requestBuilder.addParameter(entry.getKey(), entry.getValue());
                        }
                    }
                    if (StringUtil.isNotBlank(token)) {
                        requestBuilder.addHeader("Authorization", "Bearer " + token);
                    }
                    if (headers != null) {
                        for (Header header : headers) {
                            requestBuilder.addHeader(header);
                        }
                    }
                    if (payload == null) break block41;
                    if (!(payload instanceof HttpEntity)) break block42;
                    requestBuilder.setEntity((HttpEntity)payload);
                    break block40;
                }
                if (payload instanceof String) {
                    requestBuilder.setEntity((HttpEntity)new StringEntity((String)payload, payloadContentType != null ? payloadContentType : ContentType.APPLICATION_OCTET_STREAM));
                    break block40;
                } else if (payload instanceof InputStream) {
                    requestBuilder.setEntity((HttpEntity)new InputStreamEntity((InputStream)payload, payloadContentType != null ? payloadContentType : ContentType.APPLICATION_OCTET_STREAM));
                    break block40;
                } else {
                    requestBuilder.setEntity((HttpEntity)new StringEntity(GSON.toJson(payload), ContentType.APPLICATION_JSON));
                }
                break block40;
            }
            if (method == HTTPMethod.POST) {
                requestBuilder.setEntity((HttpEntity)new StringEntity("", ContentType.APPLICATION_JSON));
            }
        }
        HttpUriRequest request = requestBuilder.build();
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Calling " + request.getURI().toString()));
        }
        try (CloseableHttpResponse response = httpClient.execute(request);){
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null) {
                throw new HttpException("Request \"" + request.getURI() + "\" returned no status");
            }
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200) throw new HttpException("Request \"" + request.getURI() + "\" failed with: " + CrowdinAPI.entityToString(response.getEntity()));
            if (statusCode >= 300) {
                throw new HttpException("Request \"" + request.getURI() + "\" failed with: " + CrowdinAPI.entityToString(response.getEntity()));
            }
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug((CharSequence)("Crowdin API replied with status code " + statusCode));
            }
            if (Void.class.equals(clazz)) {
                T t = null;
                return t;
            }
            if (InputStream.class.equals(clazz)) {
                InputStream inputStream = response.getEntity().getContent();
                return (T)inputStream;
            }
            if (String.class.equals(clazz)) {
                String string = CrowdinAPI.entityToString(response.getEntity());
                return (T)string;
            }
            Object object = GSON.fromJson(CrowdinAPI.entityToString(response.getEntity()), clazz);
            return (T)object;
        }
        catch (IOException e) {
            throw new HttpException("An HTTP error occurred while sending request: " + e.getMessage(), (Throwable)e);
        }
    }

    public static CloseableHttpResponse sendStreamRequest(@Nonnull CloseableHttpClient httpClient, @Nonnull HTTPMethod method, @Nonnull URI uri, @Nullable String token, @Nullable Log logger) throws HttpException {
        int statusCode;
        CloseableHttpResponse response;
        RequestBuilder requestBuilder = RequestBuilder.create((String)method.getValue());
        requestBuilder.setUri(uri);
        if (StringUtil.isNotBlank(token)) {
            requestBuilder.addHeader("Authorization", "Bearer " + token);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Calling " + requestBuilder.getUri().toString()));
        }
        HttpUriRequest request = requestBuilder.build();
        try {
            response = httpClient.execute(request);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null) {
                httpClient.close();
                throw new HttpException("Request \"" + request.getURI() + "\" returned no status");
            }
            statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                String error = CrowdinAPI.entityToString(response.getEntity());
                httpClient.close();
                throw new HttpException("Request \"" + request.getURI() + "\" failed with: " + error);
            }
        }
        catch (IOException e) {
            throw new HttpException("An HTTP error occurred while sending request: " + e.getMessage(), (Throwable)e);
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Crowdin API replied with status code " + statusCode));
        }
        return response;
    }

    @Nullable
    public static String entityToString(@Nullable HttpEntity entity) throws IOException {
        int read;
        if (entity == null) {
            return null;
        }
        InputStream stream = entity.getContent();
        int bufferSize = 1024;
        char[] buffer = new char[bufferSize];
        StringBuilder result = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(stream, StandardCharsets.UTF_8);
        while ((read = ((Reader)isr).read(buffer, 0, buffer.length)) > 0) {
            result.append(buffer, 0, read);
        }
        return result.toString();
    }

    public static enum HTTPMethod {
        DELETE("DELETE"),
        GET("GET"),
        HEAD("HEAD"),
        PATCH("PATCH"),
        POST("POST"),
        PUT("PUT");

        @Nonnull
        private final String value;

        private HTTPMethod(String value) {
            this.value = value;
        }

        @Nonnull
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

