/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.api;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.digitalmediaserver.crowdin.api.FileType;

public class FileExportOptions {
    @Nullable
    private String exportPattern;
    @Nullable
    private Integer escapeQuotes;
    @Nullable
    private Integer escapeSpecialCharacters;
    @Nullable
    private JavaScriptExportQuotes exportQuotes;

    public void validate(@Nullable FileType fileType) throws MojoExecutionException {
        if (fileType == null || fileType == FileType.auto) {
            return;
        }
        if (this.escapeQuotes != null && fileType != FileType.properties && fileType != FileType.properties_play) {
            throw new MojoExecutionException("FileExportOptions validation failed: escapeQuotes is only valid for Properties files");
        }
        if (this.escapeSpecialCharacters != null && fileType != FileType.properties && fileType != FileType.properties_play) {
            throw new MojoExecutionException("FileExportOptions validation failed: escapeSpecialCharacters is only valid for Properties files");
        }
        if (this.exportQuotes != null && fileType != FileType.js) {
            throw new MojoExecutionException("FileExportOptions validation failed: escapeSpecialCharacters is only valid for JavaScript files");
        }
    }

    @Nullable
    public String getExportPattern() {
        return this.exportPattern;
    }

    public void setExportPattern(@Nullable String exportPattern) {
        this.exportPattern = exportPattern;
    }

    public Integer getEscapeQuotes() {
        return this.escapeQuotes;
    }

    public void setEscapeQuotes(Integer escapeQuotes) {
        this.escapeQuotes = escapeQuotes;
    }

    public Integer getEscapeSpecialCharacters() {
        return this.escapeSpecialCharacters;
    }

    public void setEscapeSpecialCharacters(Integer escapeSpecialCharacters) {
        this.escapeSpecialCharacters = escapeSpecialCharacters;
    }

    public JavaScriptExportQuotes getExportQuotes() {
        return this.exportQuotes;
    }

    public void setExportQuotes(JavaScriptExportQuotes exportQuotes) {
        this.exportQuotes = exportQuotes;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.escapeQuotes, this.escapeSpecialCharacters, this.exportPattern, this.exportQuotes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileExportOptions)) {
            return false;
        }
        FileExportOptions other = (FileExportOptions)obj;
        return Objects.equals(this.escapeQuotes, other.escapeQuotes) && Objects.equals(this.escapeSpecialCharacters, other.escapeSpecialCharacters) && Objects.equals(this.exportPattern, other.exportPattern) && this.exportQuotes == other.exportQuotes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FileExportOptions [");
        if (this.exportPattern != null) {
            sb.append("exportPattern=").append(this.exportPattern).append(", ");
        }
        if (this.escapeQuotes != null) {
            sb.append("escapeQuotes=").append(this.escapeQuotes).append(", ");
        }
        if (this.escapeSpecialCharacters != null) {
            sb.append("escapeSpecialCharacters=").append(this.escapeSpecialCharacters).append(", ");
        }
        if (this.exportQuotes != null) {
            sb.append("exportQuotes=").append((Object)this.exportQuotes);
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum JavaScriptExportQuotes {
        SINGLE,
        DOUBLE;

    }
}

