/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.api;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.digitalmediaserver.crowdin.api.FileType;

public class FileImportOptions {
    @Nullable
    private Boolean contentSegmentation;
    @Nullable
    private Boolean customSegmentation;
    @Nullable
    private Long srxStorageId;
    @Nullable
    private Boolean firstLineContainsHeader;
    @Nullable
    private Boolean importHiddenSheets;
    @Nullable
    private Boolean importTranslations;
    @Nullable
    private Boolean translateContent;
    @Nullable
    private Boolean translateAttributes;
    @Nullable
    private String[] translatableElements;
    @Nullable
    private Boolean cleanTagsAggressively;
    @Nullable
    private Boolean translateHiddenText;
    @Nullable
    private Boolean translateHyperlinkUrls;
    @Nullable
    private Boolean translateHiddenRowsAndColumns;
    @Nullable
    private Boolean importNotes;
    @Nullable
    private Boolean importHiddenSlides;
    @Nullable
    private String[] excludedElements;
    @Nullable
    private String[] excludedFrontMatterElements;
    @Nullable
    private Boolean excludeCodeBlocks;
    @Nullable
    private Boolean importKeyAsSource;
    @Nullable
    private Boolean excludeIncludeDirectives;

    public void validate(@Nullable FileType fileType) throws MojoExecutionException {
        if (fileType == null || fileType == FileType.auto) {
            return;
        }
        if (this.contentSegmentation != null && fileType != FileType.adoc && fileType != FileType.android && fileType != FileType.arb && fileType != FileType.chrome && fileType != FileType.csv && fileType != FileType.dita && fileType != FileType.docx && fileType != FileType.flsnp && fileType != FileType.fm_html && fileType != FileType.fm_md && fileType != FileType.go_json && fileType != FileType.html && fileType != FileType.i18next_json && fileType != FileType.idml && fileType != FileType.json && fileType != FileType.nestjs_i18n && fileType != FileType.md && fileType != FileType.mdx_v1 && fileType != FileType.mdx_v2 && fileType != FileType.mif && fileType != FileType.webxml && fileType != FileType.xlsx && fileType != FileType.xml) {
            throw new MojoExecutionException("FileImportOptions validation failed: contentSegmentation is only valid for xml, md, flsnp, docx, mif, idml, dita, android8 files");
        }
        if (this.customSegmentation != null && fileType != FileType.adoc && fileType != FileType.dita && fileType != FileType.docx && fileType != FileType.flsnp && fileType != FileType.fm_html && fileType != FileType.fm_md && fileType != FileType.html && fileType != FileType.idml && fileType != FileType.md && fileType != FileType.mdx_v1 && fileType != FileType.mdx_v2 && fileType != FileType.mediawiki && fileType != FileType.mif && fileType != FileType.txt && fileType != FileType.webxml && fileType != FileType.xml) {
            throw new MojoExecutionException("FileImportOptions validation failed: customSegmentation is only valid for AsciiDoc, DITA, Office documents, Madcap Flare, HTML, Markdown, Adobe Indesign, MDX, MediaWiki, Adobe Framemaker, Plain text and XML files");
        }
        if (this.srxStorageId != null && fileType != FileType.adoc && fileType != FileType.dita && fileType != FileType.docx && fileType != FileType.flsnp && fileType != FileType.fm_html && fileType != FileType.fm_md && fileType != FileType.html && fileType != FileType.idml && fileType != FileType.md && fileType != FileType.mdx_v1 && fileType != FileType.mdx_v2 && fileType != FileType.mediawiki && fileType != FileType.mif && fileType != FileType.txt && fileType != FileType.webxml && fileType != FileType.xml) {
            throw new MojoExecutionException("FileImportOptions validation failed: srxStorageId is only valid for AsciiDoc, DITA, Office documents, Madcap Flare, HTML, Markdown, Adobe Indesign, MDX, MediaWiki, Adobe Framemaker, Plain text and XML files");
        }
        if (this.firstLineContainsHeader != null && fileType != FileType.xlsx) {
            throw new MojoExecutionException("FileImportOptions validation failed: firstLineContainsHeader is only valid for .xls(x) files");
        }
        if (this.importHiddenSheets != null && fileType != FileType.xlsx) {
            throw new MojoExecutionException("FileImportOptions validation failed: importHiddenSheets is only valid for .xls(x) files");
        }
        if (this.importTranslations != null && fileType != FileType.xlsx) {
            throw new MojoExecutionException("FileImportOptions validation failed: importTranslations is only valid for .xls(x) files");
        }
        if (this.translateContent != null && fileType != FileType.xml) {
            throw new MojoExecutionException("FileImportOptions validation failed: translateContent is only valid for XML files");
        }
        if (this.translateAttributes != null && fileType != FileType.xml) {
            throw new MojoExecutionException("FileImportOptions validation failed: translateAttributes is only valid for XML files");
        }
        if (this.translatableElements != null && fileType != FileType.xml) {
            throw new MojoExecutionException("FileImportOptions validation failed: translatableElements is only valid for XML files");
        }
        if (this.cleanTagsAggressively != null && fileType != FileType.docx && fileType != FileType.xlsx) {
            throw new MojoExecutionException("FileImportOptions validation failed: cleanTagsAggressively is only valid for Office documents");
        }
        if (this.translateHiddenText != null && fileType != FileType.docx) {
            throw new MojoExecutionException("FileImportOptions validation failed: translateHiddenText is only valid for Office documents");
        }
        if (this.translateHyperlinkUrls != null && fileType != FileType.docx) {
            throw new MojoExecutionException("FileImportOptions validation failed: translateHyperlinkUrls is only valid for Office documents");
        }
        if (this.translateHiddenRowsAndColumns != null && fileType != FileType.xlsx) {
            throw new MojoExecutionException("FileImportOptions validation failed: translateHiddenRowsAndColumns is only valid for Excel documents");
        }
        if (this.importNotes != null && fileType != FileType.docx) {
            throw new MojoExecutionException("FileImportOptions validation failed: importNotes is only valid for Office documents");
        }
        if (this.importHiddenSlides != null && fileType != FileType.docx) {
            throw new MojoExecutionException("FileImportOptions validation failed: importHiddenSlides is only valid for Office documents");
        }
        if (this.excludedElements != null && fileType != FileType.html && fileType != FileType.fm_html) {
            throw new MojoExecutionException("FileImportOptions validation failed: excludedElements is only valid for HTML files");
        }
        if (this.excludedFrontMatterElements != null && fileType != FileType.fm_html && fileType != FileType.mdx_v1 && fileType != FileType.mdx_v2) {
            throw new MojoExecutionException("FileImportOptions validation failed: excludedFrontMatterElements is only valid for FrontMatter and MDX files");
        }
        if (this.excludeCodeBlocks != null && fileType != FileType.mdx_v1 && fileType != FileType.mdx_v2) {
            throw new MojoExecutionException("FileImportOptions validation failed: excludeCodeBlocks is only valid for MDX files");
        }
        if (this.importKeyAsSource != null) {
            throw new MojoExecutionException("FileImportOptions validation failed: importKeyAsSource is only valid for String Catalog files");
        }
        if (this.excludeIncludeDirectives != null && fileType != FileType.adoc) {
            throw new MojoExecutionException("FileImportOptions validation failed: excludeIncludeDirectives is only valid for AsciiDoc files");
        }
    }

    @Nullable
    public Boolean getContentSegmentation() {
        return this.contentSegmentation;
    }

    public void setContentSegmentation(Boolean contentSegmentation) {
        this.contentSegmentation = contentSegmentation;
    }

    @Nullable
    public Boolean getCustomSegmentation() {
        return this.customSegmentation;
    }

    public void setCustomSegmentation(Boolean customSegmentation) {
        this.customSegmentation = customSegmentation;
    }

    @Nullable
    public Long getSrxStorageId() {
        return this.srxStorageId;
    }

    public void setSrxStorageId(Long srxStorageId) {
        this.srxStorageId = srxStorageId;
    }

    @Nullable
    public Boolean getFirstLineContainsHeader() {
        return this.firstLineContainsHeader;
    }

    public void setFirstLineContainsHeader(Boolean firstLineContainsHeader) {
        this.firstLineContainsHeader = firstLineContainsHeader;
    }

    @Nullable
    public Boolean getImportHiddenSheets() {
        return this.importHiddenSheets;
    }

    public void setImportHiddenSheets(Boolean importHiddenSheets) {
        this.importHiddenSheets = importHiddenSheets;
    }

    @Nullable
    public Boolean getImportTranslations() {
        return this.importTranslations;
    }

    public void setImportTranslations(Boolean importTranslations) {
        this.importTranslations = importTranslations;
    }

    @Nullable
    public Boolean getTranslateContent() {
        return this.translateContent;
    }

    public void setTranslateContent(Boolean translateContent) {
        this.translateContent = translateContent;
    }

    @Nullable
    public Boolean getTranslateAttributes() {
        return this.translateAttributes;
    }

    public void setTranslateAttributes(Boolean translateAttributes) {
        this.translateAttributes = translateAttributes;
    }

    @Nullable
    public String[] getTranslatableElements() {
        return this.translatableElements;
    }

    public void setTranslatableElements(String[] translatableElements) {
        this.translatableElements = translatableElements;
    }

    @Nullable
    public Boolean getCleanTagsAggressively() {
        return this.cleanTagsAggressively;
    }

    public void setCleanTagsAggressively(Boolean cleanTagsAggressively) {
        this.cleanTagsAggressively = cleanTagsAggressively;
    }

    @Nullable
    public Boolean getTranslateHiddenText() {
        return this.translateHiddenText;
    }

    public void setTranslateHiddenText(Boolean translateHiddenText) {
        this.translateHiddenText = translateHiddenText;
    }

    @Nullable
    public Boolean getTranslateHyperlinkUrls() {
        return this.translateHyperlinkUrls;
    }

    public void setTranslateHyperlinkUrls(Boolean translateHyperlinkUrls) {
        this.translateHyperlinkUrls = translateHyperlinkUrls;
    }

    @Nullable
    public Boolean getTranslateHiddenRowsAndColumns() {
        return this.translateHiddenRowsAndColumns;
    }

    public void setTranslateHiddenRowsAndColumns(Boolean translateHiddenRowsAndColumns) {
        this.translateHiddenRowsAndColumns = translateHiddenRowsAndColumns;
    }

    @Nullable
    public Boolean getImportNotes() {
        return this.importNotes;
    }

    public void setImportNotes(Boolean importNotes) {
        this.importNotes = importNotes;
    }

    @Nullable
    public Boolean getImportHiddenSlides() {
        return this.importHiddenSlides;
    }

    public void setImportHiddenSlides(Boolean importHiddenSlides) {
        this.importHiddenSlides = importHiddenSlides;
    }

    @Nullable
    public String[] getExcludedElements() {
        return this.excludedElements;
    }

    public void setExcludedElements(String[] excludedElements) {
        this.excludedElements = excludedElements;
    }

    @Nullable
    public String[] getExcludedFrontMatterElements() {
        return this.excludedFrontMatterElements;
    }

    public void setExcludedFrontMatterElements(String[] excludedFrontMatterElements) {
        this.excludedFrontMatterElements = excludedFrontMatterElements;
    }

    @Nullable
    public Boolean getExcludeCodeBlocks() {
        return this.excludeCodeBlocks;
    }

    public void setExcludeCodeBlocks(Boolean excludeCodeBlocks) {
        this.excludeCodeBlocks = excludeCodeBlocks;
    }

    @Nullable
    public Boolean getImportKeyAsSource() {
        return this.importKeyAsSource;
    }

    public void setImportKeyAsSource(Boolean importKeyAsSource) {
        this.importKeyAsSource = importKeyAsSource;
    }

    @Nullable
    public Boolean getExcludeIncludeDirectives() {
        return this.excludeIncludeDirectives;
    }

    public void setExcludeIncludeDirectives(Boolean excludeIncludeDirectives) {
        this.excludeIncludeDirectives = excludeIncludeDirectives;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.excludedElements);
        result = 31 * result + Arrays.hashCode(this.excludedFrontMatterElements);
        result = 31 * result + Arrays.hashCode(this.translatableElements);
        result = 31 * result + Objects.hash(this.cleanTagsAggressively, this.contentSegmentation, this.customSegmentation, this.excludeCodeBlocks, this.excludeIncludeDirectives, this.firstLineContainsHeader, this.importHiddenSheets, this.importHiddenSlides, this.importKeyAsSource, this.importNotes, this.importTranslations, this.srxStorageId, this.translateAttributes, this.translateContent, this.translateHiddenRowsAndColumns, this.translateHiddenText, this.translateHyperlinkUrls);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileImportOptions)) {
            return false;
        }
        FileImportOptions other = (FileImportOptions)obj;
        return Objects.equals(this.cleanTagsAggressively, other.cleanTagsAggressively) && Objects.equals(this.contentSegmentation, other.contentSegmentation) && Objects.equals(this.customSegmentation, other.customSegmentation) && Objects.equals(this.excludeCodeBlocks, other.excludeCodeBlocks) && Objects.equals(this.excludeIncludeDirectives, other.excludeIncludeDirectives) && Arrays.equals(this.excludedElements, other.excludedElements) && Arrays.equals(this.excludedFrontMatterElements, other.excludedFrontMatterElements) && Objects.equals(this.firstLineContainsHeader, other.firstLineContainsHeader) && Objects.equals(this.importHiddenSheets, other.importHiddenSheets) && Objects.equals(this.importHiddenSlides, other.importHiddenSlides) && Objects.equals(this.importKeyAsSource, other.importKeyAsSource) && Objects.equals(this.importNotes, other.importNotes) && Objects.equals(this.importTranslations, other.importTranslations) && Objects.equals(this.srxStorageId, other.srxStorageId) && Arrays.equals(this.translatableElements, other.translatableElements) && Objects.equals(this.translateAttributes, other.translateAttributes) && Objects.equals(this.translateContent, other.translateContent) && Objects.equals(this.translateHiddenRowsAndColumns, other.translateHiddenRowsAndColumns) && Objects.equals(this.translateHiddenText, other.translateHiddenText) && Objects.equals(this.translateHyperlinkUrls, other.translateHyperlinkUrls);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FileImportOptions [");
        if (this.contentSegmentation != null) {
            builder.append("contentSegmentation=").append(this.contentSegmentation).append(", ");
        }
        if (this.customSegmentation != null) {
            builder.append("customSegmentation=").append(this.customSegmentation).append(", ");
        }
        if (this.srxStorageId != null) {
            builder.append("srxStorageId=").append(this.srxStorageId).append(", ");
        }
        if (this.firstLineContainsHeader != null) {
            builder.append("firstLineContainsHeader=").append(this.firstLineContainsHeader).append(", ");
        }
        if (this.importHiddenSheets != null) {
            builder.append("importHiddenSheets=").append(this.importHiddenSheets).append(", ");
        }
        if (this.importTranslations != null) {
            builder.append("importTranslations=").append(this.importTranslations).append(", ");
        }
        if (this.translateContent != null) {
            builder.append("translateContent=").append(this.translateContent).append(", ");
        }
        if (this.translateAttributes != null) {
            builder.append("translateAttributes=").append(this.translateAttributes).append(", ");
        }
        if (this.translatableElements != null) {
            builder.append("translatableElements=").append(Arrays.toString(this.translatableElements)).append(", ");
        }
        if (this.cleanTagsAggressively != null) {
            builder.append("cleanTagsAggressively=").append(this.cleanTagsAggressively).append(", ");
        }
        if (this.translateHiddenText != null) {
            builder.append("translateHiddenText=").append(this.translateHiddenText).append(", ");
        }
        if (this.translateHyperlinkUrls != null) {
            builder.append("translateHyperlinkUrls=").append(this.translateHyperlinkUrls).append(", ");
        }
        if (this.translateHiddenRowsAndColumns != null) {
            builder.append("translateHiddenRowsAndColumns=").append(this.translateHiddenRowsAndColumns).append(", ");
        }
        if (this.importNotes != null) {
            builder.append("importNotes=").append(this.importNotes).append(", ");
        }
        if (this.importHiddenSlides != null) {
            builder.append("importHiddenSlides=").append(this.importHiddenSlides).append(", ");
        }
        if (this.excludedElements != null) {
            builder.append("excludedElements=").append(Arrays.toString(this.excludedElements)).append(", ");
        }
        if (this.excludedFrontMatterElements != null) {
            builder.append("excludedFrontMatterElements=").append(Arrays.toString(this.excludedFrontMatterElements)).append(", ");
        }
        if (this.excludeCodeBlocks != null) {
            builder.append("excludeCodeBlocks=").append(this.excludeCodeBlocks).append(", ");
        }
        if (this.importKeyAsSource != null) {
            builder.append("importKeyAsSource=").append(this.importKeyAsSource).append(", ");
        }
        if (this.excludeIncludeDirectives != null) {
            builder.append("excludeIncludeDirectives=").append(this.excludeIncludeDirectives);
        }
        builder.append("]");
        return builder.toString();
    }
}

