/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import javax.annotation.Nullable;
import org.digitalmediaserver.crowdin.tool.StringUtil;

public enum FileType {
    auto(null, new String[0]),
    android("text/xml", "xml"),
    macosx("text/plain", "strings"),
    resx("application/xml", "resx", "resw"),
    properties("text/plain", "properties"),
    gettext("text/plain", "po", "pot"),
    yaml("application/yaml", "yaml", "yml"),
    php("application/x-httpd-php", "php"),
    json("application/json", "json"),
    xml("application/xml", "xml"),
    ini("text/plain", "ini"),
    rc("text/plain", "rc"),
    resw("application/xml", "resw"),
    resjson("application/json", "resjson"),
    qtts("application/xml", "ts"),
    joomla("text/plain", "ini"),
    chrome("application/json", "json"),
    dtd("text/plain", "dtd"),
    dklang("text/plain", "dklang"),
    flex("text/plain", "properties"),
    nsh("text/plain", "nsh"),
    wxl("application/xml", "wxl"),
    xliff("application/xliff+xml", "xliff", "xlf"),
    xliff_two("application/xliff+xml", "xliff", "xlf"),
    html("text/html", "html", "htm", "xhtml", "xhtm", "xht", "hbs", "liquid"),
    haml("text/x-haml", "haml"),
    txt("text/plain", "txt"),
    csv("text/csv", "csv", "tsv"),
    md("text/markdown", "md", "text", "markdown"),
    mdx_v1("text/mdx", "mdx"),
    mdx_v2("text/mdx", "mdx"),
    flsnp("application/xml", "flnsp", "flpgpl", "fltoc"),
    fm_html("text/html", "html"),
    fm_md("text/markdown", "md"),
    mediawiki("text/plain", "wiki", "wikitext", "mediawiki"),
    docx("application/vnd.openxmlformats-officedocument", "docx", "dotx", "docm", "dotm", "xltx", "xlsm", "xltm", "pptx", "potx", "ppsx", "pptm", "potm", "ppsm", "odt", "ods", "ots", "odg", "otg", "odp", "otp", "ott", "imdl", "mif"),
    xlsx("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xls", "xlsx"),
    sbv("text/plain", "sbv"),
    properties_play(null, new String[0]),
    properties_xml("application/xml", "xml"),
    maxthon("text/plain", "ini"),
    go_json("application/json", "gotext.json"),
    dita("text/xml", "dita", "ditamap"),
    mif("application/vnd.mif", "mif"),
    idml("application/vnd.adobe.indesign-idml-package", "idml"),
    stringsdict("application/xml", "stringsdict"),
    plist("application/x-plist", "plist"),
    vtt("text/vtt", "vtt"),
    vdf("text/vdf", "vdf"),
    srt("text/plain", "srt"),
    stf("text/plain", "stf"),
    toml("application/toml", "toml"),
    contentful_rt("application/json", "json"),
    svg("image/svg+xml", "svg"),
    js("text/javascript", "js"),
    coffee("application/vnd.coffeescript", "coffee"),
    ts("application/typescript", "ts"),
    i18next_json("application/json", "json"),
    xaml("application/xaml+xml", "xaml"),
    arb("text/plain", "arb"),
    adoc("text/asciidoc", "adoc"),
    fbt("application/json", "json"),
    ftl("text/plain", "ftl"),
    webxml("application/xml", "xml"),
    nestjs_i18n(null, new String[0]);

    @Nullable
    private final String[] extensions;
    @Nullable
    private final String contentType;

    private FileType(String contentType, String ... extensions) {
        this.extensions = extensions;
        this.contentType = contentType;
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public String[] getExtensions() {
        return this.extensions;
    }

    public boolean hasExtension(String extension) {
        if (StringUtil.isBlank(extension) || this.extensions == null || this.extensions.length == 0) {
            return false;
        }
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        extension = extension.trim().toLowerCase(Locale.ROOT);
        for (String memberExtension : this.extensions) {
            if (!extension.equals(memberExtension)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }
}

