/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.api.request;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.digitalmediaserver.crowdin.api.Priority;
import org.digitalmediaserver.crowdin.tool.StringUtil;

public class CreateBranchRequest {
    @Nonnull
    private final String name;
    @Nullable
    private String title;
    @Nullable
    private String exportPattern;
    @Nonnull
    private Priority priority = Priority.NORMAL;

    public CreateBranchRequest(@Nonnull String name) {
        if (StringUtil.isBlank(name)) {
            throw new IllegalArgumentException("name cannot be blank");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getExportPattern() {
        return this.exportPattern;
    }

    public void setExportPattern(String exportPattern) {
        this.exportPattern = exportPattern;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.exportPattern, this.name, this.priority, this.title});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CreateBranchRequest)) {
            return false;
        }
        CreateBranchRequest other = (CreateBranchRequest)obj;
        return Objects.equals(this.exportPattern, other.exportPattern) && Objects.equals(this.name, other.name) && this.priority == other.priority && Objects.equals(this.title, other.title);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateBranchRequest [").append("name=").append(this.name);
        if (this.title != null) {
            builder.append(", ").append("title=").append(this.title);
        }
        if (this.exportPattern != null) {
            builder.append(", ").append("exportPattern=").append(this.exportPattern);
        }
        if (this.priority != null) {
            builder.append(", ").append("priority=").append((Object)this.priority);
        }
        builder.append("]");
        return builder.toString();
    }
}

