/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.api.request;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.digitalmediaserver.crowdin.api.FileExportOptions;
import org.digitalmediaserver.crowdin.api.FileImportOptions;
import org.digitalmediaserver.crowdin.api.FileType;
import org.digitalmediaserver.crowdin.api.response.StorageInfo;

public class CreateFileRequest {
    private final long storageId;
    @Nonnull
    private final String name;
    @Nullable
    private Long branchId;
    @Nullable
    private Long directoryId;
    @Nullable
    private String title;
    @Nullable
    private String context;
    @Nullable
    private FileType type;
    @Nullable
    private Integer parserVersion;
    @Nullable
    private FileImportOptions importOptions;
    @Nullable
    private FileExportOptions exportOptions;
    @Nullable
    private String[] excludedTargetLanguages;
    @Nullable
    private long[] attachLabelIds;

    public CreateFileRequest(@Nonnull StorageInfo storage, @Nonnull String name) {
        this.storageId = storage.getId();
        this.name = name;
    }

    public Long getBranchId() {
        return this.branchId;
    }

    public void setBranchId(Long branchId) {
        this.branchId = branchId;
    }

    public Long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(Long directoryId) {
        this.directoryId = directoryId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public FileType getType() {
        return this.type;
    }

    public void setType(FileType type) {
        this.type = type;
    }

    public Integer getParserVersion() {
        return this.parserVersion;
    }

    public void setParserVersion(Integer parserVersion) {
        this.parserVersion = parserVersion;
    }

    public FileImportOptions getImportOptions() {
        return this.importOptions;
    }

    public void setImportOptions(FileImportOptions importOptions) {
        this.importOptions = importOptions;
    }

    public FileExportOptions getExportOptions() {
        return this.exportOptions;
    }

    public void setExportOptions(FileExportOptions exportOptions) {
        this.exportOptions = exportOptions;
    }

    public String[] getExcludedTargetLanguages() {
        return this.excludedTargetLanguages;
    }

    public void setExcludedTargetLanguages(String[] excludedTargetLanguages) {
        this.excludedTargetLanguages = excludedTargetLanguages;
    }

    public long[] getAttachLabelIds() {
        return this.attachLabelIds;
    }

    public void setAttachLabelIds(long[] attachLabelIds) {
        this.attachLabelIds = attachLabelIds;
    }

    public long getStorageId() {
        return this.storageId;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.attachLabelIds);
        result = 31 * result + Arrays.hashCode(this.excludedTargetLanguages);
        result = 31 * result + Objects.hash(new Object[]{this.branchId, this.context, this.directoryId, this.exportOptions, this.importOptions, this.name, this.parserVersion, this.storageId, this.title, this.type});
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CreateFileRequest)) {
            return false;
        }
        CreateFileRequest other = (CreateFileRequest)obj;
        return Arrays.equals(this.attachLabelIds, other.attachLabelIds) && Objects.equals(this.branchId, other.branchId) && Objects.equals(this.context, other.context) && Objects.equals(this.directoryId, other.directoryId) && Arrays.equals(this.excludedTargetLanguages, other.excludedTargetLanguages) && Objects.equals(this.exportOptions, other.exportOptions) && Objects.equals(this.importOptions, other.importOptions) && Objects.equals(this.name, other.name) && Objects.equals(this.parserVersion, other.parserVersion) && this.storageId == other.storageId && Objects.equals(this.title, other.title) && this.type == other.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("CreateFileRequest [storageId=").append(this.storageId).append(", ").append("name=").append(this.name).append(", ");
        if (this.branchId != null) {
            sb.append("branchId=").append(this.branchId).append(", ");
        }
        if (this.directoryId != null) {
            sb.append("directoryId=").append(this.directoryId).append(", ");
        }
        if (this.title != null) {
            sb.append("title=").append(this.title).append(", ");
        }
        if (this.context != null) {
            sb.append("context=").append(this.context).append(", ");
        }
        if (this.type != null) {
            sb.append("type=").append((Object)this.type).append(", ");
        }
        if (this.parserVersion != null) {
            sb.append("parserVersion=").append(this.parserVersion).append(", ");
        }
        if (this.importOptions != null) {
            sb.append("importOptions=").append(this.importOptions).append(", ");
        }
        if (this.exportOptions != null) {
            sb.append("exportOptions=").append(this.exportOptions).append(", ");
        }
        if (this.excludedTargetLanguages != null) {
            sb.append("excludedTargetLanguages=").append(Arrays.toString(this.excludedTargetLanguages)).append(", ");
        }
        if (this.attachLabelIds != null) {
            sb.append("attachLabelIds=").append(Arrays.toString(this.attachLabelIds));
        }
        sb.append("]");
        return sb.toString();
    }
}

