/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.api.request;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.digitalmediaserver.crowdin.api.FileExportOptions;
import org.digitalmediaserver.crowdin.api.FileImportOptions;
import org.digitalmediaserver.crowdin.api.response.StorageInfo;
import org.digitalmediaserver.crowdin.configuration.UpdateOption;

public class UpdateFileRequest {
    private final long storageId;
    private String name;
    private UpdateOption updateOption;
    private FileImportOptions importOptions;
    private FileExportOptions exportOptions;
    private long[] attachLabelIds;
    private long[] detachLabelIds;
    private Boolean replaceModifiedContext;

    public UpdateFileRequest(@Nonnull StorageInfo storage) {
        this.storageId = storage.getId();
    }

    public long getStorageId() {
        return this.storageId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateOption getUpdateOption() {
        return this.updateOption;
    }

    public void setUpdateOption(UpdateOption updateOption) {
        this.updateOption = updateOption;
    }

    public FileImportOptions getImportOptions() {
        return this.importOptions;
    }

    public void setImportOptions(FileImportOptions importOptions) {
        this.importOptions = importOptions;
    }

    public FileExportOptions getExportOptions() {
        return this.exportOptions;
    }

    public void setExportOptions(FileExportOptions exportOptions) {
        this.exportOptions = exportOptions;
    }

    public long[] getAttachLabelIds() {
        return this.attachLabelIds;
    }

    public void setAttachLabelIds(long[] attachLabelIds) {
        this.attachLabelIds = attachLabelIds;
    }

    public long[] getDetachLabelIds() {
        return this.detachLabelIds;
    }

    public void setDetachLabelIds(long[] detachLabelIds) {
        this.detachLabelIds = detachLabelIds;
    }

    public Boolean getReplaceModifiedContext() {
        return this.replaceModifiedContext;
    }

    public void setReplaceModifiedContext(Boolean replaceModifiedContext) {
        this.replaceModifiedContext = replaceModifiedContext;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.attachLabelIds);
        result = 31 * result + Arrays.hashCode(this.detachLabelIds);
        result = 31 * result + Objects.hash(new Object[]{this.exportOptions, this.importOptions, this.name, this.replaceModifiedContext, this.storageId, this.updateOption});
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UpdateFileRequest)) {
            return false;
        }
        UpdateFileRequest other = (UpdateFileRequest)obj;
        return Arrays.equals(this.attachLabelIds, other.attachLabelIds) && Arrays.equals(this.detachLabelIds, other.detachLabelIds) && Objects.equals(this.exportOptions, other.exportOptions) && Objects.equals(this.importOptions, other.importOptions) && Objects.equals(this.name, other.name) && Objects.equals(this.replaceModifiedContext, other.replaceModifiedContext) && this.storageId == other.storageId && this.updateOption == other.updateOption;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateFileRequest [storageId=").append(this.storageId).append(", ");
        if (this.name != null) {
            sb.append("name=").append(this.name).append(", ");
        }
        if (this.updateOption != null) {
            sb.append("updateOption=").append((Object)this.updateOption).append(", ");
        }
        if (this.importOptions != null) {
            sb.append("importOptions=").append(this.importOptions).append(", ");
        }
        if (this.exportOptions != null) {
            sb.append("exportOptions=").append(this.exportOptions).append(", ");
        }
        if (this.attachLabelIds != null) {
            sb.append("attachLabelIds=").append(Arrays.toString(this.attachLabelIds)).append(", ");
        }
        if (this.detachLabelIds != null) {
            sb.append("detachLabelIds=").append(Arrays.toString(this.detachLabelIds)).append(", ");
        }
        if (this.replaceModifiedContext != null) {
            sb.append("replaceModifiedContext=").append(this.replaceModifiedContext);
        }
        sb.append("]");
        return sb.toString();
    }
}

