/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.api.response;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

public class BuildInfo {
    private long id;
    private long projectId;
    private ProjectBuildStatus status;
    private int progress;
    private Date createdAt;
    private Date updatedAt;
    private Date finishedAt;
    private BuildAttributes attributes;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public ProjectBuildStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProjectBuildStatus status) {
        this.status = status;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(Date finishedAt) {
        this.finishedAt = finishedAt;
    }

    public BuildAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(BuildAttributes attributes) {
        this.attributes = attributes;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this.createdAt, this.finishedAt, this.id, this.progress, this.projectId, this.status, this.updatedAt});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BuildInfo)) {
            return false;
        }
        BuildInfo other = (BuildInfo)obj;
        return Objects.equals(this.attributes, other.attributes) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.finishedAt, other.finishedAt) && this.id == other.id && this.progress == other.progress && this.projectId == other.projectId && this.status == other.status && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("BuildInfo [id=").append(this.id).append(", projectId=").append(this.projectId).append(", ");
        if (this.status != null) {
            sb.append("status=").append((Object)this.status).append(", ");
        }
        sb.append("progress=").append(this.progress).append(", ");
        if (this.createdAt != null) {
            sb.append("createdAt=").append(this.createdAt).append(", ");
        }
        if (this.updatedAt != null) {
            sb.append("updatedAt=").append(this.updatedAt).append(", ");
        }
        if (this.finishedAt != null) {
            sb.append("finishedAt=").append(this.finishedAt).append(", ");
        }
        if (this.attributes != null) {
            sb.append("attributes=").append(this.attributes);
        }
        sb.append("]");
        return sb.toString();
    }

    public static enum ProjectBuildStatus {
        CREATED,
        IN_PROGRESS,
        CANCELED,
        FAILED,
        FINISHED;

    }

    public static class BuildAttributes {
        private Long branchId;
        private Long directoryId;
        private String[] targetLanguageIds;
        private boolean skipUntranslatedStrings;
        private boolean skipUntranslatedFiles;
        private boolean exportApprovedOnly;

        public Long getBranchId() {
            return this.branchId;
        }

        public void setBranchId(Long branchId) {
            this.branchId = branchId;
        }

        public Long getDirectoryId() {
            return this.directoryId;
        }

        public void setDirectoryId(Long directoryId) {
            this.directoryId = directoryId;
        }

        public String[] getTargetLanguageIds() {
            return this.targetLanguageIds;
        }

        public void setTargetLanguageIds(String[] targetLanguageIds) {
            this.targetLanguageIds = targetLanguageIds;
        }

        public boolean isSkipUntranslatedStrings() {
            return this.skipUntranslatedStrings;
        }

        public void setSkipUntranslatedStrings(boolean skipUntranslatedStrings) {
            this.skipUntranslatedStrings = skipUntranslatedStrings;
        }

        public boolean isSkipUntranslatedFiles() {
            return this.skipUntranslatedFiles;
        }

        public void setSkipUntranslatedFiles(boolean skipUntranslatedFiles) {
            this.skipUntranslatedFiles = skipUntranslatedFiles;
        }

        public boolean isExportApprovedOnly() {
            return this.exportApprovedOnly;
        }

        public void setExportApprovedOnly(boolean exportApprovedOnly) {
            this.exportApprovedOnly = exportApprovedOnly;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.targetLanguageIds);
            result = 31 * result + Objects.hash(this.branchId, this.directoryId, this.exportApprovedOnly, this.skipUntranslatedFiles, this.skipUntranslatedStrings);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BuildAttributes)) {
                return false;
            }
            BuildAttributes other = (BuildAttributes)obj;
            return Objects.equals(this.branchId, other.branchId) && Objects.equals(this.directoryId, other.directoryId) && this.exportApprovedOnly == other.exportApprovedOnly && this.skipUntranslatedFiles == other.skipUntranslatedFiles && this.skipUntranslatedStrings == other.skipUntranslatedStrings && Arrays.equals(this.targetLanguageIds, other.targetLanguageIds);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("BuildAttributes [");
            if (this.branchId != null) {
                sb.append("branchId=").append(this.branchId).append(", ");
            }
            if (this.directoryId != null) {
                sb.append("directoryId=").append(this.directoryId).append(", ");
            }
            if (this.targetLanguageIds != null) {
                sb.append("targetLanguageIds=").append(Arrays.toString(this.targetLanguageIds)).append(", ");
            }
            sb.append("skipUntranslatedStrings=").append(this.skipUntranslatedStrings).append(", skipUntranslatedFiles=").append(this.skipUntranslatedFiles).append(", exportApprovedOnly=").append(this.exportApprovedOnly).append("]");
            return sb.toString();
        }
    }
}

