/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.configuration;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.digitalmediaserver.crowdin.tool.StringUtil;

public enum PathPlaceholder {
    LANGUAGE("%language%", "([\\w,\\. \\(\\)]+)"),
    TWO_LETTER("%two_letters_code%", "([a-zA-Z]{2})"),
    THREE_LETTER("%three_letters_code%", "([a-zA-Z]{3})"),
    LOCALE_HYPHEN("%locale%", "([a-z]{2,3}(?:-[A-Z]{2})?)", "([a-z]{2,3})(?:-([A-Z]{2}))?"),
    LOCALE_UNDERSCORE("%locale_with_underscore%", "([a-z]{2,3}(?:_[A-Z]{2})?)", "([a-z]{2,3})(?:_([A-Z]{2}))?"),
    ANDROID_CODE("%android_code%"),
    MACOS_CODE("%osx_code%"),
    MACOS_LOCALE("%osx_locale%"),
    ORIGINAL_FILENAME("%original_file_name%", "([^<>:;,?\"*|/\\\\\\r\\n\\t]+)"),
    FILENAME("%file_name%", "([^<>:;,?\"*|/\\\\\\r\\n\\t]+)"),
    FILE_EXTENSION("%file_extension%", "([^<>:;,?\"*|/\\\\\\r\\n\\t\\.]+)"),
    ORIGINAL_PATH("%original_path%", "([^<>:;,?\"*|\\r\\n\\t]+)");

    private static final String BASIC_PATTERN = "(.*?)";
    private final String identifier;
    private final String pattern;
    private final String parsePattern;

    private PathPlaceholder(String identifier) {
        this.identifier = identifier;
        this.pattern = BASIC_PATTERN;
        this.parsePattern = BASIC_PATTERN;
    }

    private PathPlaceholder(String identifier, String pattern) {
        this.identifier = identifier;
        this.pattern = pattern;
        this.parsePattern = pattern;
    }

    private PathPlaceholder(@Nonnull String identifier, String pattern, String parsePattern) {
        this.identifier = identifier;
        this.pattern = pattern;
        this.parsePattern = parsePattern;
    }

    @Nonnull
    public String getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    public String getPattern() {
        return this.pattern;
    }

    @Nonnull
    public String getParsePattern() {
        return this.parsePattern;
    }

    @Nullable
    public static PathPlaceholder typeOf(@Nullable String value) {
        if (StringUtil.isBlank(value)) {
            return null;
        }
        for (PathPlaceholder placeholder : PathPlaceholder.values()) {
            if (!value.equals(placeholder.identifier)) continue;
            return placeholder;
        }
        return null;
    }
}

