/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.configuration;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.digitalmediaserver.crowdin.api.FileType;
import org.digitalmediaserver.crowdin.configuration.AbstractFileSet;
import org.digitalmediaserver.crowdin.tool.FileUtil;
import org.digitalmediaserver.crowdin.tool.StringUtil;

public class StatusFile
extends AbstractFileSet {
    protected String targetFile;

    @Nullable
    public String getTargetFile() {
        return this.targetFile;
    }

    @Override
    protected void initializeInstance() throws MojoExecutionException {
        if (StringUtil.isBlank(this.targetFile)) {
            throw new MojoExecutionException("\"targetFile\" must be specified for status files");
        }
        if (this.type == null) {
            String extension = FileUtil.getExtension(this.targetFile, FileUtil.LetterCase.LOWER, Locale.ROOT);
            this.type = "json".equals(extension) ? FileType.json : FileType.properties;
        }
        switch (this.type) {
            case properties: {
                if (StringUtil.isBlank(this.encoding)) {
                    this.charset = StandardCharsets.ISO_8859_1;
                    this.encoding = this.charset.name();
                } else {
                    this.charset = Charset.forName(this.encoding);
                }
                if (this.addComment == null) {
                    this.addComment = Boolean.TRUE;
                }
                if (this.sortLines == null) {
                    this.sortLines = Boolean.TRUE;
                }
                if (this.escapeUnicode != null) break;
                this.escapeUnicode = Boolean.TRUE;
                break;
            }
            case json: {
                if (StringUtil.isBlank(this.encoding)) {
                    this.charset = StandardCharsets.UTF_8;
                    this.encoding = this.charset.name();
                } else {
                    this.charset = Charset.forName(this.encoding);
                }
                if (this.addComment != null) break;
                this.addComment = Boolean.FALSE;
                break;
            }
            default: {
                throw new MojoExecutionException("Only properties and JSON formats are supported for status files");
            }
        }
        this.targetFile = FileUtil.formatPath(this.targetFile, false);
        super.initializeInstance();
    }
}

