/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.configuration;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.digitalmediaserver.crowdin.api.FileExportOptions;
import org.digitalmediaserver.crowdin.api.FileType;
import org.digitalmediaserver.crowdin.configuration.AbstractFileSet;
import org.digitalmediaserver.crowdin.configuration.UpdateOption;
import org.digitalmediaserver.crowdin.tool.FileUtil;
import org.digitalmediaserver.crowdin.tool.StringUtil;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
public class TranslationFileSet
extends AbstractFileSet {
    protected File languageFilesFolder;
    protected String crowdinPath;
    protected String baseFileName;
    protected String title;
    protected String commentTag = "#";
    protected String exportPattern;
    @Nullable
    protected String targetFileName;
    @Nullable
    protected Integer escapeQuotes;
    @Nullable
    protected Integer escapeSpecialCharacters;
    @Nullable
    protected FileExportOptions.JavaScriptExportQuotes exportQuotes;
    protected UpdateOption updateOption;
    protected Boolean replaceModifiedContext = Boolean.FALSE;
    @Nullable
    protected List<String> includes;
    @Nullable
    protected List<String> excludes;
    @Nullable
    protected Boolean writeBOM = Boolean.FALSE;

    public String getCommentTag() {
        return this.commentTag;
    }

    public void setCommentTag(String commentTag) {
        this.commentTag = commentTag;
    }

    public File getLanguageFilesFolder() {
        return this.languageFilesFolder;
    }

    public String getCrowdinPath() {
        return this.crowdinPath;
    }

    public String getBaseFileName() {
        return this.baseFileName;
    }

    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public String getExportPattern() {
        return this.exportPattern;
    }

    @Nullable
    public String getTargetFileName() {
        return this.targetFileName;
    }

    @Nullable
    public Integer getEscapeQuotes() {
        return this.escapeQuotes;
    }

    @Nullable
    public FileExportOptions.JavaScriptExportQuotes getExportQuotes() {
        return this.exportQuotes;
    }

    @Nullable
    public Integer getEscapeSpecialCharacters() {
        return this.escapeSpecialCharacters;
    }

    public UpdateOption getUpdateOption() {
        return this.updateOption;
    }

    @Nullable
    public Boolean getReplaceModifiedContext() {
        return this.replaceModifiedContext;
    }

    @Nullable
    public List<String> getIncludes() {
        return this.includes;
    }

    @Nullable
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Nullable
    public Boolean getWriteBOM() {
        return this.writeBOM;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": \"" + this.title + "\"";
    }

    @Override
    protected void initializeInstance() throws MojoExecutionException {
        if (this.baseFileName != null) {
            this.baseFileName = FileUtil.formatPath(this.baseFileName, false);
        }
        if (StringUtil.isBlank(this.title)) {
            this.title = this.baseFileName;
        }
        if (StringUtil.isBlank(this.baseFileName)) {
            if (StringUtil.isBlank(this.title)) {
                throw new MojoExecutionException("\"baseFileName\" isn't defined for translation fileset");
            }
            throw new MojoExecutionException("\"baseFileName\" isn't defined for translation fileset \"" + this.title + "\"");
        }
        if (this.languageFilesFolder == null) {
            throw new MojoExecutionException("\"languageFilesFolder\" isn't defined for translation fileset \"" + this.title + "\"");
        }
        if (!this.languageFilesFolder.isDirectory()) {
            throw new MojoExecutionException("The specified folder \"" + this.languageFilesFolder.getAbsolutePath() + "\" for translation fileset \"" + this.title + "\" either doesn't exist or isn't a folder");
        }
        if (this.crowdinPath != null) {
            this.crowdinPath = FileUtil.formatPath(this.crowdinPath, false);
        }
        if (this.type == null) {
            String extension = FileUtil.getExtension(this.baseFileName, null, null);
            if (extension != null) {
                for (FileType fileType : FileType.values()) {
                    if (!fileType.hasExtension(extension)) continue;
                    this.type = fileType;
                    break;
                }
            }
            if (this.type == null) {
                this.type = FileType.auto;
            }
        }
        if (this.updateOption == null) {
            this.updateOption = UpdateOption.clear_translations_and_approvals;
        }
        if (this.addComment == null) {
            this.addComment = this.type == FileType.adoc || this.type == FileType.android || this.type == FileType.coffee || this.type == FileType.dita || this.type == FileType.fm_html || this.type == FileType.gettext || this.type == FileType.html || this.type == FileType.ini || this.type == FileType.js || this.type == FileType.nsh || this.type == FileType.php || this.type == FileType.properties || this.type == FileType.properties_play || this.type == FileType.properties_xml || this.type == FileType.resw || this.type == FileType.resx || this.type == FileType.toml || this.type == FileType.ts || this.type == FileType.webxml || this.type == FileType.xaml || this.type == FileType.xliff || this.type == FileType.xliff_two || this.type == FileType.xml || this.type == FileType.yaml;
        }
        switch (this.type) {
            case properties: 
            case properties_play: {
                if (StringUtil.isBlank(this.encoding)) {
                    this.charset = StandardCharsets.ISO_8859_1;
                    this.encoding = this.charset.name();
                } else {
                    this.charset = Charset.forName(this.encoding);
                }
                if (this.escapeQuotes == null) {
                    this.escapeQuotes = 0;
                }
                if (this.escapeSpecialCharacters == null) {
                    this.escapeSpecialCharacters = 0;
                }
                if (this.sortLines == null) {
                    this.sortLines = Boolean.TRUE;
                }
                if (this.escapeUnicode != null) break;
                this.escapeUnicode = Boolean.TRUE;
                break;
            }
            case xml: {
                this.charset = StandardCharsets.UTF_8;
                this.encoding = this.charset.name();
                break;
            }
            case android: 
            case auto: 
            case chrome: 
            case csv: 
            case dklang: 
            case docx: 
            case dtd: 
            case flex: 
            case flsnp: 
            case fm_html: 
            case fm_md: 
            case gettext: 
            case haml: 
            case html: 
            case ini: 
            case joomla: 
            case js: {
                if (this.exportQuotes != null) break;
                this.exportQuotes = FileExportOptions.JavaScriptExportQuotes.SINGLE;
                break;
            }
            default: {
                if (StringUtil.isNotBlank(this.encoding)) {
                    this.charset = Charset.forName(this.encoding);
                    break;
                }
                this.charset = StandardCharsets.UTF_8;
                this.encoding = this.charset.name();
            }
        }
        if (StringUtil.isBlank(this.exportPattern)) {
            throw new MojoExecutionException("\"exportPattern\" isn't defined for translation fileset \"" + this.title + "\"");
        }
        if (this.escapeQuotes != null && this.type != FileType.properties && this.type != FileType.properties_play) {
            throw new MojoExecutionException("Invalid configuration in fileset \"" + this.title + "\": \"escapeQuotes\" " + "is only valid for .properties files");
        }
        if (this.escapeQuotes != null && (this.escapeQuotes < 0 || this.escapeQuotes > 3)) {
            throw new MojoExecutionException("Invalid \"escapeQuotes\" value " + this.escapeQuotes + " for translation fileset \"" + this.title + "\"");
        }
        if (this.escapeSpecialCharacters != null && this.type != FileType.properties && this.type != FileType.properties_play) {
            throw new MojoExecutionException("Invalid configuration in fileset \"" + this.title + "\": \"escapeSpecialCharacters\" " + "is only valid for .properties files");
        }
        if (this.escapeSpecialCharacters != null && (this.escapeSpecialCharacters < 0 || this.escapeSpecialCharacters > 1)) {
            throw new MojoExecutionException("Invalid \"escapeSpecialCharacters\" value " + this.escapeSpecialCharacters + " for translation fileset \"" + this.title + "\"");
        }
        if (this.exportQuotes != null && this.type != FileType.js) {
            throw new MojoExecutionException("Invalid configuration in fileset \"" + this.title + "\": \"exportQuotes\" is only valid for JavaScript files");
        }
        if (this.targetFileName != null) {
            this.targetFileName = FileUtil.formatPath(this.targetFileName, false);
        }
        super.initializeInstance();
    }
}

