/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.tool;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.digitalmediaserver.crowdin.configuration.TranslationFileSet;
import org.digitalmediaserver.crowdin.tool.StringUtil;

public class FileUtil {
    private FileUtil() {
    }

    @Nonnull
    public static List<String> splitPath(@Nullable String path, boolean omitFilename) {
        if (path == null || path.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        int len = path.length();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            char c = path.charAt(i);
            if (c == '/' || c == '\\') {
                if (match) {
                    result.add(path.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (!omitFilename && match) {
            result.add(path.substring(start, i));
        }
        return result;
    }

    @Nullable
    public static String getExtension(@Nullable String fileName, @Nullable LetterCase convertTo, @Nullable Locale locale) {
        if (StringUtil.isBlank(fileName)) {
            return null;
        }
        int point = FileUtil.getExtensionIndex(fileName);
        if (point == -1) {
            return null;
        }
        if (convertTo != null && locale == null) {
            locale = Locale.ROOT;
        }
        String extension = fileName.substring(point + 1);
        if (convertTo == LetterCase.UPPER) {
            return extension.toUpperCase(locale);
        }
        if (convertTo == LetterCase.LOWER) {
            return extension.toLowerCase(locale);
        }
        return extension;
    }

    public static int getExtensionIndex(@Nullable String filePath) {
        if (filePath == null || filePath.length() < 2) {
            return -1;
        }
        char[] filePathArray = filePath.toCharArray();
        for (int i = filePathArray.length - 1; i >= 0; --i) {
            switch (filePathArray[i]) {
                case '.': {
                    return i == filePathArray.length - 1 ? -1 : i;
                }
                case '/': 
                case '\\': {
                    return -1;
                }
            }
        }
        return -1;
    }

    @Nullable
    public static String appendPathSeparator(@Nullable String path) {
        if (StringUtil.isBlank(path)) {
            return path;
        }
        int len = path.length();
        char c = path.charAt(len - 1);
        if (c == '/' || c == '\\') {
            return path;
        }
        boolean found = false;
        for (int i = len - 2; i >= 0; --i) {
            char c2 = path.charAt(i);
            c = c2;
            if (c2 != '/' && c != 92) continue;
            found = true;
            break;
        }
        if (!found) {
            c = '/';
        }
        return path + c;
    }

    @Nullable
    public static String formatPath(@Nullable Path path, boolean appendSeparator) {
        return path == null ? null : FileUtil.formatPath(path.toString(), appendSeparator);
    }

    @Nullable
    public static String formatPath(@Nullable String path, boolean appendSeparator) {
        if (path == null) {
            return null;
        }
        path = path.replace('\\', '/');
        return appendSeparator ? FileUtil.appendPathSeparator(path) : path;
    }

    @Nonnull
    public static String getPushFolder(@Nonnull TranslationFileSet fileSet, boolean includeCrowdinPath) {
        String baseFileName;
        String crowdinPath;
        ArrayList<String> folders = new ArrayList<String>();
        if (includeCrowdinPath && StringUtil.isNotBlank(crowdinPath = fileSet.getCrowdinPath())) {
            folders.addAll(FileUtil.splitPath(crowdinPath, false));
        }
        if (StringUtil.isNotBlank(baseFileName = fileSet.getBaseFileName())) {
            folders.addAll(FileUtil.splitPath(baseFileName, true));
        }
        StringBuilder sb = new StringBuilder();
        for (String folder : folders) {
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append(folder);
        }
        if (!folders.isEmpty()) {
            sb.append('/');
        }
        return sb.toString();
    }

    public static enum LetterCase {
        UPPER,
        LOWER;

    }
}

