/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;

public class GitUtil {
    private GitUtil() {
    }

    @Nullable
    public static String getBranch(@Nonnull Path gitBaseFolder, Log logger) throws MojoExecutionException {
        if (!Files.exists(gitBaseFolder, new LinkOption[0])) {
            if (logger != null) {
                logger.warn((CharSequence)("Git base folder (" + gitBaseFolder.toString() + ") doesn't exist - cannot determine git branch"));
            }
            return null;
        }
        if (!Files.isDirectory(gitBaseFolder, new LinkOption[0])) {
            if (logger != null) {
                logger.warn((CharSequence)("Git base folder (" + gitBaseFolder.toString() + ") must be a folder - cannot determine git branch"));
            }
            return null;
        }
        try {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug((CharSequence)("Trying to read \"" + gitBaseFolder.toString() + "\" with Git"));
            }
            Git git = Git.open((File)gitBaseFolder.toFile());
            Repository repo = git.getRepository();
            try {
                String branch = repo.getBranch();
                if (repo.getRef("HEAD").getTarget().getName().endsWith(branch)) {
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug((CharSequence)("Git branch determined to be \"" + branch + "\""));
                    }
                    return branch;
                }
                if (logger != null) {
                    logger.error((CharSequence)("Git branch was reported to be \"" + branch + "\" which means that HEAD is detached"));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while reading Git branch: " + e.getMessage(), (Exception)e);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred when opening Git base folder: " + e.getMessage(), (Exception)e);
        }
        if (logger != null) {
            logger.error((CharSequence)"Can't determine Git branch");
        }
        return null;
    }
}

