/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.tool;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.digitalmediaserver.crowdin.tool.Constants;
import org.digitalmediaserver.crowdin.tool.StringUtil;

public enum ISO639 {
    ABKHAZIAN("Abkhazian", LanguageType.NORMAL, "ab", "abk"),
    ACHINESE("Achinese", LanguageType.NORMAL, null, "ace"),
    ACOLI("Acoli", LanguageType.NORMAL, null, "ach"),
    ADANGME("Adangme", LanguageType.NORMAL, null, "ada"),
    ADYGHE("Adyghe;Adygei", LanguageType.NORMAL, null, "ady"),
    AFAR("Afar", LanguageType.NORMAL, "aa", "aar"),
    AFRIHILI("Afrihili", LanguageType.NORMAL, null, "afh"),
    AFRIKAANS("Afrikaans", LanguageType.NORMAL, "af", "afr"),
    AFRO_ASIATIC_LANGUAGES("Afro-Asiatic languages", LanguageType.GROUP, null, "afa"),
    AINU("Ainu;Ainu (Japan)", LanguageType.NORMAL, null, "ain"),
    AKAN("Akan", LanguageType.NORMAL, "ak", "aka"),
    AKKADIAN("Akkadian", LanguageType.NORMAL, null, "akk"),
    ALBANIAN("Albanian", LanguageType.NORMAL, "sq", "alb", "sqi"),
    ALEMANNIC("Alemannic;Alsatian;Swiss German", LanguageType.NORMAL, null, "gsw"),
    ALEUT("Aleut", LanguageType.NORMAL, null, "ale"),
    ALGONQUIAN("Algonquian;Algonquian languages", LanguageType.GROUP, null, "alg"),
    ALTAIC("Altaic;Altaic languages", LanguageType.GROUP, null, "tut"),
    AMHARIC("Amharic", LanguageType.NORMAL, "am", "amh"),
    ANCIENT_GREEK("Ancient Greek (to 1453)", LanguageType.HISTORICAL, null, "grc"),
    ANGIKA("Angika", LanguageType.NORMAL, null, "anp"),
    APACHE("Apache;Apache languages", LanguageType.GROUP, null, "apa"),
    ARABIC("Arabic", LanguageType.NORMAL, "ar", "ara"),
    ARAGONESE("Aragonese", LanguageType.NORMAL, "an", "arg"),
    ARAPAHO("Arapaho", LanguageType.NORMAL, null, "arp"),
    ARAWAK("Arawak", LanguageType.NORMAL, null, "arw"),
    ARMENIAN("Armenian", LanguageType.NORMAL, "hy", "arm", "hye"),
    AROMANIAN("Aromanian;Arumanian;Macedo-Romanian", LanguageType.NORMAL, null, "rup"),
    ARTIFICIAL("Artificial languages", LanguageType.GROUP, null, "art"),
    ASSAMESE("Assamese", LanguageType.NORMAL, "as", "asm"),
    ASTURIAN("Asturian;Asturleonese;Bable;Leonese", LanguageType.NORMAL, null, "ast"),
    ATHAPASCAN("Athapascan;Athapascan languages", LanguageType.GROUP, null, "ath"),
    AUSTRALIAN("Australian;Australian languages", LanguageType.GROUP, null, "aus"),
    AUSTRONESIAN("Austronesian;Austronesian languages", LanguageType.GROUP, null, "map"),
    AVARIC("Avaric", LanguageType.NORMAL, "av", "ava"),
    AVESTAN("Avestan", LanguageType.NORMAL, "ae", "ave"),
    AWADHI("Awadhi", LanguageType.NORMAL, null, "awa"),
    AYMARA("Aymara", LanguageType.NORMAL, "ay", "aym"),
    AZERBAIJANI("Azerbaijani", LanguageType.NORMAL, "az", "aze"),
    BALINESE("Balinese", LanguageType.NORMAL, null, "ban"),
    BALTIC("Baltic;Baltic languages", LanguageType.GROUP, null, "bat"),
    BALUCHI("Baluchi", LanguageType.NORMAL, null, "bal"),
    BAMBARA("Bambara", LanguageType.NORMAL, "bm", "bam"),
    BAMILEKE("Bamileke;Bamileke languages", LanguageType.GROUP, null, "bai"),
    BANDA("Banda;Banda languages", LanguageType.GROUP, null, "bad"),
    BANTU("Bantu;Bantu languages", LanguageType.GROUP, null, "bnt"),
    BASA("Basa (Cameroon)", LanguageType.NORMAL, null, "bas"),
    BASHKIR("Bashkir", LanguageType.NORMAL, "ba", "bak"),
    BASQUE("Basque", LanguageType.NORMAL, "eu", "baq", "eus"),
    BATAK("Batak;Batak languages", LanguageType.GROUP, null, "btk"),
    BEJA("Bedawiyet;Beja", LanguageType.NORMAL, null, "bej"),
    BELARUSIAN("Belarusian", LanguageType.NORMAL, "be", "bel"),
    BEMBA("Bemba (Zambia)", LanguageType.NORMAL, null, "bem"),
    BENGALI("Bengali", LanguageType.NORMAL, "bn", "ben"),
    BERBER("Berber;Berber languages", LanguageType.GROUP, null, "ber"),
    BHOJPURI("Bhojpuri", LanguageType.NORMAL, null, "bho"),
    BIHARI("Bihari;Bihari languages", LanguageType.GROUP, "bh", "bih"),
    BIKOL("Bikol", LanguageType.NORMAL, null, "bik"),
    BILEN("Bilen;Bilin;Blin", LanguageType.NORMAL, null, "byn"),
    EDO("Bini;Edo", LanguageType.NORMAL, null, "bin"),
    BISLAMA("Bislama", LanguageType.NORMAL, "bi", "bis"),
    BLISS("Bliss;Blissymbolics;Blissymbols", LanguageType.NORMAL, null, "zbl"),
    BOSNIAN("Bosnian", LanguageType.NORMAL, "bs", "bos"),
    BRAJ("Braj", LanguageType.NORMAL, null, "bra"),
    BRETON("Breton", LanguageType.NORMAL, "br", "bre"),
    BUGINESE("Buginese", LanguageType.NORMAL, null, "bug"),
    BULGARIAN("Bulgarian", LanguageType.NORMAL, "bg", "bul"),
    BURIAT("Buriat", LanguageType.NORMAL, null, "bua"),
    BURMESE("Burmese", LanguageType.NORMAL, "my", "bur", "mya"),
    CADDO("Caddo", LanguageType.NORMAL, null, "cad"),
    SPANISH("Castilian;Spanish", LanguageType.NORMAL, "es", "spa"),
    CATALAN("Catalan;Valencian", LanguageType.NORMAL, "ca", "cat"),
    CAUCASIAN("Caucasian;Caucasian languages", LanguageType.GROUP, null, "cau"),
    CEBUANO("Cebuano", LanguageType.NORMAL, null, "ceb"),
    CELTIC("Celtic;Celtic languages", LanguageType.GROUP, null, "cel"),
    CENTRAL_AMERICAN_INDIAN_LANGUAGES("Central American Indian languages", LanguageType.GROUP, null, "cai"),
    KHMER("Central Khmer;Khmer", LanguageType.NORMAL, "km", "khm"),
    CHAGATAI("Chagatai", LanguageType.NORMAL, null, "chg"),
    CHAMIC("Chamic;Chamic languages", LanguageType.GROUP, null, "cmc"),
    CHAMORRO("Chamorro", LanguageType.NORMAL, "ch", "cha"),
    CHECHEN("Chechen", LanguageType.NORMAL, "ce", "che"),
    CHEROKEE("Cherokee", LanguageType.NORMAL, null, "chr"),
    CHEWA("Chewa;Chichewa;Nyanja", LanguageType.NORMAL, "ny", "nya"),
    CHEYENNE("Cheyenne", LanguageType.NORMAL, null, "chy"),
    CHIBCHA("Chibcha", LanguageType.NORMAL, null, "chb"),
    CHINESE("Chinese", LanguageType.NORMAL, "zh", "chi", "zho"),
    CHINOOK("Chinook jargon", LanguageType.NORMAL, null, "chn"),
    CHIPEWYAN("Chipewyan;Dene Suline", LanguageType.NORMAL, null, "chp"),
    CHOCTAW("Choctaw", LanguageType.NORMAL, null, "cho"),
    ZHUANG("Chuang;Zhuang", LanguageType.NORMAL, "za", "zha"),
    CHURCH_SLAVIC("Church Slavic;Church Slavonic;Old Bulgarian;Old Church Slavonic;Old Slavonic", LanguageType.HISTORICAL, "cu", "chu"),
    CHUUKESE("Chuukese", LanguageType.NORMAL, null, "chk"),
    CHUVASH("Chuvash", LanguageType.NORMAL, "cv", "chv"),
    CLASSICAL_NEWAR("Classical Nepal Bhasa;Classical Newari;Classical Newar;Old Newari", LanguageType.HISTORICAL, null, "nwc"),
    CLASSICAL_SYRIAC("Classical Syriac", LanguageType.HISTORICAL, null, "syc"),
    COOK_ISLANDS_MAORI("Cook Islands Maori;Rarotongan", LanguageType.NORMAL, null, "rar"),
    COPTIC("Coptic", LanguageType.NORMAL, null, "cop"),
    CORNISH("Cornish", LanguageType.NORMAL, "kw", "cor"),
    CORSICAN("Corsican", LanguageType.NORMAL, "co", "cos"),
    CREE("Cree", LanguageType.NORMAL, "cr", "cre"),
    CREEK("Creek", LanguageType.NORMAL, null, "mus"),
    CREOLES_AND_PIDGINS("Creoles and pidgins", LanguageType.GROUP, null, "crp"),
    ENGLISH_BASED_CREOLES_AND_PIDGINS("English based Creoles and pidgins", LanguageType.GROUP, null, "cpe"),
    FRENCH_BASED_CREOLES_AND_PIDGINS("French-based Creoles and pidgins", LanguageType.GROUP, null, "cpf"),
    PORTUGUESE_BASED_CREOLES_AND_PIDGINS("Portuguese-based Creoles and pidgins", LanguageType.GROUP, null, "cpp"),
    CRIMEAN_TATAR("Crimean Tatar;Crimean Turkish", LanguageType.NORMAL, null, "crh"),
    CROATIAN("Croatian", LanguageType.NORMAL, "hr", "hrv"),
    CUSHITIC("Cushitic;Cushitic languages", LanguageType.GROUP, null, "cus"),
    CZECH("Czech", LanguageType.NORMAL, "cs", "cze", "ces"),
    DAKOTA("Dakota", LanguageType.NORMAL, null, "dak"),
    DANISH("Danish", LanguageType.NORMAL, "da", "dan"),
    DARGWA("Dargwa", LanguageType.NORMAL, null, "dar"),
    DELAWARE("Delaware", LanguageType.NORMAL, null, "del"),
    MALDIVIAN("Dhivehi;Divehi;Maldivian", LanguageType.NORMAL, "dv", "div"),
    DHOLUO("Dholuo;Luo (Kenya and Tanzania)", LanguageType.NORMAL, null, "luo"),
    ZAZA("Dimili;Dimli (macrolanguage);Kirdki;Kirmanjki (macrolanguage);Zaza;Zazaki", LanguageType.NORMAL, null, "zza"),
    DINKA("Dinka", LanguageType.NORMAL, null, "din"),
    DOGRI("Dogri (macrolanguage)", LanguageType.NORMAL, null, "doi"),
    DOGRIB("Dogrib", LanguageType.NORMAL, null, "dgr"),
    DRAVIDIAN("Dravidian;Dravidian languages", LanguageType.GROUP, null, "dra"),
    DUALA("Duala", LanguageType.NORMAL, null, "dua"),
    DUTCH("Dutch;Flemish", LanguageType.NORMAL, "nl", "dut", "nld"),
    DYULA("Dyula", LanguageType.NORMAL, null, "dyu"),
    DZONGKHA("Dzongkha", LanguageType.NORMAL, "dz", "dzo"),
    EASTERN_FRISIAN("Eastern Frisian", LanguageType.NORMAL, null, "frs"),
    EFIK("Efik", LanguageType.NORMAL, null, "efi"),
    EGYPTIAN("Egyptian (Ancient)", LanguageType.HISTORICAL, null, "egy"),
    EKAJUK("Ekajuk", LanguageType.NORMAL, null, "eka"),
    ELAMITE("Elamite", LanguageType.NORMAL, null, "elx"),
    ENGLISH("English", LanguageType.NORMAL, "en", "eng"),
    ERZYA("Erzya", LanguageType.NORMAL, null, "myv"),
    ESPERANTO("Esperanto", LanguageType.NORMAL, "eo", "epo"),
    ESTONIAN("Estonian", LanguageType.NORMAL, "et", "est"),
    EWE("Ewe", LanguageType.NORMAL, "ee", "ewe"),
    EWONDO("Ewondo", LanguageType.NORMAL, null, "ewo"),
    FANG("Fang (Equatorial Guinea)", LanguageType.NORMAL, null, "fan"),
    FANTI("Fanti", LanguageType.NORMAL, null, "fat"),
    FAROESE("Faroese", LanguageType.NORMAL, "fo", "fao"),
    FIJIAN("Fijian", LanguageType.NORMAL, "fj", "fij"),
    FILIPINO("Filipino;Pilipino", LanguageType.NORMAL, null, "fil"),
    FINNISH("Finnish", LanguageType.NORMAL, "fi", "fin"),
    FINNO_UGRIAN_LANGUAGES("Finno-Ugrian languages", LanguageType.GROUP, null, "fiu"),
    FON("Fon", LanguageType.NORMAL, null, "fon"),
    FRENCH("French", LanguageType.NORMAL, "fr", "fre", "fra"),
    FRIULIAN("Friulian", LanguageType.NORMAL, null, "fur"),
    FULAH("Fulah", LanguageType.NORMAL, "ff", "ful"),
    GA("Ga", LanguageType.NORMAL, null, "gaa"),
    GAELIC("Gaelic;Scottish Gaelic", LanguageType.NORMAL, "gd", "gla"),
    CARIB("Galibi Carib", LanguageType.NORMAL, null, "car"),
    GALICIAN("Galician", LanguageType.NORMAL, "gl", "glg"),
    GANDA("Ganda", LanguageType.NORMAL, "lg", "lug"),
    GAYO("Gayo", LanguageType.NORMAL, null, "gay"),
    GBAYA("Gbaya (Central African Republic)", LanguageType.NORMAL, null, "gba"),
    GEEZ("Geez", LanguageType.NORMAL, null, "gez"),
    GEORGIAN("Georgian", LanguageType.NORMAL, "ka", "geo", "kat"),
    GERMAN("German", LanguageType.NORMAL, "de", "ger", "deu"),
    GERMANIC("Germanic;Germanic languages", LanguageType.GROUP, null, "gem"),
    KIKUYU("Gikuyu;Kikuyu", LanguageType.NORMAL, "ki", "kik"),
    GILBERTESE("Gilbertese", LanguageType.NORMAL, null, "gil"),
    GONDI("Gondi", LanguageType.NORMAL, null, "gon"),
    GORONTALO("Gorontalo", LanguageType.NORMAL, null, "gor"),
    GOTHIC("Gothic", LanguageType.NORMAL, null, "got"),
    GREBO("Grebo", LanguageType.NORMAL, null, "grb"),
    GREEK("Greek;Modern Greek (1453-)", LanguageType.NORMAL, "el", "gre", "ell"),
    GREENLANDIC("Greenlandic;Kalaallisut", LanguageType.NORMAL, "kl", "kal"),
    GUARANI("Guarani", LanguageType.NORMAL, "gn", "grn"),
    GUJARATI("Gujarati", LanguageType.NORMAL, "gu", "guj"),
    GWICH_IN("Gwich\u02bcin", LanguageType.NORMAL, null, "gwi"),
    HAIDA("Haida", LanguageType.NORMAL, null, "hai"),
    HAITIAN("Haitian;Haitian Creole", LanguageType.NORMAL, "ht", "hat"),
    HAUSA("Hausa", LanguageType.NORMAL, "ha", "hau"),
    HAWAIIAN("Hawaiian", LanguageType.NORMAL, null, "haw"),
    HEBREW("Hebrew", LanguageType.HISTORICAL, "he", "heb"),
    HERERO("Herero", LanguageType.NORMAL, "hz", "her"),
    HILIGAYNON("Hiligaynon", LanguageType.NORMAL, null, "hil"),
    WESTERN_PAHARI("Himachali languages;Western Pahari languages", LanguageType.GROUP, null, "him"),
    HINDI("Hindi", LanguageType.NORMAL, "hi", "hin"),
    HIRI_MOTU("Hiri Motu", LanguageType.NORMAL, "ho", "hmo"),
    HITTITE("Hittite", LanguageType.NORMAL, null, "hit"),
    HMONG("Hmong;Mong", LanguageType.NORMAL, null, "hmn"),
    HUNGARIAN("Hungarian", LanguageType.NORMAL, "hu", "hun"),
    HUPA("Hupa", LanguageType.NORMAL, null, "hup"),
    IBAN("Iban", LanguageType.NORMAL, null, "iba"),
    ICELANDIC("Icelandic", LanguageType.NORMAL, "is", "ice", "isl"),
    IDO("Ido", LanguageType.NORMAL, "io", "ido"),
    IGBO("Igbo", LanguageType.NORMAL, "ig", "ibo"),
    IJO("Ijo;Ijo languages", LanguageType.GROUP, null, "ijo"),
    ILOKO("Iloko", LanguageType.NORMAL, null, "ilo"),
    IMPERIAL_ARAMAIC("Imperial Aramaic (700-300 BCE);Official Aramaic (700-300 BCE)", LanguageType.HISTORICAL, null, "arc"),
    INARI_SAMI("Inari Sami", LanguageType.NORMAL, null, "smn"),
    INDIC("Indic;Indic languages", LanguageType.GROUP, null, "inc"),
    INDO_EUROPEAN_LANGUAGES("Indo-European languages", LanguageType.GROUP, null, "ine"),
    INDONESIAN("Indonesian", LanguageType.NORMAL, "id", "ind"),
    INGUSH("Ingush", LanguageType.NORMAL, null, "inh"),
    INTERLINGUA("Interlingua (International Auxiliary Language Association)", LanguageType.NORMAL, "ia", "ina"),
    INTERLINGUE("Interlingue;Occidental", LanguageType.NORMAL, "ie", "ile"),
    INUKTITUT("Inuktitut", LanguageType.NORMAL, "iu", "iku"),
    INUPIAQ("Inupiaq", LanguageType.NORMAL, "ik", "ipk"),
    IRANIAN("Iranian;Iranian languages", LanguageType.GROUP, null, "ira"),
    IRISH("Irish", LanguageType.NORMAL, "ga", "gle"),
    IROQUOIAN("Iroquoian;Iroquoian languages", LanguageType.GROUP, null, "iro"),
    ITALIAN("Italian", LanguageType.NORMAL, "it", "ita"),
    JAPANESE("Japanese", LanguageType.NORMAL, "ja", "jpn"),
    JAVANESE("Javanese", LanguageType.NORMAL, "jv", "jav"),
    JINGPHO("Jingpho;Kachin", LanguageType.NORMAL, null, "kac"),
    JUDEO_ARABIC("Judeo-Arabic", LanguageType.NORMAL, null, "jrb"),
    JUDEO_PERSIAN("Judeo-Persian", LanguageType.NORMAL, null, "jpr"),
    KABARDIAN("Kabardian", LanguageType.NORMAL, null, "kbd"),
    KABYLE("Kabyle", LanguageType.NORMAL, null, "kab"),
    KALMYK_OIRAT("Kalmyk;Oirat;Kalmyk Oirat", LanguageType.NORMAL, null, "xal"),
    KAMBA("Kamba (Kenya)", LanguageType.NORMAL, null, "kam"),
    KANNADA("Kannada", LanguageType.NORMAL, "kn", "kan"),
    KANURI("Kanuri", LanguageType.NORMAL, "kr", "kau"),
    KAPAMPANGAN("Kapampangan;Pampanga", LanguageType.NORMAL, null, "pam"),
    KARACHAY_BALKAR("Karachay-Balkar", LanguageType.NORMAL, null, "krc"),
    KARA_KALPAK("Kara-Kalpak", LanguageType.NORMAL, null, "kaa"),
    KARELIAN("Karelian", LanguageType.NORMAL, null, "krl"),
    KAREN("Karen;Karen languages", LanguageType.GROUP, null, "kar"),
    KASHMIRI("Kashmiri", LanguageType.NORMAL, "ks", "kas"),
    KASHUBIAN("Kashubian", LanguageType.NORMAL, null, "csb"),
    KAWI("Kawi", LanguageType.NORMAL, null, "kaw"),
    KAZAKH("Kazakh", LanguageType.NORMAL, "kk", "kaz"),
    KHASI("Khasi", LanguageType.NORMAL, null, "kha"),
    KHOISAN("Khoisan;Khoisan languages", LanguageType.GROUP, null, "khi"),
    SAKA("Saka;Khotanese;Sakan", LanguageType.NORMAL, null, "kho"),
    KIMBUNDU("Kimbundu", LanguageType.NORMAL, null, "kmb"),
    KINYARWANDA("Kinyarwanda", LanguageType.NORMAL, "rw", "kin"),
    KYRGYZ("Kirghiz;Kyrgyz", LanguageType.NORMAL, "ky", "kir"),
    KLINGON("Klingon;tlhIngan Hol", LanguageType.NORMAL, null, "tlh"),
    KOMI("Komi", LanguageType.NORMAL, "kv", "kom"),
    KONGO("Kongo", LanguageType.NORMAL, "kg", "kon"),
    KONKANI("Konkani (macrolanguage)", LanguageType.NORMAL, null, "kok"),
    KOREAN("Korean", LanguageType.NORMAL, "ko", "kor"),
    KOSRAEAN("Kosraean", LanguageType.NORMAL, null, "kos"),
    KPELLE("Kpelle", LanguageType.NORMAL, null, "kpe"),
    KRU("Kru;Kru languages", LanguageType.GROUP, null, "kro"),
    KWANYAMA("Kuanyama;Kwanyama", LanguageType.NORMAL, "kj", "kua"),
    KUMYK("Kumyk", LanguageType.NORMAL, null, "kum"),
    KURDISH("Kurdish", LanguageType.NORMAL, "ku", "kur"),
    KURUKH("Kurukh", LanguageType.NORMAL, null, "kru"),
    KUTENAI("Kutenai", LanguageType.NORMAL, null, "kut"),
    LADINO("Ladino", LanguageType.NORMAL, null, "lad"),
    LAHNDA("Lahnda", LanguageType.NORMAL, null, "lah"),
    LAMBA("Lamba", LanguageType.NORMAL, null, "lam"),
    LAND_DAYAK("Land Dayak languages", LanguageType.GROUP, null, "day"),
    LAO("Lao", LanguageType.NORMAL, "lo", "lao"),
    LATIN("Latin", LanguageType.NORMAL, "la", "lat"),
    LATVIAN("Latvian", LanguageType.NORMAL, "lv", "lav"),
    LUXEMBOURGISH("Letzeburgesch;Luxembourgish", LanguageType.NORMAL, "lb", "ltz"),
    LEZGHIAN("Lezghian", LanguageType.NORMAL, null, "lez"),
    LIMBURGISH("Limburgan;Limburger;Limburgish", LanguageType.NORMAL, "li", "lim"),
    LINGALA("Lingala", LanguageType.NORMAL, "ln", "lin"),
    LITHUANIAN("Lithuanian", LanguageType.NORMAL, "lt", "lit"),
    LOJBAN("Lojban", LanguageType.NORMAL, null, "jbo"),
    LOW_GERMAN("Low German;Low Saxon", LanguageType.NORMAL, null, "nds"),
    LOWER_SORBIAN("Lower Sorbian", LanguageType.NORMAL, null, "dsb"),
    LOZI("Lozi", LanguageType.NORMAL, null, "loz"),
    LUBA_KATANGA("Luba-Katanga", LanguageType.NORMAL, "lu", "lub"),
    LUBA_LULUA("Luba-Lulua", LanguageType.NORMAL, null, "lua"),
    LUISENO("Luiseno", LanguageType.NORMAL, null, "lui"),
    LULE_SAMI("Lule Sami", LanguageType.NORMAL, null, "smj"),
    LUNDA("Lunda", LanguageType.NORMAL, null, "lun"),
    LUSHAI("Lushai", LanguageType.NORMAL, null, "lus"),
    MACEDONIAN("Macedonian", LanguageType.NORMAL, "mk", "mac", "mkd"),
    MADURESE("Madurese", LanguageType.NORMAL, null, "mad"),
    MAGAHI("Magahi", LanguageType.NORMAL, null, "mag"),
    MAITHILI("Maithili", LanguageType.NORMAL, null, "mai"),
    MAKASAR("Makasar", LanguageType.NORMAL, null, "mak"),
    MALAGASY("Malagasy", LanguageType.NORMAL, "mg", "mlg"),
    MALAY("Malay (macrolanguage)", LanguageType.NORMAL, "ms", "may", "msa"),
    MALAYALAM("Malayalam", LanguageType.NORMAL, "ml", "mal"),
    MALTESE("Maltese", LanguageType.NORMAL, "mt", "mlt"),
    MANCHU("Manchu", LanguageType.NORMAL, null, "mnc"),
    MANDAR("Mandar", LanguageType.NORMAL, null, "mdr"),
    MANDING("Manding;Mandingo", LanguageType.NORMAL, null, "man"),
    MANIPURI("Manipuri", LanguageType.NORMAL, null, "mni"),
    MANOBO("Manobo;Manobo languages", LanguageType.GROUP, null, "mno"),
    MANX("Manx", LanguageType.NORMAL, "gv", "glv"),
    MAORI("Maori", LanguageType.NORMAL, "mi", "mao", "mri"),
    MAPUCHE("Mapuche;Mapudungun", LanguageType.NORMAL, null, "arn"),
    MARATHI("Marathi", LanguageType.NORMAL, "mr", "mar"),
    MARI("Mari (Russia)", LanguageType.NORMAL, null, "chm"),
    MARSHALLESE("Marshallese", LanguageType.NORMAL, "mh", "mah"),
    MARWARI("Marwari", LanguageType.NORMAL, null, "mwr"),
    MASAI("Masai", LanguageType.NORMAL, null, "mas"),
    MAYAN("Mayan;Mayan languages", LanguageType.GROUP, null, "myn"),
    MENDE("Mende (Sierra Leone)", LanguageType.NORMAL, null, "men"),
    MIGMAW("Micmac;Mi'kmaq", LanguageType.NORMAL, null, "mic"),
    MIDDLE_DUTCH("Middle Dutch (ca. 1050-1350)", LanguageType.HISTORICAL, null, "dum"),
    MIDDLE_ENGLISH("Middle English (1100-1500)", LanguageType.HISTORICAL, null, "enm"),
    MIDDLE_FRENCH("Middle French (ca. 1400-1600)", LanguageType.HISTORICAL, null, "frm"),
    MIDDLE_HIGH_GERMAN("Middle High German (ca. 1050-1500)", LanguageType.HISTORICAL, null, "gmh"),
    MIDDLE_IRISH("Middle Irish (900-1200)", LanguageType.HISTORICAL, null, "mga"),
    MINANGKABAU("Minangkabau", LanguageType.NORMAL, null, "min"),
    MIRANDESE("Mirandese", LanguageType.NORMAL, null, "mwl"),
    MOHAWK("Mohawk", LanguageType.NORMAL, null, "moh"),
    MOKSHA("Moksha", LanguageType.NORMAL, null, "mdf"),
    MOLDOVAN("Romanian;Moldavian;Moldovan", LanguageType.NORMAL, "ro", "rum", "ron"),
    MONGO("Mongo", LanguageType.NORMAL, null, "lol"),
    MONGOLIAN("Mongolian", LanguageType.NORMAL, "mn", "mon"),
    MON_KHMER("Mon-Khmer languages", LanguageType.GROUP, null, "mkh"),
    MONTENEGRIN("Montenegrin", LanguageType.NORMAL, null, "cnr"),
    MOSSI("Mossi", LanguageType.NORMAL, null, "mos"),
    MULTIPLE("Multiple languages", LanguageType.NON_LANGUAGE, null, "mul"),
    MUNDA("Munda;Munda languages", LanguageType.GROUP, null, "mun"),
    NAHUATL("Nahuatl;Nahuatl languages", LanguageType.GROUP, null, "nah"),
    NAURU("Nauru", LanguageType.NORMAL, "na", "nau"),
    NAVAJO("Navaho;Navajo", LanguageType.NORMAL, "nv", "nav"),
    NDONGA("Ndonga", LanguageType.NORMAL, "ng", "ndo"),
    NEAPOLITAN("Neapolitan", LanguageType.NORMAL, null, "nap"),
    NEWAR("Nepal Bhasa;Newari;Newar", LanguageType.NORMAL, null, "new"),
    NEPALI("Nepali (macrolanguage)", LanguageType.NORMAL, "ne", "nep"),
    NIAS("Nias", LanguageType.NORMAL, null, "nia"),
    NIGER_KORDOFANIAN("Niger-Kordofanian languages", LanguageType.GROUP, null, "nic"),
    NILO_SAHARAN("Nilo-Saharan languages", LanguageType.GROUP, null, "ssa"),
    NIUEAN("Niuean", LanguageType.NORMAL, null, "niu"),
    NKO("N'Ko", LanguageType.NORMAL, null, "nqo"),
    NA("No linguistic content;Not applicable;N/A", LanguageType.NORMAL, null, "zxx"),
    NOGAI("Nogai", LanguageType.NORMAL, null, "nog"),
    NORTH_AMERICAN_INDIAN("North American Indian languages", LanguageType.GROUP, null, "nai"),
    NORTH_NDEBELE("North Ndebele", LanguageType.NORMAL, "nd", "nde"),
    NORTHERN_FRISIAN("Northern Frisian", LanguageType.NORMAL, null, "frr"),
    NORTHERN_SAMI("Northern Sami", LanguageType.NORMAL, "se", "sme"),
    NORTHERN_SOTHO("Northern Sotho;Pedi;Sepedi", LanguageType.NORMAL, null, "nso"),
    NORWEGIAN_BOKMAAL("Norwegian Bokm\u00e5l", LanguageType.NON_LANGUAGE, "nb", "nob"),
    NORWEGIAN_NYNORSK("Norwegian Nynorsk", LanguageType.NON_LANGUAGE, "nn", "nno"),
    NORWEGIAN("Norwegian", LanguageType.NORMAL, "no", "nor"),
    NUBIAN("Nubian;Nubian languages", LanguageType.GROUP, null, "nub"),
    NUOSU("Nuosu;Sichuan Yi", LanguageType.NORMAL, "ii", "iii"),
    NYAMWEZI("Nyamwezi", LanguageType.NORMAL, null, "nym"),
    NYANKOLE("Nyankole", LanguageType.NORMAL, null, "nyn"),
    NYORO("Nyoro", LanguageType.NORMAL, null, "nyo"),
    NZIMA("Nzima", LanguageType.NORMAL, null, "nzi"),
    OCCITAN("Occitan (post 1500)", LanguageType.NORMAL, "oc", "oci"),
    OJIBWA("Ojibwa", LanguageType.NORMAL, "oj", "oji"),
    OLD_ENGLISH("Old English (ca. 450-1100)", LanguageType.HISTORICAL, null, "ang"),
    OLD_FRENCH("Old French (842-ca. 1400)", LanguageType.HISTORICAL, null, "fro"),
    OLD_HIGH_GERMAN("Old High German (ca. 750-1050)", LanguageType.HISTORICAL, null, "goh"),
    OLD_IRISH("Old Irish (to 900)", LanguageType.HISTORICAL, null, "sga"),
    OLD_NORSE("Old Norse", LanguageType.HISTORICAL, null, "non"),
    OLD_OCCITAN("Old Occitan (to 1500);Old Proven\u00e7al (to 1500)", LanguageType.HISTORICAL, null, "pro"),
    OLD_PERSIAN("Old Persian (ca. 600-400 B.C.)", LanguageType.HISTORICAL, null, "peo"),
    ORIYA("Oriya (macrolanguage)", LanguageType.NORMAL, "or", "ori"),
    OROMO("Oromo", LanguageType.NORMAL, "om", "orm"),
    OSAGE("Osage", LanguageType.NORMAL, null, "osa"),
    OSSETIAN("Ossetian; Ossetic", LanguageType.NORMAL, "os", "oss"),
    OTOMIAN("Otomian;Otomian languages", LanguageType.GROUP, null, "oto"),
    OTTOMAN_TURKISH("Ottoman Turkish (1500-1928)", LanguageType.HISTORICAL, null, "ota"),
    PAHLAVI("Pahlavi", LanguageType.NORMAL, null, "pal"),
    PALAUAN("Palauan", LanguageType.NORMAL, null, "pau"),
    PALI("Pali", LanguageType.NORMAL, "pi", "pli"),
    PANGASINAN("Pangasinan", LanguageType.NORMAL, null, "pag"),
    PUNJABI("Panjabi;Punjabi", LanguageType.NORMAL, "pa", "pan"),
    PAPIAMENTO("Papiamento", LanguageType.NORMAL, null, "pap"),
    PAPUAN("Papuan;Papuan languages", LanguageType.GROUP, null, "paa"),
    PASHTO("Pashto;Pushto", LanguageType.NORMAL, "ps", "pus"),
    PERSIAN("Persian", LanguageType.NORMAL, "fa", "per", "fas"),
    PHILIPPINE("Philippine;Philippine languages", LanguageType.GROUP, null, "phi"),
    PHOENICIAN("Phoenician", LanguageType.NORMAL, null, "phn"),
    POHNPEIAN("Pohnpeian", LanguageType.NORMAL, null, "pon"),
    POLISH("Polish", LanguageType.NORMAL, "pl", "pol"),
    PORTUGUESE("Portuguese", LanguageType.NORMAL, "pt", "por"),
    PRAKRIT("Prakrit;Prakrit languages", LanguageType.GROUP, null, "pra"),
    QUECHUA("Quechua", LanguageType.NORMAL, "qu", "que"),
    RAJASTHANI("Rajasthani", LanguageType.NORMAL, null, "raj"),
    RAPANUI("Rapanui", LanguageType.NORMAL, null, "rap"),
    RESERVED_LOCAL("Reserved for local use", LanguageType.NON_LANGUAGE, null, "qaa-qtz"),
    ROMANCE("Romance;Romance languages", LanguageType.GROUP, null, "roa"),
    ROMANSH("Romansh", LanguageType.NORMAL, "rm", "roh"),
    ROMANY("Romany", LanguageType.NORMAL, null, "rom"),
    RUNDI("Rundi", LanguageType.NORMAL, "rn", "run"),
    RUSSIAN("Russian", LanguageType.NORMAL, "ru", "rus"),
    SALISHAN("Salishan;Salishan languages", LanguageType.GROUP, null, "sal"),
    SAMARITAN_ARAMAIC("Samaritan Aramaic", LanguageType.NORMAL, null, "sam"),
    SAMI("Sami;Sami languages", LanguageType.GROUP, null, "smi"),
    SAMOAN("Samoan", LanguageType.NORMAL, "sm", "smo"),
    SANDAWE("Sandawe", LanguageType.NORMAL, null, "sad"),
    SANGO("Sango", LanguageType.NORMAL, "sg", "sag"),
    SANSKRIT("Sanskrit", LanguageType.NORMAL, "sa", "san"),
    SANTALI("Santali", LanguageType.NORMAL, null, "sat"),
    SARDINIAN("Sardinian", LanguageType.NORMAL, "sc", "srd"),
    SASAK("Sasak", LanguageType.NORMAL, null, "sas"),
    SCOTS("Scots", LanguageType.NORMAL, null, "sco"),
    SELKUP("Selkup", LanguageType.NORMAL, null, "sel"),
    SEMITIC("Semitic languages", LanguageType.GROUP, null, "sem"),
    SERBIAN("Serbian", LanguageType.NORMAL, "sr", "srp"),
    SERER("Serer", LanguageType.NORMAL, null, "srr"),
    SHAN("Shan", LanguageType.NORMAL, null, "shn"),
    SHONA("Shona", LanguageType.NORMAL, "sn", "sna"),
    SICILIAN("Sicilian", LanguageType.NORMAL, null, "scn"),
    SIDAMO("Sidamo", LanguageType.NORMAL, null, "sid"),
    SIGN("Sign;Sign Languages", LanguageType.GROUP, null, "sgn"),
    SIKSIKA("Siksika", LanguageType.NORMAL, null, "bla"),
    SINDHI("Sindhi", LanguageType.NORMAL, "sd", "snd"),
    SINHALESE("Sinhala;Sinhalese", LanguageType.NORMAL, "si", "sin"),
    SINO_TIBETAN("Sino-Tibetan languages", LanguageType.GROUP, null, "sit"),
    SIOUAN("Siouan;Siouan languages", LanguageType.GROUP, null, "sio"),
    SKOLT_SAMI("Skolt Sami", LanguageType.NORMAL, null, "sms"),
    SLAVE("Slave (Athapascan)", LanguageType.NORMAL, null, "den"),
    SLAVIC("Slavic languages", LanguageType.GROUP, null, "sla"),
    SLOVAK("Slovak", LanguageType.NORMAL, "sk", "slo", "slk"),
    SLOVENIAN("Slovenian", LanguageType.NORMAL, "sl", "slv"),
    SOGDIAN("Sogdian", LanguageType.NORMAL, null, "sog"),
    SOMALI("Somali", LanguageType.NORMAL, "so", "som"),
    SONGHAI("Songhai languages", LanguageType.GROUP, null, "son"),
    SONINKE("Soninke", LanguageType.NORMAL, null, "snk"),
    SORBIAN("Sorbian languages", LanguageType.GROUP, null, "wen"),
    SOUTH_AMERICAN_INDIAN("South American Indian languages", LanguageType.GROUP, null, "sai"),
    SOUTH_NDEBELE("South Ndebele", LanguageType.NORMAL, "nr", "nbl"),
    SOUTHERN_ALTAI("Southern Altai", LanguageType.NORMAL, null, "alt"),
    SOUTHERN_SAMI("Southern Sami", LanguageType.NORMAL, null, "sma"),
    SOUTHERN_SOTHO("Southern Sotho", LanguageType.NORMAL, "st", "sot"),
    SRANAN_TONGO("Sranan Tongo", LanguageType.NORMAL, null, "srn"),
    TAMAZIGHT("Standard Moroccan Tamazight", LanguageType.NORMAL, null, "zgh"),
    SUKUMA("Sukuma", LanguageType.NORMAL, null, "suk"),
    SUMERIAN("Sumerian", LanguageType.NORMAL, null, "sux"),
    SUNDANESE("Sundanese", LanguageType.NORMAL, "su", "sun"),
    SUSU("Susu", LanguageType.NORMAL, null, "sus"),
    SWAHILI("Swahili (macrolanguage)", LanguageType.NORMAL, "sw", "swa"),
    SWATI("Swati", LanguageType.NORMAL, "ss", "ssw"),
    SWEDISH("Swedish", LanguageType.NORMAL, "sv", "swe"),
    SYRIAC("Syriac", LanguageType.NORMAL, null, "syr"),
    TAGALOG("Tagalog", LanguageType.NORMAL, "tl", "tgl"),
    TAHITIAN("Tahitian", LanguageType.NORMAL, "ty", "tah"),
    TAI("Tai;Tai languages", LanguageType.GROUP, null, "tai"),
    TAJIK("Tajik", LanguageType.NORMAL, "tg", "tgk"),
    TAMASHEK("Tamashek", LanguageType.NORMAL, null, "tmh"),
    TAMIL("Tamil", LanguageType.NORMAL, "ta", "tam"),
    TATAR("Tatar", LanguageType.NORMAL, "tt", "tat"),
    TELUGU("Telugu", LanguageType.NORMAL, "te", "tel"),
    TERENO("Tereno", LanguageType.NORMAL, null, "ter"),
    TETUM("Tetum", LanguageType.NORMAL, null, "tet"),
    THAI("Thai", LanguageType.NORMAL, "th", "tha"),
    TIBETAN("Tibetan", LanguageType.NORMAL, "bo", "tib", "bod"),
    TIGRE("Tigre", LanguageType.NORMAL, null, "tig"),
    TIGRINYA("Tigrinya", LanguageType.NORMAL, "ti", "tir"),
    TIMNE("Timne", LanguageType.NORMAL, null, "tem"),
    TIV("Tiv", LanguageType.NORMAL, null, "tiv"),
    TLINGIT("Tlingit", LanguageType.NORMAL, null, "tli"),
    TOK_PISIN("Tok Pisin", LanguageType.NORMAL, null, "tpi"),
    TOKELAU("Tokelau", LanguageType.NORMAL, null, "tkl"),
    TONGA_NYASA("Tonga (Nyasa)", LanguageType.NORMAL, null, "tog"),
    TONGA_TONGA_ISLANDS("Tonga (Tonga Islands)", LanguageType.NORMAL, "to", "ton"),
    TSIMSHIAN("Tsimshian", LanguageType.NORMAL, null, "tsi"),
    TSONGA("Tsonga", LanguageType.NORMAL, "ts", "tso"),
    TSWANA("Tswana", LanguageType.NORMAL, "tn", "tsn"),
    TUMBUKA("Tumbuka", LanguageType.NORMAL, null, "tum"),
    TUPI("Tupi languages", LanguageType.GROUP, null, "tup"),
    TURKISH("Turkish", LanguageType.NORMAL, "tr", "tur"),
    TURKMEN("Turkmen", LanguageType.NORMAL, "tk", "tuk"),
    TUVALU("Tuvalu", LanguageType.NORMAL, null, "tvl"),
    TUVINIAN("Tuvinian", LanguageType.NORMAL, null, "tyv"),
    TWI("Twi", LanguageType.NORMAL, "tw", "twi"),
    UDMURT("Udmurt", LanguageType.NORMAL, null, "udm"),
    UGARITIC("Ugaritic", LanguageType.NORMAL, null, "uga"),
    UYGHUR("Uighur;Uyghur", LanguageType.NORMAL, "ug", "uig"),
    UKRAINIAN("Ukrainian", LanguageType.NORMAL, "uk", "ukr"),
    UMBUNDU("Umbundu", LanguageType.NORMAL, null, "umb"),
    UNCODED("Uncoded languages", LanguageType.NON_LANGUAGE, null, "mis"),
    UND("Undetermined", LanguageType.UNDEFINED, null, "und"),
    UPPER_SORBIAN("Upper Sorbian", LanguageType.NORMAL, null, "hsb"),
    URDU("Urdu", LanguageType.NORMAL, "ur", "urd"),
    UZBEK("Uzbek", LanguageType.NORMAL, "uz", "uzb"),
    VAI("Vai", LanguageType.NORMAL, null, "vai"),
    VENDA("Venda", LanguageType.NORMAL, "ve", "ven"),
    VIETNAMESE("Vietnamese", LanguageType.NORMAL, "vi", "vie"),
    VOLAPUK("Volap\u00fck", LanguageType.NORMAL, "vo", "vol"),
    VOTIC("Votic", LanguageType.NORMAL, null, "vot"),
    WAKASHAN("Wakashan languages", LanguageType.GROUP, null, "wak"),
    WALLOON("Walloon", LanguageType.NORMAL, "wa", "wln"),
    WARAY("Waray (Philippines)", LanguageType.NORMAL, null, "war"),
    WASHO("Washo", LanguageType.NORMAL, null, "was"),
    WELSH("Welsh", LanguageType.NORMAL, "cy", "wel", "cym"),
    WESTERN_FRISIAN("Western Frisian", LanguageType.NORMAL, "fy", "fry"),
    WOLAYTTA("Wolaitta;Wolaytta", LanguageType.NORMAL, null, "wal"),
    WOLOF("Wolof", LanguageType.NORMAL, "wo", "wol"),
    XHOSA("Xhosa", LanguageType.NORMAL, "xh", "xho"),
    YAKUT("Yakut", LanguageType.NORMAL, null, "sah"),
    YAO("Yao", LanguageType.NORMAL, null, "yao"),
    YAPESE("Yapese", LanguageType.NORMAL, null, "yap"),
    YIDDISH("Yiddish", LanguageType.NORMAL, "yi", "yid"),
    YORUBA("Yoruba", LanguageType.NORMAL, "yo", "yor"),
    YUPIK("Yupik;Yupik languages", LanguageType.GROUP, null, "ypk"),
    ZANDE("Zande;Zande languages", LanguageType.GROUP, null, "znd"),
    ZAPOTEC("Zapotec", LanguageType.NORMAL, null, "zap"),
    ZENAGA("Zenaga", LanguageType.NORMAL, null, "zen"),
    ZULU("Zulu", LanguageType.NORMAL, "zu", "zul"),
    ZUNI("Zuni", LanguageType.NORMAL, null, "zun");

    public static final Map<String, String> COMMON_MISSPELLINGS;
    public static final Map<String, ISO639> LOOKUP_CODES;
    public static final Map<String, ISO639> LOOKUP_NAMES;
    @Nonnull
    private final LanguageType type;
    @Nonnull
    private final List<String> names;
    @Nullable
    private final String iso639Part1;
    @Nullable
    private final String iso639Part2B;
    @Nonnull
    private final String iso639Part2T;

    private ISO639(@Nullable String names, @Nonnull LanguageType type, String part1, String part2T) {
        this.type = type;
        this.names = Collections.unmodifiableList(Arrays.asList(Constants.SEMICOLON.split(names)));
        this.iso639Part1 = part1;
        this.iso639Part2B = null;
        this.iso639Part2T = part2T;
    }

    private ISO639(@Nullable String names, @Nonnull LanguageType type, @Nonnull String part1, String part2B, String part2T) {
        this.type = type;
        this.names = Collections.unmodifiableList(Arrays.asList(Constants.SEMICOLON.split(names)));
        this.iso639Part1 = part1;
        this.iso639Part2B = part2B;
        this.iso639Part2T = part2T;
    }

    @Nonnull
    public String getName() {
        return this.getFirstName();
    }

    @Nonnull
    public String getFirstName() {
        return this.names.get(0);
    }

    @Nonnull
    public List<String> getNames() {
        return this.names;
    }

    @Nullable
    public String get2LetterCode() {
        return this.getPart1();
    }

    @Nullable
    public String getPart1() {
        return this.iso639Part1;
    }

    @Nonnull
    public String getCode() {
        return this.getPart2B();
    }

    @Nonnull
    public String getPart2B() {
        return this.iso639Part2B == null ? this.iso639Part2T : this.iso639Part2B;
    }

    @Nonnull
    public String getPart2T() {
        return this.iso639Part2T;
    }

    @Nonnull
    public String getShortestCode() {
        return StringUtil.isNotBlank(this.iso639Part1) ? this.iso639Part1 : this.getPart2B();
    }

    @Nonnull
    public LanguageType getType() {
        return this.type;
    }

    public boolean matches(@Nullable String code) {
        if (StringUtil.isBlank(code)) {
            return false;
        }
        return this.matchesInternal(ISO639.normalize(code));
    }

    private boolean matchesInternal(@Nullable String code) {
        if (code == null) {
            return false;
        }
        return code.equals(this.iso639Part1) || code.equals(this.iso639Part2B) || code.equals(this.iso639Part2T);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean debug) {
        if (!debug) {
            return this.names.get(0);
        }
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append(" [");
        if (this.names.size() > 1) {
            sb.append("Names=");
            for (int i = 0; i < this.names.size(); ++i) {
                if (i == this.names.size() - 1) {
                    sb.append(" and ");
                } else if (i > 0) {
                    sb.append(", ");
                }
                sb.append("\"").append(this.names.get(i)).append("\"");
            }
        } else {
            sb.append("Name=").append("\"").append(this.names.get(0)).append("\"");
        }
        if (StringUtil.isNotBlank(this.iso639Part1)) {
            sb.append(", 639-1=").append(this.iso639Part1);
        }
        sb.append(", 639-2=");
        if (this.iso639Part2B != null) {
            sb.append(this.iso639Part2B).append(" (B), ").append(this.iso639Part2T);
        } else {
            sb.append(this.iso639Part2T);
        }
        sb.append("]");
        return sb.toString();
    }

    @Nullable
    public static ISO639 getCode(@Nullable String code) {
        return code == null ? null : LOOKUP_CODES.get(ISO639.normalize(code));
    }

    @Nullable
    public static ISO639 get(@Nullable String code) {
        return ISO639.get(code, false);
    }

    @Nullable
    public static ISO639 get(@Nullable String code, boolean containsName) {
        if (StringUtil.isBlank(code)) {
            return null;
        }
        ISO639 result = LOOKUP_CODES.get(code = ISO639.normalize(code));
        if (result != null) {
            return result;
        }
        result = LOOKUP_NAMES.get(code);
        if (result != null) {
            return result;
        }
        String correctedCode = COMMON_MISSPELLINGS.get(code);
        if (correctedCode != null) {
            result = LOOKUP_NAMES.get(correctedCode);
            if (result != null) {
                return result;
            }
            code = correctedCode;
        }
        if (containsName && code.length() > 2) {
            for (Map.Entry<String, String> entry : COMMON_MISSPELLINGS.entrySet()) {
                if (!code.contains(entry.getKey())) continue;
                code = code.replace(entry.getKey(), entry.getValue());
            }
            result = LOOKUP_NAMES.get(code);
            if (result != null) {
                return result;
            }
            for (Map.Entry<String, Object> entry : LOOKUP_NAMES.entrySet()) {
                if (!code.contains(entry.getKey())) continue;
                return (ISO639)((Object)entry.getValue());
            }
        }
        return null;
    }

    @Nullable
    public static String getFirstName(@Nullable String code) {
        return ISO639.getFirstName(code, false);
    }

    @Nullable
    public static String getFirstName(@Nullable String code, boolean containsName) {
        ISO639 entry = ISO639.get(code, containsName);
        return entry == null ? null : entry.getFirstName();
    }

    @Nullable
    public static List<String> getNames(@Nullable String code) {
        return ISO639.getNames(code, false);
    }

    @Nullable
    public static List<String> getNames(@Nullable String code, boolean containsName) {
        ISO639 entry = ISO639.get(code, containsName);
        return entry == null ? null : entry.getNames();
    }

    @Nullable
    public static String getISOCode(@Nullable String code) {
        return ISO639.getISOCode(code, false);
    }

    @Nullable
    public static String getISOCode(@Nullable String code, boolean containsName) {
        ISO639 entry = ISO639.get(code, containsName);
        return entry == null ? null : entry.getShortestCode();
    }

    @Nullable
    public static String getISO639Part2Code(@Nullable String code) {
        return ISO639.getISO639Part2Code(code, false);
    }

    @Nullable
    public static String getISO639Part2Code(@Nullable String code, boolean containsName) {
        ISO639 entry = ISO639.get(code, containsName);
        return entry == null ? null : entry.getPart2B();
    }

    @Nullable
    private static String normalize(@Nullable String isoCode) {
        if (StringUtil.isBlank(isoCode)) {
            return isoCode;
        }
        isoCode = isoCode.trim().toLowerCase(Locale.ROOT);
        return isoCode;
    }

    public static boolean isCodeMatching(@Nullable String language, @Nullable String code) {
        if (StringUtil.isBlank(language) || StringUtil.isBlank(code)) {
            return false;
        }
        ISO639 codeEntry = ISO639.getCode(code);
        if (codeEntry == null) {
            return false;
        }
        ISO639 nameEntry = LOOKUP_NAMES.get(language.trim().toLowerCase(Locale.ROOT));
        return codeEntry == nameEntry;
    }

    public static boolean isCodesMatching(@Nullable String code1, @Nullable String code2) {
        ISO639 code1Entry = ISO639.getCode(code1);
        if (code1Entry == null) {
            return false;
        }
        ISO639 code2Entry = ISO639.getCode(code2);
        return code1Entry == code2Entry;
    }

    @Nullable
    public static ISO639 fromBCP47(@Nullable String bcp47Tag) {
        if (StringUtil.isBlank(bcp47Tag)) {
            return null;
        }
        int remove = bcp47Tag.indexOf(45);
        int slash = bcp47Tag.indexOf(47);
        if (remove >= 0 && slash >= 0) {
            remove = Math.min(remove, slash);
        } else if (slash >= 0) {
            remove = slash;
        }
        if (remove >= 0) {
            bcp47Tag = bcp47Tag.substring(0, remove);
        }
        return ISO639.get(bcp47Tag);
    }

    static {
        HashMap<String, String> misspellings = new HashMap<String, String>();
        misspellings.put("ameircan", "american");
        misspellings.put("artifical", "artificial");
        misspellings.put("brasillian", "brazilian");
        misspellings.put("carrib", "carib");
        misspellings.put("centeral", "central");
        misspellings.put("chineese", "chinese");
        misspellings.put("curch", "church");
        misspellings.put("dravadian", "dravidian");
        misspellings.put("enlish", "english");
        misspellings.put("euorpean", "european");
        misspellings.put("farsi", "persian");
        misspellings.put("hawaian", "hawaiian");
        misspellings.put("hebrwe", "hebrew");
        misspellings.put("japaneese", "japanese");
        misspellings.put("javaneese", "javanese");
        misspellings.put("laguage", "language");
        misspellings.put("madureese", "madurese");
        misspellings.put("malteese", "maltese");
        misspellings.put("maltesian", "maltese");
        misspellings.put("miscelaneous", "miscellaneous");
        misspellings.put("miscellanious", "miscellaneous");
        misspellings.put("miscellanous", "miscellaneous");
        misspellings.put("northen", "northern");
        misspellings.put("norweigan", "norwegian");
        misspellings.put("ottaman", "ottoman");
        misspellings.put("philipine", "philippine");
        misspellings.put("phonecian", "phoenician");
        misspellings.put("portugese", "portuguese");
        misspellings.put("rusian", "russian");
        misspellings.put("sinhaleese", "sinhalese");
        misspellings.put("sourth", "south");
        misspellings.put("spainish", "spanish");
        misspellings.put("sweedish", "swedish");
        misspellings.put("ukranian", "ukrainian");
        misspellings.put("vietnameese", "vietnamese");
        COMMON_MISSPELLINGS = Collections.unmodifiableMap(misspellings);
        HashMap<String, ISO639> codes = new HashMap<String, ISO639>();
        HashMap<String, ISO639> names = new HashMap<String, ISO639>();
        for (ISO639 entry : ISO639.values()) {
            for (String name : entry.names) {
                if (!StringUtil.isNotBlank(name)) continue;
                names.put(name.replaceAll("\\s*\\([^\\)]*\\)\\s*", "").toLowerCase(Locale.ROOT), entry);
            }
            if (StringUtil.isNotBlank(entry.iso639Part1)) {
                codes.put(entry.iso639Part1, entry);
            }
            if (StringUtil.isNotBlank(entry.iso639Part2B)) {
                codes.put(entry.iso639Part2B, entry);
            }
            codes.put(entry.iso639Part2T, entry);
        }
        LOOKUP_CODES = Collections.unmodifiableMap(codes);
        LOOKUP_NAMES = Collections.unmodifiableMap(names);
    }

    public static enum LanguageType {
        GROUP,
        HISTORICAL,
        NON_LANGUAGE,
        NORMAL,
        UNDEFINED;

    }
}

