/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.tool;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.digitalmediaserver.crowdin.tool.StringUtil;

public class NSISUtil {
    public static final Pattern COMMENT_TAG = Pattern.compile("^[^'`\"]*(?:#|;)");
    public static final Pattern SINGLE_QUOTED_STRING = Pattern.compile("^([^']*)'(.*)'([^']*)$");
    public static final Pattern BACKTICK_QUOTED_STRING = Pattern.compile("^([^`]*)`(.*)`([^`]*)$");
    public static final Pattern DOUBLE_QUOTED_STRING = Pattern.compile("^([^\"]*)\"(.*)\"([^\"]*)$");
    public static final Pattern ESCAPES = Pattern.compile("(?<!\\$)\\\\");
    public static final Pattern DOLLAR_ESCAPES = Pattern.compile("\\$\\\\");
    public static final Pattern DOLLAR = Pattern.compile("\\$(?!\\\\)");
    public static final Pattern DOUBLE_DOLLAR = Pattern.compile("\\$\\$(?!\\\\)");
    protected static final int BUFFER_SIZE = 4096;

    private NSISUtil() {
    }

    @Nullable
    public static String convertLineFromNSIS(@Nullable String inputLine) {
        if (inputLine == null) {
            return null;
        }
        return NSISUtil.convertLine(inputLine, true);
    }

    @Nonnull
    public static String convertLineToNSIS(@Nonnull String inputLine) {
        return NSISUtil.convertLine(inputLine, false);
    }

    @Nonnull
    protected static String convertLine(@Nonnull String inputLine, boolean from) {
        String comment;
        String content;
        if (StringUtil.isBlank(inputLine)) {
            return inputLine;
        }
        Matcher matcher = COMMENT_TAG.matcher(inputLine);
        if (matcher.find()) {
            content = inputLine.substring(0, matcher.start());
            comment = inputLine.substring(matcher.start());
        } else {
            content = inputLine;
            comment = null;
        }
        if (StringUtil.isBlank(content)) {
            return inputLine;
        }
        int firstSingleQuote = inputLine.indexOf(39);
        int firstBackTick = inputLine.indexOf(96);
        int firstQuote = inputLine.indexOf(34);
        firstQuote = (firstSingleQuote = firstSingleQuote > -1 && firstBackTick > -1 ? Math.min(firstSingleQuote, firstBackTick) : Math.max(firstSingleQuote, firstBackTick)) > -1 && firstQuote > -1 ? Math.min(firstSingleQuote, firstQuote) : Math.max(firstSingleQuote, firstQuote);
        if (firstQuote < 0) {
            return inputLine;
        }
        char quote = inputLine.charAt(firstQuote);
        Pattern pattern = quote == '\"' ? DOUBLE_QUOTED_STRING : (quote == '`' ? BACKTICK_QUOTED_STRING : SINGLE_QUOTED_STRING);
        matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return inputLine;
        }
        String text = matcher.group(2);
        if (StringUtil.isBlank(text)) {
            return inputLine;
        }
        if (from) {
            text = DOLLAR_ESCAPES.matcher(text).replaceAll("\\\\");
            text = DOUBLE_DOLLAR.matcher(text).replaceAll("\\$");
        } else {
            text = DOLLAR.matcher(text).replaceAll("\\$\\$");
            text = ESCAPES.matcher(text).replaceAll("\\$\\\\");
            text = text.replaceAll("(?<!\\$\\\\)" + quote, "\\$\\\\" + quote);
        }
        StringBuilder sb = new StringBuilder(inputLine.length() + 10);
        sb.append(matcher.group(1)).append(quote).append(text).append(quote).append(matcher.group(3));
        if (comment != null) {
            sb.append(comment);
        }
        return sb.toString();
    }

    @Nullable
    protected static byte[] getUTF8ByteArray(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static class NSISInputStream
    extends InputStream {
        @Nonnull
        private InputStream inputStream;
        private byte[] line;
        private int linePos;
        private final byte[] buffer = new byte[4096];
        private int pos;
        private int lim = -1;
        private boolean eof;
        private String lastLineSeparator;
        private boolean remainingLineFeed;

        public NSISInputStream(@Nonnull Path file) throws IOException {
            if (file == null) {
                throw new IllegalArgumentException("file cannot be null");
            }
            this.inputStream = Files.newInputStream(file, new OpenOption[0]);
        }

        @Override
        public int read() throws IOException {
            if (this.remainingLineFeed) {
                this.remainingLineFeed = false;
                return 10;
            }
            if (this.line == null) {
                if (this.eof) {
                    return -1;
                }
                this.line = NSISUtil.getUTF8ByteArray(NSISUtil.convertLineFromNSIS(this.getNextLine()));
                this.linePos = 0;
                if (this.line == null) {
                    return -1;
                }
            }
            if (this.linePos == this.line.length) {
                if (this.lastLineSeparator == null) {
                    return -1;
                }
                byte[] separatorBytes = this.lastLineSeparator.getBytes(StandardCharsets.UTF_8);
                if (separatorBytes.length > 1) {
                    this.remainingLineFeed = true;
                }
                this.line = NSISUtil.getUTF8ByteArray(NSISUtil.convertLineFromNSIS(this.getNextLine()));
                this.linePos = 0;
                return separatorBytes[0];
            }
            return this.line[this.linePos++] & 0xFF;
        }

        @Nullable
        protected String getNextLine() throws IOException {
            if (this.bufferRemaining() == 0 && this.eof) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            int nextLineSeparator = this.getNextLineSeparatorIndex();
            while (nextLineSeparator < 0 || nextLineSeparator == this.lim) {
                if (this.bufferRemaining() > 0) {
                    if (nextLineSeparator == this.lim) {
                        sb.append(new String(this.buffer, this.pos, nextLineSeparator - this.pos, StandardCharsets.UTF_8));
                        this.pos = nextLineSeparator;
                    } else {
                        int lastBoundary = this.findLastBoundary();
                        sb.append(new String(this.buffer, this.pos, lastBoundary - this.pos + 1, StandardCharsets.UTF_8));
                        this.pos = lastBoundary + 1;
                    }
                }
                this.fillBuffer();
                if (this.bufferRemaining() == 0 && this.eof) {
                    this.lastLineSeparator = null;
                    return sb.toString();
                }
                nextLineSeparator = this.getNextLineSeparatorIndex();
            }
            if (this.bufferRemaining() > 0) {
                sb.append(new String(this.buffer, this.pos, nextLineSeparator - this.pos, StandardCharsets.UTF_8));
                this.pos = nextLineSeparator;
            }
            if (this.buffer[this.pos] == 10) {
                ++this.pos;
                this.lastLineSeparator = "\n";
            } else if (this.buffer[this.pos] == 13) {
                if (this.pos == this.lim) {
                    ++this.pos;
                    this.fillBuffer();
                    if (this.bufferRemaining() == 0 || this.buffer[this.pos] != 10) {
                        this.lastLineSeparator = "\r";
                        ++this.pos;
                    } else {
                        this.lastLineSeparator = "\r\n";
                        this.pos += 2;
                    }
                } else if (this.buffer[this.pos + 1] == 10) {
                    this.lastLineSeparator = "\r\n";
                    this.pos += 2;
                } else {
                    this.lastLineSeparator = "\r";
                    ++this.pos;
                }
            } else {
                throw new AssertionError((Object)"Logical flaw in getNextLine()");
            }
            return sb.toString();
        }

        protected int findLastBoundary() {
            int lastBoundary;
            if (this.lim < 1) {
                return this.lim;
            }
            for (lastBoundary = this.lim; lastBoundary >= 0; --lastBoundary) {
                if (this.buffer[lastBoundary] >= 0) {
                    return lastBoundary;
                }
                if ((this.buffer[lastBoundary] & 0x40) <= 0) continue;
                int remainingBytes = 0;
                if ((this.buffer[lastBoundary] & 0xE0) == 192) {
                    remainingBytes = 1;
                } else if ((this.buffer[lastBoundary] & 0xF0) == 224) {
                    remainingBytes = 2;
                } else if ((this.buffer[lastBoundary] & 0xF8) == 240) {
                    remainingBytes = 3;
                }
                if (remainingBytes <= 0 || lastBoundary + remainingBytes > this.lim) continue;
                return lastBoundary + remainingBytes;
            }
            return lastBoundary;
        }

        protected void fillBuffer() throws IOException {
            if (this.pos > 0 && this.pos <= this.lim) {
                System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.lim + 1 - this.pos);
                this.lim -= this.pos;
            } else {
                this.lim = -1;
            }
            this.pos = 0;
            while (this.lim < this.buffer.length - 1) {
                int count = this.inputStream.read(this.buffer, this.lim + 1, this.buffer.length - this.lim - 1);
                if (count == -1) {
                    this.eof = true;
                    return;
                }
                this.lim += count;
            }
        }

        protected int getNextLineSeparatorIndex() {
            for (int i = this.pos; i <= this.lim; ++i) {
                byte value = this.buffer[i];
                if (value != 10 && value != 13) continue;
                return i;
            }
            return -1;
        }

        protected int bufferRemaining() {
            return this.lim - this.pos + 1;
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }
    }
}

