/*
 * Cuelib library for manipulating cue sheets.
 * Copyright (C) 2007-2009 Jan-Willem van den Broek
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package org.digitalmediaserver.cuelib.id3;


/**
 * The Enum CanonicalFrameType.
 */
public enum CanonicalFrameType {

	/** The accompanying performer. */
	ACCOMPANYING_PERFORMER,

	/** The album. */
	ALBUM,

	/** The album sort order. */
	ALBUM_SORT_ORDER,

	/** The beats per minute. */
	BEATS_PER_MINUTE,

	/** The comment. */
	COMMENT,

	/** The commercial information URL. */
	COMMERCIAL_INFORMATION_URL,

	/** The composers. */
	COMPOSERS,

	/** The conductor. */
	CONDUCTOR,

	/** The content group description. */
	CONTENT_GROUP_DESCRIPTION,

	/** The copyright. */
	COPYRIGHT,

	/** The copyright or legal information URL. */
	COPYRIGHT_OR_LEGAL_INFORMATION_URL,

	/** The custom text. */
	CUSTOM_TEXT,

	/** The custom webpage. */
	CUSTOM_WEBPAGE,

	/** The content type, effectively genre. */
	CONTENT_TYPE,

	/** The date. */
	DATE,

	/** The encoder. */
	ENCODER,

	/** The encoder equipment or settings. */
	ENCODER_EQUIPMENT_OR_SETTINGS,

	/** The encoding timestamp. */
	ENCODING_TIMESTAMP,

	/** The file type. */
	FILE_TYPE,

	/** The initial key. */
	INITIAL_KEY,

	/** The involved people list. */
	INVOLVED_PEOPLE_LIST,

	/** The iTunes podcast. */
	ITUNES_PODCAST,

	/** The iTunes podcast category. */
	ITUNES_PODCAST_CATEGORY,

	/** The iTunes podcast description. */
	ITUNES_PODCAST_DESCRIPTION,

	/** The iTunes podcast feed URL. */
	ITUNES_PODCAST_FEED_URL,

	/** The iTunes podcast keywords. */
	ITUNES_PODCAST_KEYWORDS,

	/** The iTunes podcast release time. */
	ITUNES_PODCAST_RELEASE_TIME,

	/** The iTunes podcast URL. */
	ITUNES_PODCAST_URL,

	/** The ISRC. */
	ISRC,

	/** The languages. */
	LANGUAGES,

	/** The media type. */
	MEDIA_TYPE,

	/** The modified by. */
	MODIFIED_BY,

	/** The mood. */
	MOOD,

	/** The music CD identifier. */
	MUSIC_CD_IDENTIFIER,

	/** The musician credits list. */
	MUSICIAN_CREDITS_LIST,

	/** The name. */
	NAME,

	/** The official artist web page. */
	OFFICIAL_ARTIST_WEBPAGE,

	/** The official audio file web page. */
	OFFICIAL_AUDIO_FILE_WEBPAGE,

	/** The official audio source web page. */
	OFFICIAL_AUDIO_SOURCE_WEBPAGE,

	/** The official payment web page. */
	OFFICIAL_PAYMENT_WEBPAGE,

	/** The official publisher web page. */
	OFFICIAL_PUBLISHER_WEBPAGE,

	/** The official radio station web page. */
	OFFICIAL_RADIO_STATION_WEBPAGE,

	/** The original artists. */
	ORIGINAL_ARTISTS,

	/** The original file name. */
	ORIGINAL_FILE_NAME,

	/** The original release time. */
	ORIGINAL_RELEASE_TIME,

	/** The original text writers. */
	ORIGINAL_TEXT_WRITERS,

	/** The original title. */
	ORIGINAL_TITLE,

	/** The original year. */
	ORIGINAL_YEAR,

	/** The owner. */
	OWNER,

	/** The part. */
	PART,

	/** The performer. */
	PERFORMER,

	/** The performer sort order. */
	PERFORMER_SORT_ORDER,

	/** The picture. */
	PICTURE,

	/** The playlist delay in milliseconds. */
	PLAYLIST_DELAY_MS,

	/** The produced note. */
	PRODUCED_NOTE,

	/** The publisher. */
	PUBLISHER,

	/** The radio station. */
	RADIO_STATION,

	/** The radio station owner. */
	RADIO_STATION_OWNER,

	/** The recording dates. */
	RECORDING_DATES,

	/** The recording time. */
	RECORDING_TIME,

	/** The set subtitle. */
	SET_SUBTITLE,

	/** The subtitle. */
	SUBTITLE,

	/** The tagging timestamp. */
	TAGGING_TIMESTAMP,

	/** The text writers. */
	TEXT_WRITERS,

	/** The time. */
	TIME,

	/** The title. */
	TITLE,

	/** The title sort order. */
	TITLE_SORT_ORDER,

	/** The track length in milliseconds. */
	TRACK_LENGTH_MS,

	/** The track no. */
	TRACK_NO,

	/** The track size bytes. */
	TRACK_SIZE_BYTES,

	/** The unique file identifier. */
	UNIQUE_FILE_IDENTIFIER,

	/** An unrecognized frame. */
	UNRECOGNIZED_FRAME,

	/** The user defined text. */
	USER_DEFINED_TEXT,

	/** The user defined URL. */
	USER_DEFINED_URL,

	/** The year. */
	YEAR
}
