/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.digitalmediaserver.cuelib.id3.CanonicalFrameType;
import org.digitalmediaserver.cuelib.id3.ID3Frame;

public class CommentFrame
implements ID3Frame {
    private String description;
    private String text;
    private String languageCode;
    private int totalFrameSize;
    private Charset charset = StandardCharsets.ISO_8859_1;
    private Properties flags = new Properties();

    public CommentFrame() {
    }

    public CommentFrame(int totalFrameSize) {
        this.totalFrameSize = totalFrameSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Comment frame: ").append(this.languageCode).append(" [").append(this.totalFrameSize).append("] ").append(this.charset.toString()).append('\n').append("Flags: ").append(this.flags.toString()).append('\n').append("Description: ").append(this.description).append('\n').append("Text: ").append(this.text);
        return builder.toString();
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public int getTotalFrameSize() {
        return this.totalFrameSize;
    }

    public void setTotalFrameSize(int totalFrameSize) {
        this.totalFrameSize = totalFrameSize;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public CanonicalFrameType getCanonicalFrameType() {
        return CanonicalFrameType.COMMENT;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    @Override
    public Properties getFlags() {
        return this.flags;
    }
}

