/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.digitalmediaserver.cuelib.id3.ID3Reader;
import org.digitalmediaserver.cuelib.id3.ID3Version;
import org.digitalmediaserver.cuelib.id3.v1.ID3v1Reader;
import org.digitalmediaserver.cuelib.id3.v2.r00.ID3v2r00Reader;
import org.digitalmediaserver.cuelib.id3.v2.r30.ID3v2r30Reader;
import org.digitalmediaserver.cuelib.id3.v2.r40.ID3v2r40Reader;

public class ID3ReaderFactory {
    private ID3ReaderFactory() {
    }

    public static ID3Reader getReader(ID3Version version) {
        switch (version) {
            case ID3v1: 
            case ID3v1r0: 
            case ID3v1r1: {
                return new ID3v1Reader();
            }
            case ID3v2r0: 
            case ID3v2r2: {
                return new ID3v2r00Reader();
            }
            case ID3v2r3: {
                return new ID3v2r30Reader();
            }
            case ID3v2: 
            case ID3v2r4: {
                return new ID3v2r40Reader();
            }
        }
        throw new RuntimeException("Unsupported ID3 version: " + version.toString());
    }

    public static ID3Reader getReader(File file) throws IOException {
        return ID3ReaderFactory.getReader(ID3ReaderFactory.getVersion(file));
    }

    private static ID3Version getID3v2Version(RandomAccessFile input) throws IOException {
        if (input.read() == 73 && input.read() == 68 && input.read() == 51) {
            int majorVersion = input.read();
            switch (majorVersion) {
                case 0: {
                    return ID3Version.ID3v2r0;
                }
                case 3: {
                    return ID3Version.ID3v2r3;
                }
                case 4: {
                    return ID3Version.ID3v2r4;
                }
            }
            return null;
        }
        return null;
    }

    private static ID3Version getID3v1Version(RandomAccessFile input) throws IOException {
        ID3Version result = null;
        if (input.length() >= 128L) {
            input.seek(input.length() - 128L);
            if (input.readUnsignedByte() == 84 && input.readUnsignedByte() == 65 && input.readUnsignedByte() == 71) {
                input.seek(input.length() - 3L);
                int trackNoMarker = input.readUnsignedByte();
                int rawTrackNo = input.readUnsignedByte();
                if (trackNoMarker == 0) {
                    result = rawTrackNo == 0 ? ID3Version.ID3v1 : ID3Version.ID3v1r1;
                }
            }
        }
        return result;
    }

    public static ID3Version getVersion(File file) throws IOException {
        try (RandomAccessFile input = new RandomAccessFile(file, "r");){
            ID3Version result = null;
            result = ID3ReaderFactory.getID3v2Version(input);
            if (result == null) {
                result = ID3ReaderFactory.getID3v1Version(input);
            }
            ID3Version iD3Version = result;
            return iD3Version;
        }
    }

    public static List<ID3Version> getVersions(File file) throws IOException {
        ArrayList<ID3Version> result = new ArrayList<ID3Version>();
        try (RandomAccessFile input = new RandomAccessFile(file, "r");){
            ID3Version v1result;
            ID3Version v2result = ID3ReaderFactory.getID3v2Version(input);
            if (v2result != null) {
                result.add(v2result);
            }
            if ((v1result = ID3ReaderFactory.getID3v1Version(input)) != null) {
                result.add(v1result);
            }
            ArrayList<ID3Version> arrayList = result;
            return arrayList;
        }
    }
}

