/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.digitalmediaserver.cuelib.id3.CanonicalFrameType;
import org.digitalmediaserver.cuelib.id3.ID3Frame;

public class InvolvedPeopleFrame
implements ID3Frame {
    private int totalFrameSize;
    private Charset charset = Charset.forName("ISO-8859-1");
    private final List<InvolvedPerson> involvedPeopleList = new ArrayList<InvolvedPerson>();
    private Properties flags = new Properties();

    @Override
    public Properties getFlags() {
        return this.flags;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public InvolvedPeopleFrame() {
    }

    public InvolvedPeopleFrame(int totalFrameSize) {
        this.totalFrameSize = totalFrameSize;
    }

    @Override
    public CanonicalFrameType getCanonicalFrameType() {
        return CanonicalFrameType.INVOLVED_PEOPLE_LIST;
    }

    @Override
    public int getTotalFrameSize() {
        return this.totalFrameSize;
    }

    public void setTotalFrameSize(int totalFrameSize) {
        this.totalFrameSize = totalFrameSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Involved People frame: ").append(" [").append(this.totalFrameSize).append("] ").append(this.charset.toString()).append('\n').append("Flags: ").append(this.flags.toString()).append('\n');
        for (InvolvedPerson involvedPerson : this.involvedPeopleList) {
            builder.append("Involvee: ").append(involvedPerson.getInvolvee()).append("Involvement: ").append(involvedPerson.getInvolvement()).append('\n');
        }
        return builder.toString();
    }

    public List<InvolvedPerson> getInvolvedPeopleList() {
        return this.involvedPeopleList;
    }

    public static class InvolvedPerson {
        private String involvee;
        private String involvement;

        public String getInvolvee() {
            return this.involvee;
        }

        public void setInvolvee(String involvee) {
            this.involvee = involvee;
        }

        public String getInvolvement() {
            return this.involvement;
        }

        public void setInvolvement(String involvement) {
            this.involvement = involvement;
        }
    }
}

