/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.digitalmediaserver.cuelib.id3.CanonicalFrameType;
import org.digitalmediaserver.cuelib.id3.ID3Frame;

public class PictureFrame
implements ID3Frame {
    private int totalFrameSize;
    private Charset charset = Charset.forName("ISO-8859-1");
    private Properties flags = new Properties();
    private PictureType pictureType = PictureType.OTHER;
    private int pictureNumber = this.pictureType.getNumber();
    private String description;
    private String imageType;
    private byte[] imageData;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Picture frame: [").append(this.totalFrameSize).append("] ").append(this.charset.toString()).append('\n').append("Flags: ").append(this.flags.toString()).append('\n').append("Type: ").append(this.pictureType.toString()).append(" (").append(this.pictureNumber).append(")\n").append("Format: ").append(this.imageType).append(")\n").append("Description: ").append(this.description);
        return builder.toString();
    }

    public void setPictureType(PictureType pictureType) {
        this.pictureType = pictureType;
        this.pictureNumber = pictureType.getNumber();
    }

    public int getPictureNumber() {
        return this.pictureNumber;
    }

    public void setPictureNumber(int number) {
        this.pictureNumber = number;
        this.pictureType = PictureType.getPictureType(number);
    }

    @Override
    public CanonicalFrameType getCanonicalFrameType() {
        return CanonicalFrameType.PICTURE;
    }

    @Override
    public Properties getFlags() {
        return this.flags;
    }

    @Override
    public int getTotalFrameSize() {
        return this.totalFrameSize;
    }

    public void setTotalFrameSize(int totalFrameSize) {
        this.totalFrameSize = totalFrameSize;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImageType() {
        return this.imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public static enum PictureType {
        OTHER(0),
        FILE_ICON_32X32(1),
        OTHER_FILE_ICON(2),
        FRONT_COVER(3),
        BACK_COVER(4),
        LEAFLET_PAGE(5),
        MEDIA(6),
        LEAD_PERFORMER(7),
        PERFORMER(8),
        CONDUCTOR(9),
        BAND_OR_ORCHESTRA(10),
        COMPOSER(11),
        LYRICIST(12),
        RECORDING_LOCATION(13),
        DURING_RECORDING(14),
        DURING_PERFORMANCE(15),
        MOVIE_CAPTURE(16),
        A_BRIGHT_COLOURED_FISH(17),
        ILLUSTRATION(18),
        BAND_OR_ARTIST_LOGOTYPE(19),
        PUBLISHER_OR_STUDIO_LOGOTYPE(20),
        UNOFFICIAL(21);

        private static Map<Integer, PictureType> numberToType;
        private int number;

        private PictureType(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }

        public static PictureType getPictureType(int number) {
            PictureType result = numberToType.get(number);
            if (result == null) {
                return UNOFFICIAL;
            }
            return result;
        }

        static {
            numberToType = new HashMap<Integer, PictureType>();
            for (int index = 0; index < PictureType.values().length; ++index) {
                numberToType.put(PictureType.values()[index].getNumber(), PictureType.values()[index]);
            }
        }
    }
}

