/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3;

import java.nio.charset.Charset;
import java.util.Properties;
import org.digitalmediaserver.cuelib.id3.CanonicalFrameType;
import org.digitalmediaserver.cuelib.id3.ID3Frame;

public class TextFrame
implements ID3Frame {
    private String additionalTypeInfo = "";
    private String text;
    private int totalFrameSize;
    private CanonicalFrameType canonicalFrameType;
    private Charset charset = Charset.forName("ISO-8859-1");
    private Properties flags = new Properties();

    public TextFrame(CanonicalFrameType canonicalFrameType) {
        this(canonicalFrameType, " ");
    }

    public TextFrame(CanonicalFrameType canonicalFrameType, String text) {
        this(canonicalFrameType, text, text.length());
    }

    public TextFrame(CanonicalFrameType canonicalFrameType, String text, int totalFrameSize) {
        this.canonicalFrameType = canonicalFrameType;
        this.text = text;
        this.totalFrameSize = totalFrameSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Text frame: ").append(this.canonicalFrameType.toString()).append(' ').append(this.additionalTypeInfo).append(" [").append(this.totalFrameSize).append("] ").append(this.charset.toString()).append('\n').append("Flags: ").append(this.flags.toString()).append('\n').append("Text: ").append(this.text);
        return builder.toString();
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public int getTotalFrameSize() {
        return this.totalFrameSize;
    }

    public void setTotalFrameSize(int totalFrameSize) {
        this.totalFrameSize = totalFrameSize;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public CanonicalFrameType getCanonicalFrameType() {
        return this.canonicalFrameType;
    }

    public void setCanonicalFrameType(CanonicalFrameType canonicalFrameType) {
        this.canonicalFrameType = canonicalFrameType;
    }

    @Override
    public Properties getFlags() {
        return this.flags;
    }

    public String getAdditionalTypeInfo() {
        return this.additionalTypeInfo;
    }

    public void setAdditionalTypeInfo(String additionalTypeInfo) {
        this.additionalTypeInfo = additionalTypeInfo;
    }
}

