/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteCountInputStream
extends FilterInputStream {
    private long bytesRead = 0L;

    public ByteCountInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int byteRead = this.in.read();
        if (byteRead >= 0) {
            ++this.bytesRead;
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = super.read(b, off, len);
        if (count > 0) {
            this.bytesRead += (long)count;
        }
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = super.skip(n);
        if (bytesSkipped > 0L) {
            this.bytesRead += bytesSkipped;
        }
        return bytesSkipped;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void resetBytesRead() {
        this.bytesRead = 0L;
    }
}

