/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.digitalmediaserver.cuelib.util.Utils;

public class FieldReader {
    private FieldReader() {
    }

    public static String readUntilNul(InputStream input, int length, Charset charset) throws IOException {
        boolean singleNul;
        if (charset.equals(Charset.forName("ISO-8859-1"))) {
            singleNul = true;
        } else if (charset.equals(Charset.forName("UTF-16"))) {
            singleNul = false;
        } else if (charset.equals(Charset.forName("UTF-16BE"))) {
            singleNul = false;
        } else if (charset.equals(Charset.forName("UTF-8"))) {
            singleNul = true;
        } else {
            throw new IllegalArgumentException("Encoding not supported: " + charset.toString());
        }
        byte[] b = new byte[length];
        int previousValue = -1;
        for (int index = 0; index < length; ++index) {
            byte currentValue = (byte)input.read();
            if (currentValue == 0 && (singleNul || previousValue == 0)) {
                int bytesUntilNul = index - (singleNul ? 0 : 1);
                return new String(b, 0, bytesUntilNul, charset);
            }
            b[index] = currentValue;
            previousValue = currentValue;
        }
        return new String(b, charset);
    }

    public static String readField(InputStream input, int length, Charset charset) throws IOException {
        byte[] b = new byte[length];
        Utils.readFully((InputStream)input, (byte[])b);
        String rawResult = new String(b, charset);
        int nulPosition = rawResult.indexOf(0);
        return rawResult.substring(0, nulPosition == -1 ? rawResult.length() : nulPosition);
    }
}

