/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v1;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.digitalmediaserver.cuelib.id3.CanonicalFrameType;
import org.digitalmediaserver.cuelib.id3.ID3Reader;
import org.digitalmediaserver.cuelib.id3.ID3Tag;
import org.digitalmediaserver.cuelib.id3.ID3Version;
import org.digitalmediaserver.cuelib.id3.TextFrame;
import org.digitalmediaserver.cuelib.util.Utils;

public class ID3v1Reader
implements ID3Reader {
    @Override
    public boolean hasTag(File file) throws IOException {
        try (RandomAccessFile input = new RandomAccessFile(file, "r");){
            if (input.length() >= 128L) {
                input.seek(input.length() - 128L);
                if (input.readUnsignedByte() == 84 && input.readUnsignedByte() == 65 && input.readUnsignedByte() == 71) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public ID3Tag read(File file) throws IOException {
        ID3Tag tag = new ID3Tag();
        try (RandomAccessFile input = new RandomAccessFile(file, "r");){
            if (input.length() >= 128L) {
                input.seek(input.length() - 128L);
                if (input.readUnsignedByte() == 84 && input.readUnsignedByte() == 65 && input.readUnsignedByte() == 71) {
                    tag.setVersion(ID3Version.ID3v1r0);
                    tag.getFrames().add(new TextFrame(CanonicalFrameType.TITLE, ID3v1Reader.getField(input, 30), 30));
                    tag.getFrames().add(new TextFrame(CanonicalFrameType.PERFORMER, ID3v1Reader.getField(input, 30), 30));
                    tag.getFrames().add(new TextFrame(CanonicalFrameType.ALBUM, ID3v1Reader.getField(input, 30), 30));
                    tag.getFrames().add(new TextFrame(CanonicalFrameType.YEAR, ID3v1Reader.getField(input, 4), 4));
                    TextFrame commentFrame = new TextFrame(CanonicalFrameType.COMMENT, ID3v1Reader.getField(input, 30), 30);
                    tag.getFrames().add(commentFrame);
                    int rawGenre = input.readUnsignedByte();
                    if (rawGenre != 0) {
                        tag.getFrames().add(new TextFrame(CanonicalFrameType.CONTENT_TYPE, "" + rawGenre, 1));
                    }
                    input.seek(input.length() - 3L);
                    int trackNoMarker = input.readUnsignedByte();
                    int rawTrackNo = input.readUnsignedByte();
                    if (trackNoMarker == 0 && rawTrackNo != 0) {
                        tag.getFrames().add(new TextFrame(CanonicalFrameType.TRACK_NO, "" + rawTrackNo, 1));
                        commentFrame.setTotalFrameSize(28);
                        tag.setVersion(ID3Version.ID3v1r1);
                    }
                } else {
                    tag = null;
                }
            } else {
                tag = null;
            }
        }
        return tag;
    }

    public static String getField(RandomAccessFile input, int length) throws IOException {
        StringBuffer result = new StringBuffer();
        for (int index = 0; index < length; ++index) {
            int i = input.readUnsignedByte();
            if (i == 0) {
                Utils.skipOrThrow((DataInput)input, (int)(length - index - 1));
                break;
            }
            result.append((char)i);
        }
        return result.toString();
    }
}

