/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.digitalmediaserver.cuelib.id3.CommentFrame;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;
import org.digitalmediaserver.cuelib.util.Utils;

public class COMFrameReader
implements FrameReader {
    private final int headerSize;

    public COMFrameReader(int headerSize) {
        this.headerSize = headerSize;
    }

    @Override
    public CommentFrame readFrameBody(int size, InputStream input) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        String rawText;
        Charset charset;
        CommentFrame result = new CommentFrame();
        int encoding = input.read();
        switch (encoding) {
            case 0: {
                charset = Charset.forName("ISO-8859-1");
                break;
            }
            case 1: {
                charset = Charset.forName("UTF-16");
                break;
            }
            case 2: {
                charset = Charset.forName("UTF-16BE");
                break;
            }
            case 3: {
                charset = Charset.forName("UTF-8");
                break;
            }
            default: {
                throw new UnsupportedEncodingException("Encoding not supported: " + encoding);
            }
        }
        result.setCharset(charset);
        StringBuilder languageBuilder = new StringBuilder();
        languageBuilder.append((char)input.read()).append((char)input.read()).append((char)input.read());
        byte[] b = new byte[size - 4];
        Utils.readFully((InputStream)input, (byte[])b);
        String rawResult = new String(b, charset);
        int nulPosition = rawResult.indexOf(0);
        if (nulPosition < 0) {
            throw new MalformedFrameException("Description not terminated in COM frame.");
        }
        String description = rawResult.substring(0, nulPosition);
        String value = rawText.substring(0, (nulPosition = (rawText = rawResult.substring(nulPosition + 1)).indexOf(0)) == -1 ? rawText.length() : nulPosition);
        result.setLanguageCode(languageBuilder.toString());
        result.setDescription(description);
        result.setText(value);
        result.setTotalFrameSize(size + this.headerSize);
        return result;
    }
}

