/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.digitalmediaserver.cuelib.id3.InvolvedPeopleFrame;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;
import org.digitalmediaserver.cuelib.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPLFrameReader
implements FrameReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPLFrameReader.class);
    private final int headerSize;

    public IPLFrameReader(int headerSize) {
        this.headerSize = headerSize;
    }

    @Override
    public InvolvedPeopleFrame readFrameBody(int size, InputStream input) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        Charset charset;
        InvolvedPeopleFrame result = new InvolvedPeopleFrame(this.headerSize + size);
        int encoding = input.read();
        switch (encoding) {
            case 0: {
                charset = StandardCharsets.ISO_8859_1;
                break;
            }
            case 1: {
                charset = StandardCharsets.UTF_16;
                break;
            }
            case 2: {
                charset = StandardCharsets.UTF_16BE;
                break;
            }
            case 3: {
                charset = StandardCharsets.UTF_8;
                break;
            }
            default: {
                throw new UnsupportedEncodingException("Encoding not supported: " + encoding);
            }
        }
        LOGGER.trace("Reading InvolvedPeopleFrame with charset {}", (Object)charset);
        result.setCharset(charset);
        byte[] b = new byte[size - 1];
        Utils.readFully((InputStream)input, (byte[])b);
        String rawValue = new String(b, charset);
        int startPosition = 0;
        boolean atInvolvement = true;
        InvolvedPeopleFrame.InvolvedPerson involvedPerson = null;
        while (startPosition < rawValue.length()) {
            int nulPosition = rawValue.indexOf(0, startPosition);
            int endPosition = nulPosition == -1 ? rawValue.length() : nulPosition;
            String value = rawValue.substring(startPosition, endPosition);
            if (atInvolvement) {
                involvedPerson = new InvolvedPeopleFrame.InvolvedPerson();
                involvedPerson.setInvolvement(value);
                atInvolvement = false;
            } else if (involvedPerson != null) {
                involvedPerson.setInvolvee(value);
                result.getInvolvedPeopleList().add(involvedPerson);
                involvedPerson = null;
                atInvolvement = true;
            }
            startPosition = endPosition + 1;
        }
        if (involvedPerson != null) {
            LOGGER.warn("Encountered ID3v2 involvement ({}) without involvee", (Object)involvedPerson.getInvolvement());
            involvedPerson.setInvolvee("");
            result.getInvolvedPeopleList().add(involvedPerson);
        }
        return result;
    }
}

