/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.digitalmediaserver.cuelib.id3.ITunesPodcastFrame;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;

public class ITunesPodcastFrameReader
implements FrameReader {
    private final int headerSize;

    public ITunesPodcastFrameReader(int headerSize) {
        this.headerSize = headerSize;
    }

    @Override
    public ITunesPodcastFrame readFrameBody(int size, InputStream input) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        ITunesPodcastFrame result = new ITunesPodcastFrame(this.headerSize + size);
        StringBuilder payloadBuilder = new StringBuilder();
        for (int index = 0; index < 4; ++index) {
            payloadBuilder.append(Integer.toHexString(input.read()));
        }
        result.setPayload(payloadBuilder.toString());
        return result;
    }
}

