/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.digitalmediaserver.cuelib.id3.MusicCDIdentifierFrame;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;

public class MCIFrameReader
implements FrameReader {
    private final int headerSize;

    public MCIFrameReader(int headerSize) {
        this.headerSize = headerSize;
    }

    @Override
    public MusicCDIdentifierFrame readFrameBody(int size, InputStream input) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        MusicCDIdentifierFrame result = new MusicCDIdentifierFrame();
        result.setTotalFrameSize(size + this.headerSize);
        StringBuilder hexBuilder = new StringBuilder();
        for (int index = 0; index < size; ++index) {
            hexBuilder.append(Integer.toHexString(input.read()));
        }
        result.setHexTOC(hexBuilder.toString());
        return result;
    }
}

