/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.digitalmediaserver.cuelib.id3.PictureFrame;
import org.digitalmediaserver.cuelib.id3.io.ByteCountInputStream;
import org.digitalmediaserver.cuelib.id3.util.FieldReader;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;
import org.digitalmediaserver.cuelib.util.Utils;

public class PICFrameReader
implements FrameReader {
    private final int headerSize;
    private int imageTypeSize = -1;

    public PICFrameReader(int headerSize) {
        this.headerSize = headerSize;
    }

    public PICFrameReader(int headerSize, boolean v2r00Mode) {
        this.headerSize = headerSize;
        this.imageTypeSize = 3;
    }

    @Override
    public PictureFrame readFrameBody(int size, InputStream input) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        try (ByteCountInputStream countingInput = new ByteCountInputStream(input);){
            Charset charset;
            PictureFrame result = new PictureFrame();
            result.setTotalFrameSize(size + this.headerSize);
            int encoding = countingInput.read();
            switch (encoding) {
                case 0: {
                    charset = StandardCharsets.ISO_8859_1;
                    break;
                }
                case 1: {
                    charset = StandardCharsets.UTF_16;
                    break;
                }
                case 2: {
                    charset = StandardCharsets.UTF_16BE;
                    break;
                }
                case 3: {
                    charset = StandardCharsets.UTF_8;
                    break;
                }
                default: {
                    throw new UnsupportedEncodingException("Encoding not supported: " + encoding);
                }
            }
            result.setCharset(charset);
            if (this.imageTypeSize > 0) {
                result.setImageType(FieldReader.readField(countingInput, this.imageTypeSize, Charset.forName("ISO-8859-1")));
            } else {
                result.setImageType(FieldReader.readUntilNul(countingInput, size - 1, Charset.forName("ISO-8859-1")));
            }
            result.setPictureNumber(countingInput.read());
            result.setDescription(FieldReader.readUntilNul(countingInput, size, charset));
            byte[] imageData = new byte[size - (int)countingInput.getBytesRead()];
            Utils.readFully((InputStream)countingInput, (byte[])imageData);
            result.setImageData(imageData);
            PictureFrame pictureFrame = result;
            return pictureFrame;
        }
    }
}

