/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.digitalmediaserver.cuelib.id3.UserDefinedTextFrame;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;
import org.digitalmediaserver.cuelib.util.Utils;

public class TXXFrameReader
implements FrameReader {
    private final int headerSize;

    public TXXFrameReader(int headerSize) {
        this.headerSize = headerSize;
    }

    @Override
    public UserDefinedTextFrame readFrameBody(int size, InputStream input) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        String rawValue;
        Charset charset;
        UserDefinedTextFrame result = new UserDefinedTextFrame();
        result.setTotalFrameSize(size + this.headerSize);
        int encoding = input.read();
        switch (encoding) {
            case 0: {
                charset = Charset.forName("ISO-8859-1");
                break;
            }
            case 1: {
                charset = Charset.forName("UTF-16");
                break;
            }
            case 2: {
                charset = Charset.forName("UTF-16BE");
                break;
            }
            case 3: {
                charset = Charset.forName("UTF-8");
                break;
            }
            default: {
                throw new UnsupportedEncodingException("Encoding not supported: " + encoding);
            }
        }
        result.setCharset(charset);
        byte[] b = new byte[size - 1];
        Utils.readFully((InputStream)input, (byte[])b);
        String rawResult = new String(b, charset);
        int nulPosition = rawResult.indexOf(0);
        if (nulPosition < 0) {
            throw new MalformedFrameException("Description not terminated in TXX frame.");
        }
        String description = rawResult.substring(0, nulPosition);
        String value = rawValue.substring(0, (nulPosition = (rawValue = rawResult.substring(nulPosition + 1)).indexOf(0)) == -1 ? rawValue.length() : nulPosition);
        result.setDescription(description);
        result.setText(value);
        return result;
    }
}

