/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.digitalmediaserver.cuelib.id3.CanonicalFrameType;
import org.digitalmediaserver.cuelib.id3.TextFrame;
import org.digitalmediaserver.cuelib.id3.util.FieldReader;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;

public class TextFrameReader
implements FrameReader {
    private final CanonicalFrameType canonicalFrameType;
    private final int headerSize;

    public TextFrameReader(CanonicalFrameType canonicalFrameType, int headerSize) {
        this.canonicalFrameType = canonicalFrameType;
        this.headerSize = headerSize;
    }

    @Override
    public TextFrame readFrameBody(int size, InputStream input) throws IOException, UnsupportedEncodingException {
        return this.readFrameBody(null, size, input);
    }

    public TextFrame readFrameBody(String additionalTypeInfo, int size, InputStream input) throws IOException, UnsupportedEncodingException {
        Charset charset;
        TextFrame result = new TextFrame(this.canonicalFrameType);
        int encoding = input.read();
        switch (encoding) {
            case 0: {
                charset = StandardCharsets.ISO_8859_1;
                break;
            }
            case 1: {
                charset = StandardCharsets.UTF_16;
                break;
            }
            case 2: {
                charset = StandardCharsets.UTF_16BE;
                break;
            }
            case 3: {
                charset = StandardCharsets.UTF_8;
                break;
            }
            default: {
                throw new UnsupportedEncodingException("Encoding not supported: " + encoding);
            }
        }
        result.setCharset(charset);
        result.setText(FieldReader.readField(input, size - 1, charset));
        result.setTotalFrameSize(size + this.headerSize);
        if (additionalTypeInfo != null) {
            result.setAdditionalTypeInfo(additionalTypeInfo);
        }
        return result;
    }
}

