/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.digitalmediaserver.cuelib.id3.UniqueFileIdentifierFrame;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;

public class UFIFrameReader
implements FrameReader {
    private final int headerSize;

    public UFIFrameReader(int headerSize) {
        this.headerSize = headerSize;
    }

    @Override
    public UniqueFileIdentifierFrame readFrameBody(int size, InputStream input) throws IOException, UnsupportedEncodingException {
        UniqueFileIdentifierFrame result = new UniqueFileIdentifierFrame();
        result.setTotalFrameSize(size + this.headerSize);
        StringBuilder owner = new StringBuilder();
        ArrayList<Integer> identifier = new ArrayList<Integer>();
        boolean haveNul = false;
        for (int index = 0; index < size; ++index) {
            int i = input.read();
            if (haveNul) {
                identifier.add(i);
                continue;
            }
            if (i == 0) {
                haveNul = true;
                continue;
            }
            owner.append((char)i);
        }
        result.setOwnerIdentifier(owner.toString());
        StringBuilder hexIdentifier = new StringBuilder();
        for (Integer i : identifier) {
            hexIdentifier.append(Integer.toHexString(i));
        }
        result.setHexIdentifier(hexIdentifier.toString());
        return result;
    }
}

