/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.digitalmediaserver.cuelib.id3.CanonicalFrameType;
import org.digitalmediaserver.cuelib.id3.URLFrame;
import org.digitalmediaserver.cuelib.id3.util.FieldReader;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;

public class URLFrameReader
implements FrameReader {
    private final CanonicalFrameType canonicalFrameType;
    private final int headerSize;

    public URLFrameReader(CanonicalFrameType canonicalFrameType, int headerSize) {
        this.canonicalFrameType = canonicalFrameType;
        this.headerSize = headerSize;
    }

    @Override
    public URLFrame readFrameBody(int size, InputStream input) throws IOException, UnsupportedEncodingException {
        return this.readFrameBody(null, size, input);
    }

    public URLFrame readFrameBody(String additionalTypeInfo, int size, InputStream input) throws IOException, UnsupportedEncodingException {
        URLFrame result = new URLFrame(this.canonicalFrameType);
        result.setTotalFrameSize(size + this.headerSize);
        input.read();
        result.setUrl(FieldReader.readField(input, size, Charset.forName("ISO-8859-1")));
        if (additionalTypeInfo != null) {
            result.setAdditionalTypeInfo(additionalTypeInfo);
        }
        return result;
    }
}

