/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UnsynchedInputStream
extends FilterInputStream {
    public UnsynchedInputStream(InputStream in) {
        super(new PushbackInputStream(in, 1));
    }

    @Override
    public int read() throws IOException {
        int c2;
        int c1 = this.in.read();
        if (c1 == 255 && (c2 = this.in.read()) != 0) {
            ((PushbackInputStream)this.in).unread(c2);
        }
        return c1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        for (int index = 0; index < len; ++index) {
            int i = this.read();
            if (i == -1) {
                if (index > 0) {
                    return index;
                }
                return -1;
            }
            b[off + index] = (byte)i;
        }
        return len;
    }

    @Override
    public int available() throws IOException {
        return this.in.available() / 2;
    }

    @Override
    public long skip(long n) throws IOException {
        for (long index = 0L; index < n; ++index) {
            int i = this.read();
            if (i != -1) continue;
            return index;
        }
        return n;
    }
}

