/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.digitalmediaserver.cuelib.id3.UserDefinedURLFrame;
import org.digitalmediaserver.cuelib.id3.util.FieldReader;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;

public class WXXFrameReader
implements FrameReader {
    private final int headerSize;

    public WXXFrameReader(int headerSize) {
        this.headerSize = headerSize;
    }

    @Override
    public UserDefinedURLFrame readFrameBody(int size, InputStream input) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        int charLength;
        Charset charset;
        UserDefinedURLFrame result = new UserDefinedURLFrame();
        result.setTotalFrameSize(size + this.headerSize);
        int encoding = input.read();
        switch (encoding) {
            case 0: {
                charset = StandardCharsets.ISO_8859_1;
                charLength = 1;
                break;
            }
            case 1: {
                charset = StandardCharsets.UTF_16;
                charLength = 2;
                break;
            }
            case 2: {
                charset = StandardCharsets.UTF_16BE;
                charLength = 2;
                break;
            }
            case 3: {
                charset = StandardCharsets.UTF_8;
                charLength = 1;
                break;
            }
            default: {
                throw new UnsupportedEncodingException("Encoding not supported: " + encoding);
            }
        }
        result.setCharset(charset);
        String description = FieldReader.readUntilNul(input, size - 1, charset);
        result.setDescription(description);
        String url = FieldReader.readField(input, size - (description.length() + 1) * charLength - 1, charset);
        result.setUrl(url);
        return result;
    }
}

