/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2.r00;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.digitalmediaserver.cuelib.id3.CanonicalFrameType;
import org.digitalmediaserver.cuelib.id3.ID3Tag;
import org.digitalmediaserver.cuelib.id3.v2.COMFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.IPLFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.ITunesPodcastFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.MCIFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.PICFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.TXXFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.TextFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.UFIFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.URLFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;
import org.digitalmediaserver.cuelib.id3.v2.WXXFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.r00.FrameDictionary;
import org.digitalmediaserver.cuelib.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FramesReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FramesReader.class);
    private static FrameDictionary frameDictionary = new FrameDictionary();
    private static Map<String, FrameReader> frameReaders = new HashMap<String, FrameReader>();
    private static final int FRAME_HEADER_LENGTH = 6;

    private static void putTextFrameReader(String frameName) {
        frameReaders.put(frameName, new TextFrameReader(frameDictionary.getCanonicalFrameType(frameName), 6));
    }

    private static void putURLFrameReader(String frameName) {
        frameReaders.put(frameName, new URLFrameReader(frameDictionary.getCanonicalFrameType(frameName), 6));
    }

    public int readNextFrame(ID3Tag tag, InputStream input) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        StringBuilder frameNameBuilder = new StringBuilder(3);
        frameNameBuilder.append((char)input.read());
        frameNameBuilder.append((char)input.read());
        frameNameBuilder.append((char)input.read());
        String frameName = frameNameBuilder.toString();
        int frameSize = input.read() * 65536 + input.read() * 256 + input.read();
        FrameReader reader = frameReaders.get(frameName);
        if (reader == null) {
            if ("\u0000\u0000\u0000".equals(frameName)) {
                return 6;
            }
            if (frameName.charAt(0) == 'T') {
                LOGGER.warn("Encountered unknown text frame: \"{}\"", (Object)frameName);
                tag.getFrames().add(new TextFrameReader(CanonicalFrameType.USER_DEFINED_TEXT, 6).readFrameBody(frameName, frameSize, input));
            } else if (frameName.charAt(0) == 'W') {
                LOGGER.warn("Encountered unknown URL frame: \"{}\"", (Object)frameName);
                tag.getFrames().add(new URLFrameReader(CanonicalFrameType.USER_DEFINED_URL, 6).readFrameBody(frameName, frameSize, input));
            } else {
                LOGGER.warn("Encountered unsupported frame type: \"{}\" of length {}", (Object)frameName, (Object)frameSize);
                Utils.skipOrThrow((InputStream)input, (long)frameSize);
            }
        } else {
            tag.getFrames().add(reader.readFrameBody(frameSize, input));
        }
        return frameSize + 6;
    }

    public void readFrames(ID3Tag tag, InputStream input, int length) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        int bytesLeft = length;
        while (bytesLeft >= 6) {
            int bytesRead = this.readNextFrame(tag, input);
            bytesLeft -= bytesRead;
            if (bytesRead != 6) continue;
            Utils.skipOrThrow((InputStream)input, (long)bytesLeft);
            bytesLeft = 0;
        }
        Utils.skipOrThrow((InputStream)input, (long)bytesLeft);
    }

    static {
        frameReaders.put("UFI", new UFIFrameReader(6));
        FramesReader.putTextFrameReader("TT1");
        FramesReader.putTextFrameReader("TT2");
        FramesReader.putTextFrameReader("TT3");
        FramesReader.putTextFrameReader("TP1");
        FramesReader.putTextFrameReader("TP2");
        FramesReader.putTextFrameReader("TP3");
        FramesReader.putTextFrameReader("TP4");
        FramesReader.putTextFrameReader("TCM");
        FramesReader.putTextFrameReader("TXT");
        FramesReader.putTextFrameReader("TLA");
        FramesReader.putTextFrameReader("TCO");
        FramesReader.putTextFrameReader("TDS");
        FramesReader.putTextFrameReader("TAL");
        FramesReader.putTextFrameReader("TPA");
        FramesReader.putTextFrameReader("TRK");
        FramesReader.putTextFrameReader("TRC");
        FramesReader.putTextFrameReader("TYE");
        FramesReader.putTextFrameReader("TDA");
        FramesReader.putTextFrameReader("TIM");
        FramesReader.putTextFrameReader("TRD");
        FramesReader.putTextFrameReader("TMT");
        FramesReader.putTextFrameReader("TFT");
        FramesReader.putTextFrameReader("TBP");
        FramesReader.putTextFrameReader("TCR");
        FramesReader.putTextFrameReader("TPB");
        FramesReader.putTextFrameReader("TEN");
        FramesReader.putTextFrameReader("TSS");
        FramesReader.putTextFrameReader("TOF");
        FramesReader.putTextFrameReader("TLE");
        FramesReader.putTextFrameReader("TSI");
        FramesReader.putTextFrameReader("TDY");
        FramesReader.putTextFrameReader("TKE");
        FramesReader.putTextFrameReader("TOT");
        FramesReader.putTextFrameReader("TOA");
        FramesReader.putTextFrameReader("TOL");
        FramesReader.putTextFrameReader("TOR");
        FramesReader.putTextFrameReader("TID");
        FramesReader.putTextFrameReader("TCT");
        FramesReader.putTextFrameReader("TDR");
        FramesReader.putTextFrameReader("TKW");
        frameReaders.put("TXX", new TXXFrameReader(6));
        FramesReader.putURLFrameReader("WAF");
        FramesReader.putURLFrameReader("WAR");
        FramesReader.putURLFrameReader("WAS");
        FramesReader.putURLFrameReader("WCM");
        FramesReader.putURLFrameReader("WCP");
        FramesReader.putURLFrameReader("WPB");
        FramesReader.putTextFrameReader("WFD");
        frameReaders.put("WXX", new WXXFrameReader(6));
        frameReaders.put("IPL", new IPLFrameReader(6));
        frameReaders.put("MCI", new MCIFrameReader(6));
        frameReaders.put("COM", new COMFrameReader(6));
        frameReaders.put("PIC", new PICFrameReader(6, true));
        frameReaders.put("PCS", new ITunesPodcastFrameReader(6));
    }
}

