/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2.r00;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.digitalmediaserver.cuelib.id3.AbstractID3v2Reader;
import org.digitalmediaserver.cuelib.id3.ID3Tag;
import org.digitalmediaserver.cuelib.id3.ID3Version;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;
import org.digitalmediaserver.cuelib.id3.v2.UnsynchedInputStream;
import org.digitalmediaserver.cuelib.id3.v2.r00.FramesReader;

public class ID3v2r00Reader
extends AbstractID3v2Reader {
    @Override
    protected boolean isVersionValid(int majorVersion, int revision) {
        return majorVersion == 2 && revision == 0;
    }

    @Override
    public ID3Tag read(File file) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        ID3Tag tag = new ID3Tag();
        try (FileInputStream input = new FileInputStream(file);){
            if (input.read() == 73 && input.read() == 68 && input.read() == 51) {
                int majorVersion = input.read();
                int revision = input.read();
                if (majorVersion == 2 && revision == 0) {
                    tag.setVersion(ID3Version.ID3v2r2);
                    tag.setRevision(0);
                    int flags = input.read();
                    boolean unsyncUsed = (flags & 0x80) == 128;
                    tag.getFlags().setProperty("unsync_used", Boolean.toString(unsyncUsed));
                    boolean compressionUsed = (flags & 0x40) == 64;
                    tag.getFlags().setProperty("compression_used", Boolean.toString(compressionUsed));
                    int size = 0;
                    for (int index = 0; index < 4; ++index) {
                        int sizeByte = input.read();
                        if (sizeByte >= 128) {
                            size = -1;
                            break;
                        }
                        size = size * 128 + sizeByte;
                    }
                    if (size >= 0) {
                        tag.setDeclaredSize(size);
                        InputStream frameInputStream = unsyncUsed ? new UnsynchedInputStream(input) : input;
                        FramesReader frameReader = new FramesReader();
                        frameReader.readFrames(tag, frameInputStream, size);
                    } else {
                        tag = null;
                    }
                } else {
                    tag = null;
                }
            } else {
                tag = null;
            }
        }
        return tag;
    }
}

