/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2.r30;

import java.util.HashMap;
import java.util.Map;
import org.digitalmediaserver.cuelib.id3.CanonicalFrameType;

public class FrameDictionary {
    private static Map<String, CanonicalFrameType> nameToType = new HashMap<String, CanonicalFrameType>();
    private static Map<CanonicalFrameType, String> typeToName = new HashMap<CanonicalFrameType, String>();

    private static void addToDictionary(String name, CanonicalFrameType canonicalFrameType) {
        nameToType.put(name, canonicalFrameType);
        typeToName.put(canonicalFrameType, name);
    }

    public CanonicalFrameType getCanonicalFrameType(String name) {
        return nameToType.get(name);
    }

    public String getName(CanonicalFrameType canonicalFrameType) {
        return typeToName.get((Object)canonicalFrameType);
    }

    static {
        FrameDictionary.addToDictionary("UFID", CanonicalFrameType.UNIQUE_FILE_IDENTIFIER);
        FrameDictionary.addToDictionary("TIT1", CanonicalFrameType.CONTENT_GROUP_DESCRIPTION);
        FrameDictionary.addToDictionary("TIT2", CanonicalFrameType.TITLE);
        FrameDictionary.addToDictionary("TIT3", CanonicalFrameType.SUBTITLE);
        FrameDictionary.addToDictionary("TPE1", CanonicalFrameType.PERFORMER);
        FrameDictionary.addToDictionary("TPE2", CanonicalFrameType.ACCOMPANYING_PERFORMER);
        FrameDictionary.addToDictionary("TPE3", CanonicalFrameType.CONDUCTOR);
        FrameDictionary.addToDictionary("TPE4", CanonicalFrameType.MODIFIED_BY);
        FrameDictionary.addToDictionary("TCOM", CanonicalFrameType.COMPOSERS);
        FrameDictionary.addToDictionary("TEXT", CanonicalFrameType.TEXT_WRITERS);
        FrameDictionary.addToDictionary("TLAN", CanonicalFrameType.LANGUAGES);
        FrameDictionary.addToDictionary("TCON", CanonicalFrameType.CONTENT_TYPE);
        FrameDictionary.addToDictionary("TALB", CanonicalFrameType.ALBUM);
        FrameDictionary.addToDictionary("TPOS", CanonicalFrameType.PART);
        FrameDictionary.addToDictionary("TRCK", CanonicalFrameType.TRACK_NO);
        FrameDictionary.addToDictionary("TSRC", CanonicalFrameType.ISRC);
        FrameDictionary.addToDictionary("TYER", CanonicalFrameType.YEAR);
        FrameDictionary.addToDictionary("TDAT", CanonicalFrameType.DATE);
        FrameDictionary.addToDictionary("TGID", CanonicalFrameType.ITUNES_PODCAST_URL);
        FrameDictionary.addToDictionary("TIME", CanonicalFrameType.TIME);
        FrameDictionary.addToDictionary("TRDA", CanonicalFrameType.RECORDING_DATES);
        FrameDictionary.addToDictionary("TMED", CanonicalFrameType.MEDIA_TYPE);
        FrameDictionary.addToDictionary("TFLT", CanonicalFrameType.FILE_TYPE);
        FrameDictionary.addToDictionary("TBPM", CanonicalFrameType.BEATS_PER_MINUTE);
        FrameDictionary.addToDictionary("TCOP", CanonicalFrameType.COPYRIGHT);
        FrameDictionary.addToDictionary("TPUB", CanonicalFrameType.PUBLISHER);
        FrameDictionary.addToDictionary("TENC", CanonicalFrameType.ENCODER);
        FrameDictionary.addToDictionary("TSSE", CanonicalFrameType.ENCODER_EQUIPMENT_OR_SETTINGS);
        FrameDictionary.addToDictionary("TOFN", CanonicalFrameType.ORIGINAL_FILE_NAME);
        FrameDictionary.addToDictionary("TLEN", CanonicalFrameType.TRACK_LENGTH_MS);
        FrameDictionary.addToDictionary("TSIZ", CanonicalFrameType.TRACK_SIZE_BYTES);
        FrameDictionary.addToDictionary("TDES", CanonicalFrameType.ITUNES_PODCAST_DESCRIPTION);
        FrameDictionary.addToDictionary("TDLY", CanonicalFrameType.PLAYLIST_DELAY_MS);
        FrameDictionary.addToDictionary("TKEY", CanonicalFrameType.INITIAL_KEY);
        FrameDictionary.addToDictionary("TOAL", CanonicalFrameType.ORIGINAL_TITLE);
        FrameDictionary.addToDictionary("TOPE", CanonicalFrameType.ORIGINAL_ARTISTS);
        FrameDictionary.addToDictionary("TOLY", CanonicalFrameType.ORIGINAL_TEXT_WRITERS);
        FrameDictionary.addToDictionary("TORY", CanonicalFrameType.ORIGINAL_YEAR);
        FrameDictionary.addToDictionary("TOWN", CanonicalFrameType.OWNER);
        FrameDictionary.addToDictionary("TRSN", CanonicalFrameType.RADIO_STATION);
        FrameDictionary.addToDictionary("TRSO", CanonicalFrameType.RADIO_STATION_OWNER);
        FrameDictionary.addToDictionary("TCAT", CanonicalFrameType.ITUNES_PODCAST_CATEGORY);
        FrameDictionary.addToDictionary("TDRL", CanonicalFrameType.ITUNES_PODCAST_RELEASE_TIME);
        FrameDictionary.addToDictionary("TKWD", CanonicalFrameType.ITUNES_PODCAST_KEYWORDS);
        FrameDictionary.addToDictionary("TXXX", CanonicalFrameType.CUSTOM_TEXT);
        FrameDictionary.addToDictionary("WOAF", CanonicalFrameType.OFFICIAL_AUDIO_FILE_WEBPAGE);
        FrameDictionary.addToDictionary("WOAR", CanonicalFrameType.OFFICIAL_ARTIST_WEBPAGE);
        FrameDictionary.addToDictionary("WOAS", CanonicalFrameType.OFFICIAL_AUDIO_SOURCE_WEBPAGE);
        FrameDictionary.addToDictionary("WCOM", CanonicalFrameType.COMMERCIAL_INFORMATION_URL);
        FrameDictionary.addToDictionary("WCOP", CanonicalFrameType.COPYRIGHT_OR_LEGAL_INFORMATION_URL);
        FrameDictionary.addToDictionary("WFED", CanonicalFrameType.ITUNES_PODCAST_FEED_URL);
        FrameDictionary.addToDictionary("WPUB", CanonicalFrameType.OFFICIAL_PUBLISHER_WEBPAGE);
        FrameDictionary.addToDictionary("WORS", CanonicalFrameType.OFFICIAL_RADIO_STATION_WEBPAGE);
        FrameDictionary.addToDictionary("WPAY", CanonicalFrameType.OFFICIAL_PAYMENT_WEBPAGE);
        FrameDictionary.addToDictionary("WXXX", CanonicalFrameType.CUSTOM_WEBPAGE);
        FrameDictionary.addToDictionary("IPLS", CanonicalFrameType.INVOLVED_PEOPLE_LIST);
        FrameDictionary.addToDictionary("MCDI", CanonicalFrameType.MUSIC_CD_IDENTIFIER);
        FrameDictionary.addToDictionary("COMM", CanonicalFrameType.COMMENT);
        FrameDictionary.addToDictionary("APIC", CanonicalFrameType.PICTURE);
        FrameDictionary.addToDictionary("PCST", CanonicalFrameType.ITUNES_PODCAST);
        FrameDictionary.addToDictionary("XYZX", CanonicalFrameType.UNRECOGNIZED_FRAME);
    }
}

