/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2.r30;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.digitalmediaserver.cuelib.id3.AbstractID3v2Reader;
import org.digitalmediaserver.cuelib.id3.ID3Tag;
import org.digitalmediaserver.cuelib.id3.ID3Version;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;
import org.digitalmediaserver.cuelib.id3.v2.UnsynchedInputStream;
import org.digitalmediaserver.cuelib.id3.v2.r30.FramesReader;

public class ID3v2r30Reader
extends AbstractID3v2Reader {
    @Override
    protected boolean isVersionValid(int majorVersion, int revision) {
        return majorVersion == 3 && revision == 0;
    }

    @Override
    public ID3Tag read(File file) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        ID3Tag tag = new ID3Tag();
        try (FileInputStream input = new FileInputStream(file);){
            if (input.read() == 73 && input.read() == 68 && input.read() == 51) {
                int majorVersion = input.read();
                int revision = input.read();
                if (majorVersion == 3 && revision == 0) {
                    tag.setVersion(ID3Version.ID3v2r3);
                    tag.setRevision(0);
                    int flags = input.read();
                    boolean unsyncUsed = (flags & 0x80) == 128;
                    tag.getFlags().setProperty("unsync_used", Boolean.toString(unsyncUsed));
                    boolean extendedHeaderUsed = (flags & 0x40) == 64;
                    boolean experimental = (flags & 0x20) == 32;
                    tag.getFlags().setProperty("experimental", Boolean.toString(experimental));
                    int size = 0;
                    for (int index = 0; index < 4; ++index) {
                        int sizeByte = input.read();
                        if (sizeByte >= 128) {
                            size = -1;
                            break;
                        }
                        size = size * 128 + sizeByte;
                    }
                    if (size >= 0) {
                        tag.setDeclaredSize(size);
                        if (extendedHeaderUsed) {
                            long extendedHeaderSize = 0L;
                            for (int index = 0; index < 4; ++index) {
                                extendedHeaderSize = extendedHeaderSize * 256L + (long)input.read();
                            }
                            tag.getFlags().put("extended_header_size", Long.toString(extendedHeaderSize));
                            int extendedFlags = input.read() << 8 | input.read();
                            boolean crcPresent = (extendedFlags & 0x10000) == 65536;
                            long paddingSize = 0L;
                            for (int index = 0; index < 4; ++index) {
                                paddingSize = paddingSize * 256L + (long)input.read();
                            }
                            tag.getFlags().put("padding_size", Long.toString(paddingSize));
                            if (crcPresent) {
                                StringBuilder hexBuilder = new StringBuilder();
                                for (int index = 0; index < 4; ++index) {
                                    hexBuilder.append(Integer.toHexString(input.read()));
                                }
                                tag.getFlags().put("crc32_hex", hexBuilder.toString());
                            }
                        }
                        InputStream frameInputStream = unsyncUsed ? new UnsynchedInputStream(input) : input;
                        FramesReader frameReader = new FramesReader();
                        frameReader.readFrames(tag, frameInputStream, size);
                    } else {
                        tag = null;
                    }
                } else {
                    tag = null;
                }
            } else {
                tag = null;
            }
        }
        return tag;
    }
}

