/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2.r40;

import java.util.HashMap;
import java.util.Map;
import org.digitalmediaserver.cuelib.id3.CanonicalFrameType;

public class FrameDictionary {
    private static Map<String, CanonicalFrameType> nameToType = new HashMap<String, CanonicalFrameType>();
    private static Map<CanonicalFrameType, String> typeToName = new HashMap<CanonicalFrameType, String>();

    private static void addToDictionary(String name, CanonicalFrameType canonicalFrameType) {
        nameToType.put(name, canonicalFrameType);
        typeToName.put(canonicalFrameType, name);
    }

    public CanonicalFrameType getCanonicalFrameType(String name) {
        return nameToType.get(name);
    }

    public String getName(CanonicalFrameType canonicalFrameType) {
        return typeToName.get((Object)canonicalFrameType);
    }

    static {
        FrameDictionary.addToDictionary("APIC", CanonicalFrameType.PICTURE);
        FrameDictionary.addToDictionary("COMM", CanonicalFrameType.COMMENT);
        FrameDictionary.addToDictionary("MCDI", CanonicalFrameType.MUSIC_CD_IDENTIFIER);
        FrameDictionary.addToDictionary("PCST", CanonicalFrameType.ITUNES_PODCAST);
        FrameDictionary.addToDictionary("TALB", CanonicalFrameType.ALBUM);
        FrameDictionary.addToDictionary("TBPM", CanonicalFrameType.BEATS_PER_MINUTE);
        FrameDictionary.addToDictionary("TCAT", CanonicalFrameType.ITUNES_PODCAST_CATEGORY);
        FrameDictionary.addToDictionary("TCOM", CanonicalFrameType.COMPOSERS);
        FrameDictionary.addToDictionary("TCON", CanonicalFrameType.CONTENT_TYPE);
        FrameDictionary.addToDictionary("TCOP", CanonicalFrameType.COPYRIGHT);
        FrameDictionary.addToDictionary("TDEN", CanonicalFrameType.ENCODING_TIMESTAMP);
        FrameDictionary.addToDictionary("TDES", CanonicalFrameType.ITUNES_PODCAST_DESCRIPTION);
        FrameDictionary.addToDictionary("TDLY", CanonicalFrameType.PLAYLIST_DELAY_MS);
        FrameDictionary.addToDictionary("TDOR", CanonicalFrameType.ORIGINAL_RELEASE_TIME);
        FrameDictionary.addToDictionary("TDRC", CanonicalFrameType.RECORDING_TIME);
        FrameDictionary.addToDictionary("TDRL", CanonicalFrameType.ITUNES_PODCAST_RELEASE_TIME);
        FrameDictionary.addToDictionary("TDTG", CanonicalFrameType.TAGGING_TIMESTAMP);
        FrameDictionary.addToDictionary("TENC", CanonicalFrameType.ENCODER);
        FrameDictionary.addToDictionary("TEXT", CanonicalFrameType.TEXT_WRITERS);
        FrameDictionary.addToDictionary("TFLT", CanonicalFrameType.FILE_TYPE);
        FrameDictionary.addToDictionary("TGID", CanonicalFrameType.ITUNES_PODCAST_URL);
        FrameDictionary.addToDictionary("TIPL", CanonicalFrameType.INVOLVED_PEOPLE_LIST);
        FrameDictionary.addToDictionary("TIT1", CanonicalFrameType.CONTENT_GROUP_DESCRIPTION);
        FrameDictionary.addToDictionary("TIT2", CanonicalFrameType.TITLE);
        FrameDictionary.addToDictionary("TIT3", CanonicalFrameType.SUBTITLE);
        FrameDictionary.addToDictionary("TKEY", CanonicalFrameType.INITIAL_KEY);
        FrameDictionary.addToDictionary("TKWD", CanonicalFrameType.ITUNES_PODCAST_KEYWORDS);
        FrameDictionary.addToDictionary("TLAN", CanonicalFrameType.LANGUAGES);
        FrameDictionary.addToDictionary("TLEN", CanonicalFrameType.TRACK_LENGTH_MS);
        FrameDictionary.addToDictionary("TMCL", CanonicalFrameType.MUSICIAN_CREDITS_LIST);
        FrameDictionary.addToDictionary("TMED", CanonicalFrameType.MEDIA_TYPE);
        FrameDictionary.addToDictionary("TMOO", CanonicalFrameType.MOOD);
        FrameDictionary.addToDictionary("TOAL", CanonicalFrameType.ORIGINAL_TITLE);
        FrameDictionary.addToDictionary("TOFN", CanonicalFrameType.ORIGINAL_FILE_NAME);
        FrameDictionary.addToDictionary("TOLY", CanonicalFrameType.ORIGINAL_TEXT_WRITERS);
        FrameDictionary.addToDictionary("TOPE", CanonicalFrameType.ORIGINAL_ARTISTS);
        FrameDictionary.addToDictionary("TOWN", CanonicalFrameType.OWNER);
        FrameDictionary.addToDictionary("TPE1", CanonicalFrameType.PERFORMER);
        FrameDictionary.addToDictionary("TPE2", CanonicalFrameType.ACCOMPANYING_PERFORMER);
        FrameDictionary.addToDictionary("TPE3", CanonicalFrameType.CONDUCTOR);
        FrameDictionary.addToDictionary("TPE4", CanonicalFrameType.MODIFIED_BY);
        FrameDictionary.addToDictionary("TPOS", CanonicalFrameType.PART);
        FrameDictionary.addToDictionary("TPRO", CanonicalFrameType.PRODUCED_NOTE);
        FrameDictionary.addToDictionary("TPUB", CanonicalFrameType.PUBLISHER);
        FrameDictionary.addToDictionary("TRCK", CanonicalFrameType.TRACK_NO);
        FrameDictionary.addToDictionary("TRSN", CanonicalFrameType.RADIO_STATION);
        FrameDictionary.addToDictionary("TRSO", CanonicalFrameType.RADIO_STATION_OWNER);
        FrameDictionary.addToDictionary("TSOA", CanonicalFrameType.ALBUM_SORT_ORDER);
        FrameDictionary.addToDictionary("TSOP", CanonicalFrameType.PERFORMER_SORT_ORDER);
        FrameDictionary.addToDictionary("TSOT", CanonicalFrameType.TITLE_SORT_ORDER);
        FrameDictionary.addToDictionary("TSRC", CanonicalFrameType.ISRC);
        FrameDictionary.addToDictionary("TSSE", CanonicalFrameType.ENCODER_EQUIPMENT_OR_SETTINGS);
        FrameDictionary.addToDictionary("TSSE", CanonicalFrameType.SET_SUBTITLE);
        FrameDictionary.addToDictionary("TXXX", CanonicalFrameType.CUSTOM_TEXT);
        FrameDictionary.addToDictionary("UFID", CanonicalFrameType.UNIQUE_FILE_IDENTIFIER);
        FrameDictionary.addToDictionary("WCOM", CanonicalFrameType.COMMERCIAL_INFORMATION_URL);
        FrameDictionary.addToDictionary("WCOP", CanonicalFrameType.COPYRIGHT_OR_LEGAL_INFORMATION_URL);
        FrameDictionary.addToDictionary("WFED", CanonicalFrameType.ITUNES_PODCAST_FEED_URL);
        FrameDictionary.addToDictionary("WOAF", CanonicalFrameType.OFFICIAL_AUDIO_FILE_WEBPAGE);
        FrameDictionary.addToDictionary("WOAR", CanonicalFrameType.OFFICIAL_ARTIST_WEBPAGE);
        FrameDictionary.addToDictionary("WOAS", CanonicalFrameType.OFFICIAL_AUDIO_SOURCE_WEBPAGE);
        FrameDictionary.addToDictionary("WORS", CanonicalFrameType.OFFICIAL_RADIO_STATION_WEBPAGE);
        FrameDictionary.addToDictionary("WPAY", CanonicalFrameType.OFFICIAL_PAYMENT_WEBPAGE);
        FrameDictionary.addToDictionary("WPUB", CanonicalFrameType.OFFICIAL_PUBLISHER_WEBPAGE);
        FrameDictionary.addToDictionary("WXXX", CanonicalFrameType.CUSTOM_WEBPAGE);
        FrameDictionary.addToDictionary("XYZX", CanonicalFrameType.UNRECOGNIZED_FRAME);
    }
}

