/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2.r40;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.digitalmediaserver.cuelib.id3.CanonicalFrameType;
import org.digitalmediaserver.cuelib.id3.ID3Frame;
import org.digitalmediaserver.cuelib.id3.ID3Tag;
import org.digitalmediaserver.cuelib.id3.v2.COMFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.FrameReader;
import org.digitalmediaserver.cuelib.id3.v2.ITunesPodcastFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.MCIFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.PICFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.TXXFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.TextFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.UFIFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.URLFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;
import org.digitalmediaserver.cuelib.id3.v2.WXXFrameReader;
import org.digitalmediaserver.cuelib.id3.v2.r40.FrameDictionary;
import org.digitalmediaserver.cuelib.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FramesReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FramesReader.class);
    private static FrameDictionary frameDictionary = new FrameDictionary();
    private static Map<String, FrameReader> frameReaders = new HashMap<String, FrameReader>();
    private static final int FRAME_HEADER_LENGTH = 10;
    public static final Set<String> DISCARD_WHEN_FILE_ALTERED = Collections.unmodifiableSet(new TreeSet<String>(Arrays.asList("ASPI", "AENC", "ETCO", "EQU2", "MLLT", "POSS", "SEEK", "SYLT", "SYTC", "RVA2", "TENC", "TLEN")));

    private static void putTextFrameReader(String frameName) {
        frameReaders.put(frameName, new TextFrameReader(frameDictionary.getCanonicalFrameType(frameName), 10));
    }

    private static void putURLFrameReader(String frameName) {
        frameReaders.put(frameName, new URLFrameReader(frameDictionary.getCanonicalFrameType(frameName), 10));
    }

    public int readNextFrame(ID3Tag tag, InputStream input) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        ID3Frame frame;
        FrameReader reader;
        boolean dataLengthIndicatorPresent;
        StringBuilder frameNameBuilder = new StringBuilder(4);
        frameNameBuilder.append((char)input.read());
        frameNameBuilder.append((char)input.read());
        frameNameBuilder.append((char)input.read());
        frameNameBuilder.append((char)input.read());
        String frameName = frameNameBuilder.toString();
        int frameSize = 0;
        for (int index = 0; index < 4; ++index) {
            int sizeByte = input.read();
            if (sizeByte >= 128) {
                frameSize = -1;
                break;
            }
            frameSize = frameSize * 128 + sizeByte;
        }
        if (frameSize < 0) {
            LOGGER.error("Illegal frame size!");
            return 8;
        }
        int flagsBytes = input.read() << 8 | input.read();
        HashMap<String, String> flags = new HashMap<String, String>();
        flags.put("preserve_frame_when_tag_altered", Boolean.toString((flagsBytes & 0x4000) == 16384));
        flags.put("preserve_frame_when_file_altered", Boolean.toString(DISCARD_WHEN_FILE_ALTERED.contains(frameName) || (flagsBytes & 0x2000) == 8192));
        flags.put("read_only", Boolean.toString((flagsBytes & 0x1000) == 4096));
        boolean containsGroupInformation = (flagsBytes & 0x40) == 64;
        boolean compressionUsed = (flagsBytes & 8) == 8;
        flags.put("compression_used", Boolean.toString(compressionUsed));
        boolean encryptionUsed = (flagsBytes & 4) == 4;
        boolean unsyncUsed = (flagsBytes & 2) == 2;
        flags.put("unsync_used", Boolean.toString(unsyncUsed));
        boolean bl = dataLengthIndicatorPresent = (flagsBytes & 1) == 1;
        if (containsGroupInformation) {
            int groupId = input.read();
            flags.put("group_id", Integer.toString(groupId));
        }
        if (encryptionUsed) {
            int encryptionMethodUsed = input.read();
            flags.put("encryption_method_used", Integer.toString(encryptionMethodUsed));
        }
        if (dataLengthIndicatorPresent) {
            int dataLength = input.read() * 0x100000 + input.read() * 8192 + input.read() * 64 + input.read();
            flags.put("data_length_indicator", Integer.toString(dataLength));
        }
        if ((reader = frameReaders.get(frameName.toString())) == null) {
            if ("\u0000\u0000\u0000\u0000".equals(frameName.toString())) {
                return 10;
            }
            if (frameName.charAt(0) == 'T') {
                LOGGER.warn("Encountered unknown text frame: \"{}\"", (Object)frameName);
                frame = new TextFrameReader(CanonicalFrameType.USER_DEFINED_TEXT, 10).readFrameBody(frameName, frameSize, input);
            } else if (frameName.charAt(0) == 'W') {
                LOGGER.warn("Encountered unknown URL frame: \"{}\"", (Object)frameName);
                frame = new URLFrameReader(CanonicalFrameType.USER_DEFINED_URL, 10).readFrameBody(frameName, frameSize, input);
            } else {
                LOGGER.warn("Encountered unsupported frame type: \"{}\" of length {}", (Object)frameName, (Object)frameSize);
                Utils.skipOrThrow((InputStream)input, (long)frameSize);
                frame = null;
            }
        } else {
            frame = reader.readFrameBody(frameSize, input);
        }
        if (frame != null) {
            frame.getFlags().putAll((Map<?, ?>)flags);
            tag.getFrames().add(frame);
        }
        return frameSize + 10;
    }

    public void readFrames(ID3Tag tag, InputStream input, long length) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        long bytesLeft = length;
        while (bytesLeft >= 10L) {
            long bytesRead = this.readNextFrame(tag, input);
            bytesLeft -= bytesRead;
            if (bytesRead != 10L) continue;
            Utils.skipOrThrow((InputStream)input, (long)bytesLeft);
            bytesLeft = 0L;
        }
        Utils.skipOrThrow((InputStream)input, (long)bytesLeft);
    }

    static {
        frameReaders.put("APIC", new PICFrameReader(10, false));
        frameReaders.put("COMM", new COMFrameReader(10));
        frameReaders.put("MCDI", new MCIFrameReader(10));
        frameReaders.put("PCST", new ITunesPodcastFrameReader(10));
        FramesReader.putTextFrameReader("TALB");
        FramesReader.putTextFrameReader("TBPM");
        FramesReader.putTextFrameReader("TCAT");
        FramesReader.putTextFrameReader("TCOM");
        FramesReader.putTextFrameReader("TCON");
        FramesReader.putTextFrameReader("TCOP");
        FramesReader.putTextFrameReader("TDEN");
        FramesReader.putTextFrameReader("TDES");
        FramesReader.putTextFrameReader("TDLR");
        FramesReader.putTextFrameReader("TDLY");
        FramesReader.putTextFrameReader("TDOR");
        FramesReader.putTextFrameReader("TDRC");
        FramesReader.putTextFrameReader("TDRL");
        FramesReader.putTextFrameReader("TDTG");
        FramesReader.putTextFrameReader("TENC");
        FramesReader.putTextFrameReader("TEXT");
        FramesReader.putTextFrameReader("TFLT");
        FramesReader.putTextFrameReader("TGID");
        FramesReader.putTextFrameReader("TIPL");
        FramesReader.putTextFrameReader("TIT1");
        FramesReader.putTextFrameReader("TIT2");
        FramesReader.putTextFrameReader("TIT3");
        FramesReader.putTextFrameReader("TKEY");
        FramesReader.putTextFrameReader("TKWD");
        FramesReader.putTextFrameReader("TLAN");
        FramesReader.putTextFrameReader("TLEN");
        FramesReader.putTextFrameReader("TMCL");
        FramesReader.putTextFrameReader("TMED");
        FramesReader.putTextFrameReader("TMOO");
        FramesReader.putTextFrameReader("TOAL");
        FramesReader.putTextFrameReader("TOFN");
        FramesReader.putTextFrameReader("TOLY");
        FramesReader.putTextFrameReader("TOPE");
        FramesReader.putTextFrameReader("TOWN");
        FramesReader.putTextFrameReader("TPE1");
        FramesReader.putTextFrameReader("TPE2");
        FramesReader.putTextFrameReader("TPE3");
        FramesReader.putTextFrameReader("TPE4");
        FramesReader.putTextFrameReader("TPOS");
        FramesReader.putTextFrameReader("TPRO");
        FramesReader.putTextFrameReader("TPUB");
        FramesReader.putTextFrameReader("TRCK");
        FramesReader.putTextFrameReader("TRSN");
        FramesReader.putTextFrameReader("TRSO");
        FramesReader.putTextFrameReader("TSOA");
        FramesReader.putTextFrameReader("TSOP");
        FramesReader.putTextFrameReader("TSOT");
        FramesReader.putTextFrameReader("TSRC");
        FramesReader.putTextFrameReader("TSSE");
        FramesReader.putTextFrameReader("TSST");
        frameReaders.put("TXXX", new TXXFrameReader(10));
        frameReaders.put("UFID", new UFIFrameReader(10));
        FramesReader.putURLFrameReader("WCOM");
        FramesReader.putURLFrameReader("WCOP");
        FramesReader.putTextFrameReader("WFED");
        FramesReader.putURLFrameReader("WOAF");
        FramesReader.putURLFrameReader("WOAR");
        FramesReader.putURLFrameReader("WOAS");
        FramesReader.putURLFrameReader("WORS");
        FramesReader.putURLFrameReader("WPAY");
        FramesReader.putURLFrameReader("WPUB");
        frameReaders.put("WXXX", new WXXFrameReader(10));
    }
}

