/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cuelib.id3.v2.r40;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.digitalmediaserver.cuelib.id3.AbstractID3v2Reader;
import org.digitalmediaserver.cuelib.id3.ID3Tag;
import org.digitalmediaserver.cuelib.id3.ID3Version;
import org.digitalmediaserver.cuelib.id3.v2.MalformedFrameException;
import org.digitalmediaserver.cuelib.id3.v2.UnsupportedEncodingException;
import org.digitalmediaserver.cuelib.id3.v2.UnsynchedInputStream;
import org.digitalmediaserver.cuelib.id3.v2.r40.FramesReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ID3v2r40Reader
extends AbstractID3v2Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ID3v2r40Reader.class);

    @Override
    protected boolean isVersionValid(int majorVersion, int revision) {
        return majorVersion == 4 && revision == 0;
    }

    @Override
    public ID3Tag read(File file) throws IOException, UnsupportedEncodingException, MalformedFrameException {
        ID3Tag tag = new ID3Tag();
        try (FileInputStream input = new FileInputStream(file);){
            if (input.read() == 73 && input.read() == 68 && input.read() == 51) {
                int majorVersion = input.read();
                int revision = input.read();
                if (majorVersion == 4 && revision == 0) {
                    tag.setVersion(ID3Version.ID3v2r4);
                    tag.setRevision(0);
                    int flags = input.read();
                    boolean unsyncUsed = (flags & 0x80) == 128;
                    tag.getFlags().setProperty("unsync_used", Boolean.toString(unsyncUsed));
                    boolean extendedHeaderUsed = (flags & 0x40) == 64;
                    boolean experimental = (flags & 0x20) == 32;
                    tag.getFlags().setProperty("experimental", Boolean.toString(experimental));
                    boolean footerPresent = (flags & 0x10) == 16;
                    tag.getFlags().setProperty("footer_present", Boolean.toString(footerPresent));
                    int size = 0;
                    for (int index = 0; index < 4; ++index) {
                        int sizeByte = input.read();
                        if (sizeByte >= 128) {
                            size = -1;
                            break;
                        }
                        size = size * 128 + sizeByte;
                    }
                    if (size >= 0) {
                        tag.setDeclaredSize(size);
                        if (extendedHeaderUsed) {
                            long extendedHeaderSize = 0L;
                            for (int index = 0; index < 4; ++index) {
                                int sizeByte = input.read();
                                if (sizeByte >= 128) {
                                    extendedHeaderSize = -1L;
                                    break;
                                }
                                extendedHeaderSize = extendedHeaderSize * 128L + (long)sizeByte;
                            }
                            if (extendedHeaderSize >= 6L) {
                                tag.getFlags().put("extended_header_size", Long.toString(extendedHeaderSize));
                                int numberOfFlagBytes = input.read();
                                if (numberOfFlagBytes == 1) {
                                    int updateFlagDataLength;
                                    int extendedFlags = input.read();
                                    boolean tagIsAnUpdate = (extendedFlags & 0x40) == 64;
                                    tag.getFlags().put("tag_is_update", Boolean.toString(tagIsAnUpdate));
                                    boolean crcPresent = (extendedFlags & 0x20) == 32;
                                    boolean tagRestrictionsSet = (extendedFlags & 0x10) == 16;
                                    LOGGER.debug("Tag restrictions set: {}", (Object)tagRestrictionsSet);
                                    if (tagIsAnUpdate && (updateFlagDataLength = input.read()) != 0) {
                                        LOGGER.warn("Invalid length for \"tag is an update\" flag encountered. Should be 0, but is {}", (Object)updateFlagDataLength);
                                    }
                                    if (crcPresent) {
                                        int crcLength = input.read();
                                        if (crcLength == 5) {
                                            long crc = input.read() << 28 | input.read() << 21 | input.read() << 14 | input.read() << 7 | input.read();
                                            tag.getFlags().put("crc32_hex", Long.toHexString(crc));
                                        } else {
                                            LOGGER.warn("Invalid length for CRC32_HEX flag encountered. Should be 5, but is {}", (Object)crcLength);
                                        }
                                    }
                                    if (tagRestrictionsSet) {
                                        int tagRestrictionsDataSize = input.read();
                                        if (tagRestrictionsDataSize == 1) {
                                            int restrictionsByte = input.read();
                                            int tagSizeRestrictions = (restrictionsByte & 0xC0) >> 6;
                                            int textEncodingRestrictions = (restrictionsByte & 0x20) >> 5;
                                            int textFieldSizeRestrictions = (restrictionsByte & 0x18) >> 3;
                                            int imageEncodingRestrictions = (restrictionsByte & 4) >> 2;
                                            int imageSizeRestrictions = restrictionsByte & 3;
                                            switch (tagSizeRestrictions) {
                                                case 0: {
                                                    LOGGER.debug("Tag size restriction: No more than 128 frames and 1 MB total tag size.");
                                                    break;
                                                }
                                                case 1: {
                                                    LOGGER.debug("Tag size restriction: No more than 64 frames and 128 KB total tag size.");
                                                    break;
                                                }
                                                case 2: {
                                                    LOGGER.debug("Tag size restriction: No more than 32 frames and 40 KB total tag size.");
                                                    break;
                                                }
                                                case 3: {
                                                    LOGGER.debug("Tag size restriction: No more than 32 frames and 4 KB total tag size.");
                                                    break;
                                                }
                                                default: {
                                                    LOGGER.debug("Unknown tag size restriction");
                                                }
                                            }
                                            switch (textEncodingRestrictions) {
                                                case 0: {
                                                    LOGGER.debug("Text encoding restriction: No restrictions.");
                                                    break;
                                                }
                                                case 1: {
                                                    LOGGER.debug("Text encoding restriction: Strings are only encoded with ISO-8859-1 [ISO-8859-1] or UTF-8 [UTF-8].");
                                                    break;
                                                }
                                                default: {
                                                    LOGGER.debug("Unknown encoding restriction");
                                                }
                                            }
                                            switch (textFieldSizeRestrictions) {
                                                case 0: {
                                                    LOGGER.debug("Text field size restriction: No restrictions.");
                                                    break;
                                                }
                                                case 1: {
                                                    LOGGER.debug("Text field size restriction: No string is longer than 1024 characters.");
                                                    break;
                                                }
                                                case 2: {
                                                    LOGGER.debug("Text field size restriction: No string is longer than 128 characters.");
                                                    break;
                                                }
                                                case 3: {
                                                    LOGGER.debug("Text field size restriction: No string is longer than 30 characters.");
                                                    break;
                                                }
                                                default: {
                                                    LOGGER.debug("Unknown field size restriction");
                                                }
                                            }
                                            switch (imageEncodingRestrictions) {
                                                case 0: {
                                                    LOGGER.debug("Image encoding restriction: No restrictions.");
                                                    break;
                                                }
                                                case 1: {
                                                    LOGGER.debug("Image encoding restriction: Images are encoded only with PNG [PNG] or JPEG [JFIF].");
                                                    break;
                                                }
                                                default: {
                                                    LOGGER.debug("Unknown image encoding restriction");
                                                }
                                            }
                                            switch (imageSizeRestrictions) {
                                                case 0: {
                                                    LOGGER.debug("Image size restriction: No restrictions.");
                                                    break;
                                                }
                                                case 1: {
                                                    LOGGER.debug("Image size restriction: All images are 256x256 pixels or smaller.");
                                                    break;
                                                }
                                                case 2: {
                                                    LOGGER.debug("Image size restriction: All images are 64x64 pixels or smaller.");
                                                    break;
                                                }
                                                case 3: {
                                                    LOGGER.debug("Image size restriction: All images are exactly 64x64 pixels, unless required otherwise.");
                                                    break;
                                                }
                                                default: {
                                                    LOGGER.debug("Unknown image size restriction");
                                                    break;
                                                }
                                            }
                                        } else {
                                            LOGGER.warn("Invalid length for tag restrictions flag encountered. Should be 1, but is {}", (Object)tagRestrictionsDataSize);
                                        }
                                    }
                                } else {
                                    LOGGER.warn("Number of flag bytes in extended header should be one, but is {} ", (Object)numberOfFlagBytes);
                                }
                            } else {
                                LOGGER.error("Invalid extended header size: {}", (Object)extendedHeaderSize);
                            }
                        }
                        InputStream frameInputStream = unsyncUsed ? new UnsynchedInputStream(input) : input;
                        FramesReader frameReader = new FramesReader();
                        frameReader.readFrames(tag, frameInputStream, size);
                    } else {
                        tag = null;
                    }
                } else {
                    tag = null;
                }
            } else {
                tag = null;
            }
        }
        return tag;
    }
}

