/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.dihedron.core.License;
import org.dihedron.crypto.certificates.Certificates;
import org.dihedron.crypto.exceptions.CryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@License
public abstract class KeyRing
implements AutoCloseable {
    public static final String SIGNATURE_CRITICAL_EXTENSION_OID = "2.5.29.15";
    private static final Logger logger = LoggerFactory.getLogger(KeyRing.class);
    protected KeyStore keystore;

    @Override
    public void close() {
        this.keystore = null;
    }

    @Deprecated
    public KeyStore getKeyStore() {
        return this.keystore;
    }

    public List<String> enumerateAliases() throws CryptoException {
        ArrayList<String> aliases = null;
        try {
            Enumeration<String> enumeration = this.keystore.aliases();
            aliases = new ArrayList<String>();
            logger.debug("enumerating aliases...");
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                logger.debug("... alias: '{}'", (Object)alias);
                aliases.add(alias);
            }
        }
        catch (KeyStoreException e) {
            logger.error("error enumerating aliases in the keystore", (Throwable)e);
            throw new CryptoException("error enumerating aliases in the keystore", e);
        }
        return aliases;
    }

    public boolean isPrivateKeyAlias(String alias) throws CryptoException {
        try {
            return this.keystore.isKeyEntry(alias);
        }
        catch (KeyStoreException e) {
            logger.error("error checking alias '" + alias + "' with the keystore", (Throwable)e);
            throw new CryptoException("error checking alias '" + alias + "' with the keystore", e);
        }
    }

    public boolean isCertificateAlias(String alias) throws CryptoException {
        try {
            return this.keystore.isCertificateEntry(alias);
        }
        catch (KeyStoreException e) {
            logger.error("error checking alias '" + alias + "' with the keystore", (Throwable)e);
            throw new CryptoException("error checking alias '" + alias + "' with the keystore", e);
        }
    }

    public Key getPrivateKey(String alias) throws CryptoException {
        return this.getPrivateKey(alias, null);
    }

    public Key getPrivateKey(String alias, String password) throws CryptoException {
        try {
            Key key = this.keystore.getKey(alias, password != null ? password.toCharArray() : null);
            if (key instanceof PrivateKey) {
                return key;
            }
        }
        catch (UnrecoverableKeyException e) {
            logger.error("error recovering key for alias '" + alias + "' from the keystore", (Throwable)e);
            throw new CryptoException("error recovering key for alias '" + alias + "' from the keystore", e);
        }
        catch (KeyStoreException e) {
            logger.error("error accessing the keystore", (Throwable)e);
            throw new CryptoException("error accessing the keystore", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("invalid algorithm specified in keystore access", (Throwable)e);
            throw new CryptoException("invalid algorithm specified in keystore access", e);
        }
        return null;
    }

    public Key getPublicKey(String alias) throws CryptoException {
        return this.getPublicKey(alias, null);
    }

    public Key getPublicKey(String alias, String password) throws CryptoException {
        try {
            Key key = this.getPrivateKey(alias, password);
            if (key instanceof PrivateKey) {
                Certificate certificate = this.keystore.getCertificate(alias);
                return certificate.getPublicKey();
            }
        }
        catch (KeyStoreException e) {
            logger.error("error accessing the keystore", (Throwable)e);
            throw new CryptoException("error accessing the keystore", e);
        }
        return null;
    }

    public Certificate getCertificate(String alias) throws KeyStoreException {
        try {
            return this.keystore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            logger.error("error accessing the keystore", (Throwable)e);
            throw e;
        }
    }

    public KeyPair getKeyPair(String alias, String password) throws CryptoException {
        PrivateKey privateKey = (PrivateKey)this.getPrivateKey(alias, password);
        if (privateKey != null) {
            PublicKey publicKey = (PublicKey)this.getPublicKey(alias, password);
            return new KeyPair(publicKey, privateKey);
        }
        return null;
    }

    public List<String> getSignatureKeyAliases() throws KeyStoreException {
        try {
            ArrayList<String> signatureAliases = new ArrayList<String>();
            Enumeration<String> aliases = this.keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                try {
                    logger.debug("analysing alias: '{}'...", (Object)alias);
                    Certificate certificate = this.keystore.getCertificate(alias);
                    if (certificate instanceof X509Certificate) {
                        logger.debug(" - certificate      : 'X.509'");
                        if (Certificates.isNonRepudiationX509Certificate((X509Certificate)certificate) && Certificates.hasCriticalExtension((X509Certificate)certificate, SIGNATURE_CRITICAL_EXTENSION_OID)) {
                            logger.debug(" - good for signing : true");
                            signatureAliases.add(alias);
                            continue;
                        }
                        logger.debug(" - good for signing : false");
                        continue;
                    }
                    logger.debug(" - certificate      : 'plain'");
                    logger.debug(" - good for signing : false");
                }
                catch (KeyStoreException e) {
                    logger.error("error accessing certificate for alias '{}'", (Object)alias);
                }
            }
            return signatureAliases;
        }
        catch (KeyStoreException e) {
            logger.error("error accessing the keystore to enumerate aliases", (Throwable)e);
            throw e;
        }
    }

    public List<Certificate> getCertificateChain(String signatureAlias) throws KeyStoreException {
        int length;
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        Certificate[] certificates = this.keystore.getCertificateChain(signatureAlias);
        int n = length = certificates == null ? 0 : certificates.length;
        for (int i = 0; i < length; ++i) {
            list.add(certificates[i]);
        }
        return list;
    }

    public Certificate[] getCertificateChainAsArray(String signatureAlias) throws GeneralSecurityException {
        List<Certificate> chain = this.getCertificateChain(signatureAlias);
        if (chain != null && chain.size() > 0) {
            Certificate[] certificates = new Certificate[chain.size()];
            chain.toArray(certificates);
            return certificates;
        }
        return null;
    }
}

