/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.certificates;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dihedron.core.License;
import org.dihedron.core.url.URLFactory;
import org.dihedron.core.variables.SystemPropertyValueProvider;
import org.dihedron.core.variables.ValueProvider;
import org.dihedron.core.variables.Variables;
import org.dihedron.core.xml.DOM;
import org.dihedron.crypto.certificates.impl.Base64CertificateLoader;
import org.dihedron.crypto.exceptions.CertificateLoaderException;
import org.dihedron.crypto.exceptions.CryptoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@License
public final class TrustAnchors {
    private static final Logger logger = LoggerFactory.getLogger(TrustAnchors.class);
    private static final String CACERTS_PATH = "${java.home}/lib/security/cacerts";
    private static final String CACERTS_PASSWORD = "changeit";

    public static List<X509Certificate> fromJavaRootCAs() throws CryptoException {
        ArrayList<X509Certificate> trustAnchors = new ArrayList<X509Certificate>();
        try {
            String filename = Variables.replaceVariables((String)CACERTS_PATH, (ValueProvider[])new ValueProvider[]{new SystemPropertyValueProvider()});
            FileInputStream is = new FileInputStream(filename);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, CACERTS_PASSWORD.toCharArray());
            PKIXParameters parameters = new PKIXParameters(keystore);
            for (TrustAnchor trustAnchor : parameters.getTrustAnchors()) {
                X509Certificate certificate = trustAnchor.getTrustedCert();
                trustAnchors.add(certificate);
            }
            logger.trace("returning {} certificates as trust anchors", (Object)trustAnchors.size());
            return trustAnchors;
        }
        catch (CertificateException e) {
            logger.error("certificate exception", (Throwable)e);
            throw new CryptoException("certificate exception", e);
        }
        catch (KeyStoreException e) {
            logger.error("error acquiring or loading the key store", (Throwable)e);
            throw new CryptoException("error acquiring or loading the key store", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("key store loading requires unsupported algorithm", (Throwable)e);
            throw new CryptoException("key store loading requires unsupported algorithm", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            logger.error("PKIXParameters class does not support the key store algorithm", (Throwable)e);
            throw new CryptoException("PKIXParameters class does not support the key store algorithm", e);
        }
        catch (IOException e) {
            logger.error("error reading the key store from disk", (Throwable)e);
            throw new CryptoException("error reading the key store from disk", e);
        }
    }

    public static List<X509Certificate> fromTSL(String tslURL) throws MalformedURLException {
        ArrayList<X509Certificate> trustAnchors = new ArrayList<X509Certificate>();
        logger.trace("acquiring root CAs from TSL '{}'", (Object)tslURL);
        URL url = URLFactory.makeURL((String)tslURL);
        try (InputStream stream = url.openStream();){
            logger.trace("stream opened");
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            logger.trace("XML document builder ready, reading");
            Document document = builder.parse(stream);
            logger.trace("XML read and parsed");
            List nodes = DOM.getDescendantsByTagName((Document)document, (String)"X509Certificate");
            logger.trace("{} nodes found", (Object)nodes.size());
            Base64CertificateLoader loader = new Base64CertificateLoader();
            for (Element node : nodes) {
                String data = node.getTextContent();
                try {
                    X509Certificate certificate = (X509Certificate)loader.loadCertificate(data);
                    trustAnchors.add(certificate);
                }
                catch (Exception e) {
                    logger.warn("discarding invalid (unparseable) certificate data '{}'", (Object)data);
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error("error acquiring TSL from '" + tslURL + "'", (Throwable)e);
            trustAnchors = null;
        }
        catch (CertificateLoaderException e) {
            logger.error("error initialising certificate loader", (Throwable)e);
            trustAnchors = null;
        }
        return trustAnchors;
    }

    private TrustAnchors() {
    }
}

