/*
 * Decompiled with CFR 0.152.
 */
package org.dihedron.crypto.certificates.impl;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.dihedron.core.License;
import org.dihedron.crypto.certificates.CertificateLoader;
import org.dihedron.crypto.exceptions.CertificateLoaderException;

@License
public class Base64CertificateLoader
implements CertificateLoader {
    public static final String BASE64 = "base64";
    private CertificateFactory certificateFactory;

    public Base64CertificateLoader() throws CertificateLoaderException {
        try {
            this.certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new CertificateLoaderException("error instantiating the certificate factory", e);
        }
    }

    public byte[] loadCertificateData(String base64) throws CertificateLoaderException {
        Properties properties = new Properties();
        properties.put(BASE64, base64);
        return this.loadCertificateData(properties);
    }

    public Certificate loadCertificate(String base64) throws CertificateLoaderException {
        Properties properties = new Properties();
        properties.put(BASE64, base64);
        return this.loadCertificate(properties);
    }

    @Override
    public Certificate loadCertificate(Properties properties) throws CertificateLoaderException {
        X509Certificate x509certificate = null;
        byte[] data = this.loadCertificateData(properties);
        if (data != null) {
            try {
                x509certificate = (X509Certificate)this.certificateFactory.generateCertificate(new ByteArrayInputStream(data));
            }
            catch (CertificateException e) {
                throw new CertificateLoaderException("error parsing certificate", e);
            }
        }
        return x509certificate;
    }

    @Override
    public byte[] loadCertificateData(Properties properties) throws CertificateLoaderException {
        String base64 = properties.getProperty(BASE64);
        return DatatypeConverter.parseBase64Binary((String)base64);
    }
}

